/*
 * Decompiled with CFR 0.152.
 */
package timefall.mcsa.init;

import dev.architectury.event.events.common.LootEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import timefall.mcsa.collections.ArmorCollection;
import timefall.mcsa.collections.ArmorCollectionHelmetOnly;
import timefall.mcsa.configs.McsaConfig;
import timefall.mcsa.init.ArmorsInit;
import timefall.mcsa.items.armor.ArmorSetItem;
import timefall.mcsa.items.armor.ArmorSets;

public class LootInit {
    public static final Collection<ResourceLocation> VILLAGER_ARMORER_LOOT_TABLE = Collections.singletonList(BuiltInLootTables.f_78745_);
    public static final Collection<ResourceLocation> STRONGHOLD_LOOT_TABLES = Set.of(BuiltInLootTables.f_78763_, BuiltInLootTables.f_78762_, BuiltInLootTables.f_78761_);
    public static final Collection<ResourceLocation> TEMPLE_LOOT_TABLES = Set.of(BuiltInLootTables.f_78686_, BuiltInLootTables.f_78764_);
    public static final Collection<ResourceLocation> ARMORER_GIFT_LOOT_TABLE = Collections.singletonList(BuiltInLootTables.f_78725_);

    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register((lootTables, id, context, builtin) -> {
            LootPool.Builder builder = LootPool.m_79043_();
            builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            builder.m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f));
            if (VILLAGER_ARMORER_LOOT_TABLE.contains(id)) {
                LootInit.addArmorSet(builder, ArmorsInit.ELLEGAARD_ARMOR, ArmorSets.ELLEGAARD, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.GABRIEL_ARMOR, ArmorSets.GABRIEL, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.IVOR_ARMOR, ArmorSets.IVOR, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.LUKAS_ARMOR, ArmorSets.LUKAS, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.MAGNUS_ARMOR, ArmorSets.MAGNUS, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.OLIVIA_ARMOR, ArmorSets.OLIVIA, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.PETRA_ARMOR, ArmorSets.PETRA, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.SOREN_ARMOR, ArmorSets.SOREN, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.HARPERS_HEADSET, ArmorSets.HARPERS_HEADSET, McsaConfig.config.getCharacterArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.TIM_ARMOR, ArmorSets.TIMS_ARMOR, McsaConfig.config.getCharacterArmorSpawnRate());
            } else if (STRONGHOLD_LOOT_TABLES.contains(id)) {
                LootInit.addArmorSet(builder, ArmorsInit.DRAGONSBANE, ArmorSets.DRAGONSBANE, McsaConfig.config.getStrongholdArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.ENDER_DEFENDER, ArmorSets.ENDER_DEFENDER, McsaConfig.config.getStrongholdArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.GOLDEN_GOLIATH_ARMOR, ArmorSets.GOLDEN_GOLIATH, McsaConfig.config.getStrongholdArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.GOLDEN_GOLIATH_CIRCUITRY_ARMOR, ArmorSets.GOLDEN_GOLIATH_CIRCUITRY, McsaConfig.config.getStrongholdArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.REDSTONE_RIOT, ArmorSets.REDSTONE_RIOT, McsaConfig.config.getStrongholdArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.PRISMARINE_SOLDIER_ARMOR, ArmorSets.PRISMARINE, McsaConfig.config.getStrongholdArmorSpawnRate());
            } else if (TEMPLE_LOOT_TABLES.contains(id)) {
                LootInit.addArmorSet(builder, ArmorsInit.SHIELD_OF_INFINITY, ArmorSets.SHIELD_OF_INFINITY, McsaConfig.config.getTempleArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.STAR_SHIELD, ArmorSets.STAR_SHIELD, McsaConfig.config.getTempleArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.SWORDBREAKER, ArmorSets.SWORDBREAKER, McsaConfig.config.getTempleArmorSpawnRate());
            } else if (ARMORER_GIFT_LOOT_TABLE.contains(id)) {
                LootInit.addArmorSet(builder, ArmorsInit.ADAMANTIUM_ARMOR, ArmorSets.ADAMANTIUM, McsaConfig.config.getHovArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.CHAMPION_PETRA_ARMOR, ArmorSets.CHAMPION_PETRA, McsaConfig.config.getHovArmorSpawnRate());
                LootInit.addArmorSet(builder, ArmorsInit.NINJA_IVOR_ARMOR, ArmorSets.NINJA_IVOR_ARMOR, McsaConfig.config.getHovArmorSpawnRate());
            }
            context.addPool(builder.m_79082_());
        });
    }

    public static void addArmorSet(LootPool.Builder poolBuilder, ArmorCollection<ArmorSetItem> armorCollection, ArmorSets armorSets, int p) {
        if (McsaConfig.config.ENABLE_ARMOR_SET.get((Object)armorSets).booleanValue()) {
            armorCollection.getArmor().forEach(armorSetItem -> poolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)armorSetItem).m_79707_(p)));
        }
    }

    public static void addArmorSet(LootPool.Builder poolBuilder, ArmorCollectionHelmetOnly<ArmorSetItem> armorCollection, ArmorSets armorSets, int p) {
        if (McsaConfig.config.ENABLE_ARMOR_SET.get((Object)armorSets).booleanValue()) {
            armorCollection.getArmorHelmetOnly().forEach(armorSetItem -> poolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)armorSetItem).m_79707_(p)));
        }
    }
}

