/*
 * Decompiled with CFR 0.152.
 */
package timefall.mcsa.collections;

import com.google.common.collect.ImmutableList;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import timefall.mcsa.configs.McsaConfig;
import timefall.mcsa.factories.ArmorItemFactory;
import timefall.mcsa.init.ArmorsInit;
import timefall.mcsa.items.armor.ArmorSetItem;
import timefall.mcsa.items.armor.ArmorSets;

public class ArmorCollectionHelmetOnly<T extends ArmorSetItem> {
    private final RegistrySupplier<T> helmet;

    public ArmorCollectionHelmetOnly(RegistrySupplier<T> helmet) {
        this.helmet = helmet;
    }

    public static ArmorCollectionHelmetOnly<ArmorSetItem> registerArmorCollectionHelmetOnly(ArmorSets sets, EnumSet<EquipmentSlot> equipmentSlots) {
        return ArmorCollectionHelmetOnly.registerArmorCollectionHelmetOnly(sets, ArmorItemFactory.DEFAULT);
    }

    public static <T extends ArmorSetItem> ArmorCollectionHelmetOnly<T> registerArmorCollectionHelmetOnly(ArmorSets sets, ArmorItemFactory<T> factory) {
        if (McsaConfig.config.ENABLE_ARMOR_SET.get((Object)sets).booleanValue()) {
            return new ArmorCollectionHelmetOnly<T>(ArmorsInit.ARMOR.register(sets.getSetName() + "_helmet", () -> factory.create(sets, EquipmentSlot.HEAD)));
        }
        return null;
    }

    public T getHelmet() {
        return (T)((Object)((ArmorSetItem)((Object)this.helmet.get())));
    }

    public List<T> getArmorHelmetOnly() {
        return ImmutableList.of(this.getHelmet());
    }
}

