/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import shadows.gateways.GatewayObjects;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.event.GateEvent;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.placebo.json.RandomAttributeModifier;

public record Wave(List<WaveEntity> entities, List<RandomAttributeModifier> modifiers, List<Reward> rewards, int maxWaveTime, int setupTime) {
    public static Codec<Wave> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.listOf().fieldOf("entities").forGetter(Wave::entities), (App)RandomAttributeModifier.CODEC.listOf().optionalFieldOf("modifiers", Collections.emptyList()).forGetter(Wave::modifiers), (App)Reward.CODEC.listOf().optionalFieldOf("rewards", Collections.emptyList()).forGetter(Wave::rewards), (App)Codec.INT.fieldOf("max_wave_time").forGetter(Wave::maxWaveTime), (App)Codec.INT.fieldOf("setup_time").forGetter(Wave::setupTime)).apply((Applicative)inst, Wave::new));

    public List<LivingEntity> spawnWave(ServerLevel level, Vec3 pos, GatewayEntity gate) {
        ArrayList<LivingEntity> spawned = new ArrayList<LivingEntity>();
        for (WaveEntity toSpawn : this.entities) {
            Vec3 spawnPos = gate.getGateway().getSpawnAlgo().spawn(level, pos, gate, toSpawn);
            LivingEntity entity = toSpawn.createEntity((Level)level);
            if (spawnPos == null || entity == null) {
                gate.onFailure(spawned, GatewayEntity.FailureReason.SPAWN_FAILED);
                break;
            }
            entity.getPersistentData().m_128362_("gateways.owner", gate.m_20148_());
            entity.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), level.f_46441_.m_188501_() * 360.0f, level.f_46441_.m_188501_() * 360.0f);
            entity.m_142429_().filter(e -> e instanceof LivingEntity).map(LivingEntity.class::cast).forEach(e -> {
                this.modifiers.forEach(m -> m.apply(level.f_46441_, e));
                e.m_21153_(entity.m_21233_());
                e.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 100, true, false));
            });
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (toSpawn.shouldFinalizeSpawn() && !ForgeEventFactory.doSpecialSpawn((Mob)((Mob)entity), (LevelAccessor)level, (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.SPAWNER)) {
                    mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(entity.m_20183_()), MobSpawnType.SPAWNER, null, null);
                }
                mob.m_6710_((LivingEntity)gate.m_9236_().m_45930_((Entity)gate, 12.0));
                mob.m_21530_();
            }
            MinecraftForge.EVENT_BUS.post((Event)new GateEvent.WaveEntitySpawned(gate, entity));
            level.m_47205_((Entity)entity);
            level.m_6263_(null, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), (SoundEvent)GatewayObjects.GATE_WARP.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
            spawned.add(entity);
            gate.spawnParticle(gate.getGateway().getColor(), entity.m_20185_() + (double)(entity.m_20205_() / 2.0f), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_() + (double)(entity.m_20205_() / 2.0f), 0);
        }
        return spawned;
    }

    public List<ItemStack> spawnRewards(ServerLevel level, GatewayEntity gate, Player summoner) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.rewards.forEach(r -> r.generateLoot(level, gate, summoner, s -> {
            if (!s.m_41619_()) {
                stacks.add((ItemStack)s);
            }
        }));
        return stacks;
    }
}

