/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import shadows.gateways.GatewayObjects;
import shadows.gateways.client.GatewayParticle;
import shadows.gateways.client.GatewayRenderer;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Failure;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.gateways.item.GatePearlItem;
import shadows.placebo.PlaceboClient;
import shadows.placebo.json.RandomAttributeModifier;
import shadows.placebo.util.AttributeHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="gateways")
public class GatewaysClient {
    private static int waveIdx = 0;
    private static ItemStack currentTooltipItem = ItemStack.f_41583_;
    private static long tooltipTick = 0L;
    static RandomSource rand = RandomSource.m_216327_();
    public static final ResourceLocation BARS = new ResourceLocation("textures/gui/bars.png");

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> ItemProperties.register((Item)((Item)GatewayObjects.GATE_PEARL.get()), (ResourceLocation)new ResourceLocation("gateways", "size"), (stack, level, entity, seed) -> {
            Gateway gate = GatePearlItem.getGate(stack);
            if (gate == null) {
                return 2.0f;
            }
            return gate.getSize().ordinal();
        }));
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::bossRenderPre);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::tooltip);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::scroll);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::scroll2);
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> {
            Gateway gate = GatePearlItem.getGate(stack);
            if (gate != null) {
                return gate.getColor().m_131265_();
            }
            return 0xAAAAFF;
        }, new ItemLike[]{(ItemLike)GatewayObjects.GATE_PEARL.get()});
    }

    @SubscribeEvent
    public static void eRenders(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)GatewayObjects.GATEWAY.get(), GatewayRenderer::new);
    }

    @SubscribeEvent
    public static void factories(RegisterParticleProvidersEvent e) {
        e.register((ParticleType)GatewayObjects.GLOW.get(), GatewayParticle.Factory::new);
    }

    @SubscribeEvent
    public static void stitch(TextureStitchEvent.Pre e) {
        if (e.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            e.addSprite(new ResourceLocation("gateways", "particle/glow"));
        }
    }

    public static void scroll(ScreenEvent.MouseScrolled.Pre e) {
        if (currentTooltipItem.m_41720_() == GatewayObjects.GATE_PEARL.get() && tooltipTick == PlaceboClient.ticks && Screen.m_96638_()) {
            waveIdx += e.getScrollDelta() < 0.0 ? 1 : -1;
            e.setCanceled(true);
        } else {
            waveIdx = 0;
        }
    }

    public static void scroll2(InputEvent.MouseScrollingEvent e) {
        if (currentTooltipItem.m_41720_() == GatewayObjects.GATE_PEARL.get() && tooltipTick == PlaceboClient.ticks && Screen.m_96638_()) {
            waveIdx += e.getScrollDelta() < 0.0 ? 1 : -1;
            e.setCanceled(true);
        } else {
            waveIdx = 0;
        }
    }

    public static void tooltip(ItemTooltipEvent e) {
        currentTooltipItem = e.getItemStack();
        tooltipTick = PlaceboClient.ticks;
        if (e.getItemStack().m_41720_() == GatewayObjects.GATE_PEARL.get()) {
            MutableComponent comp;
            Gateway gate = GatePearlItem.getGate(e.getItemStack());
            List tooltips = e.getToolTip();
            if (gate == null) {
                tooltips.add(Component.m_237113_((String)"Errored Gate Pearl, file a bug report detailing how you obtained this."));
                return;
            }
            if (Screen.m_96638_()) {
                int wave = waveIdx = Math.floorMod(waveIdx, gate.getNumWaves());
                MutableComponent sub = Component.m_237115_((String)"tooltip.gateways.scroll").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(false)));
                comp = Component.m_237110_((String)"tooltip.gateways.wave", (Object[])new Object[]{wave + 1, gate.getNumWaves(), sub}).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
                tooltips.add(comp);
                tooltips.add(Component.m_130674_(null));
                comp = Component.m_237115_((String)"tooltip.gateways.entities").m_130940_(ChatFormatting.BLUE);
                tooltips.add(comp);
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                for (WaveEntity waveEntity : gate.getWave(wave).entities()) {
                    counts.put(waveEntity.getDescription().getString(), counts.getOrDefault(waveEntity.getDescription().getString(), 0) + 1);
                }
                for (Map.Entry entry : counts.entrySet()) {
                    comp = Component.m_237110_((String)"tooltip.gateways.list1", (Object[])new Object[]{entry.getValue(), Component.m_237115_((String)((String)entry.getKey()))}).m_130940_(ChatFormatting.BLUE);
                    tooltips.add(comp);
                }
                if (!gate.getWave(wave).modifiers().isEmpty()) {
                    comp = Component.m_237115_((String)"tooltip.gateways.modifiers").m_130940_(ChatFormatting.RED);
                    tooltips.add(comp);
                    for (RandomAttributeModifier randomAttributeModifier : gate.getWave(wave).modifiers()) {
                        comp = AttributeHelper.toComponent((Attribute)randomAttributeModifier.getAttribute(), (AttributeModifier)randomAttributeModifier.createDeterministic());
                        comp = Component.m_237110_((String)"tooltip.gateways.list2", (Object[])new Object[]{comp.getString()}).m_130940_(ChatFormatting.RED);
                        tooltips.add(comp);
                    }
                }
                comp = Component.m_237115_((String)"tooltip.gateways.rewards").m_130940_(ChatFormatting.GOLD);
                tooltips.add(comp);
                for (Reward reward : gate.getWave(wave).rewards()) {
                    reward.appendHoverText(c -> tooltips.add(Component.m_237110_((String)"tooltip.gateways.list2", (Object[])new Object[]{c}).m_130940_(ChatFormatting.GOLD)));
                }
            } else {
                comp = Component.m_237115_((String)"tooltip.gateways.shift").m_130940_(ChatFormatting.GREEN);
                tooltips.add(comp);
            }
            if (Screen.m_96637_()) {
                comp = Component.m_237115_((String)"tooltip.gateways.completion").m_130948_(Style.f_131099_.m_178520_(0xFCFF00).m_131162_(Boolean.valueOf(true)));
                tooltips.add(comp);
                tooltips.add(Component.m_130674_(null));
                comp = Component.m_237110_((String)"tooltip.gateways.experience", (Object[])new Object[]{gate.getCompletionXp()}).m_130948_(Style.f_131099_.m_178520_(0xFCFF00));
                tooltips.add(comp);
                for (Reward r : gate.getRewards()) {
                    r.appendHoverText(c -> tooltips.add(Component.m_237110_((String)"tooltip.gateways.list2", (Object[])new Object[]{c}).m_130948_(Style.f_131099_.m_178520_(0xFCFF00))));
                }
            } else {
                comp = Component.m_237115_((String)"tooltip.gateways.ctrl").m_130948_(Style.f_131099_.m_178520_(0xFCFF00));
                tooltips.add(comp);
            }
            if (!gate.getFailures().isEmpty()) {
                if (Screen.m_96639_()) {
                    comp = Component.m_237115_((String)"tooltip.gateways.failure").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131162_(Boolean.valueOf(true)));
                    tooltips.add(comp);
                    tooltips.add(Component.m_130674_(null));
                    for (Failure f : gate.getFailures()) {
                        f.appendHoverText(c -> tooltips.add(Component.m_237110_((String)"tooltip.gateways.list2", (Object[])new Object[]{c}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED))));
                    }
                } else {
                    comp = Component.m_237115_((String)"tooltip.gateways.alt").m_130940_(ChatFormatting.DARK_RED);
                    tooltips.add(comp);
                }
            }
            if (gate.playerDamageOnly()) {
                tooltips.add(Component.m_237115_((String)"tooltip.gateways.player_damage_only").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
            }
            if (gate.allowsDiscarding()) {
                tooltips.add(Component.m_237115_((String)"tooltip.gateways.allows_discarding").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            }
        }
    }

    public static void bossRenderPre(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent boss = event.getBossEvent();
        String name = boss.m_18861_().getString();
        if (name.startsWith("GATEWAY_ID")) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            event.setCanceled(true);
            Entity entity = level.m_6815_(Integer.valueOf(name.substring(10)).intValue());
            if (entity instanceof GatewayEntity) {
                int i;
                GatewayEntity gate = (GatewayEntity)entity;
                int color = gate.getGateway().getColor().m_131265_();
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                RenderSystem.m_157429_((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)BARS);
                PoseStack stack = event.getPoseStack();
                int wave = gate.getWave() + 1;
                int maxWave = gate.getGateway().getNumWaves();
                int enemies = gate.getActiveEnemies();
                int maxEnemies = gate.getCurrentWave().entities().size();
                int x = event.getX();
                int y = event.getY();
                int y2 = y + event.getIncrement();
                Gui.m_93143_((PoseStack)stack, (int)x, (int)y, (int)200, (float)0.0f, (float)60.0f, (int)182, (int)5, (int)256, (int)256);
                Gui.m_93143_((PoseStack)stack, (int)x, (int)y2, (int)200, (float)0.0f, (float)60.0f, (int)182, (int)5, (int)256, (int)256);
                float waveProgress = 1.0f / (float)maxWave;
                float progress = waveProgress * (float)(maxWave - wave + 1);
                if (gate.isWaveActive()) {
                    progress -= waveProgress * ((float)(maxEnemies - enemies) / (float)maxEnemies);
                }
                if ((i = (int)(progress * 183.0f)) > 0) {
                    Gui.m_93143_((PoseStack)stack, (int)x, (int)y, (int)200, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
                }
                float maxTime = gate.getCurrentWave().maxWaveTime();
                if (gate.isWaveActive()) {
                    i = (int)((maxTime - (float)gate.getTicksActive()) / maxTime * 183.0f);
                    if (i > 0) {
                        Gui.m_93143_((PoseStack)stack, (int)x, (int)y2, (int)200, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
                    }
                } else {
                    maxTime = gate.getCurrentWave().setupTime();
                    i = (int)((float)gate.getTicksActive() / maxTime * 183.0f);
                    if (i > 0) {
                        Gui.m_93143_((PoseStack)stack, (int)x, (int)y2, (int)200, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
                    }
                }
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Font font = Minecraft.m_91087_().f_91062_;
                int width = Minecraft.m_91087_().m_91268_().m_85445_();
                MutableComponent component = Component.m_237113_((String)gate.m_7770_().getString()).m_130940_(ChatFormatting.GOLD);
                int strWidth = font.m_92852_((FormattedText)component);
                int textX = width / 2 - strWidth / 2;
                int textY = y - 9;
                font.m_92763_(stack, (Component)component, (float)textX, (float)textY, 0xFFFFFF);
                event.setIncrement(event.getIncrement() * 2);
                textY = y2 - 9;
                int time = (int)maxTime - gate.getTicksActive();
                String str = I18n.m_118938_((String)"boss.gateways.wave", (Object[])new Object[]{wave, maxWave, StringUtil.m_14404_((int)time), enemies});
                if (!gate.isWaveActive()) {
                    str = gate.isLastWave() ? I18n.m_118938_((String)"boss.gateways.done", (Object[])new Object[0]) : I18n.m_118938_((String)"boss.gateways.starting", (Object[])new Object[]{wave, StringUtil.m_14404_((int)time)});
                }
                component = Component.m_237113_((String)str).m_130940_(ChatFormatting.GREEN);
                strWidth = font.m_92852_((FormattedText)component);
                textX = width / 2 - strWidth / 2;
                font.m_92763_(stack, (Component)component, (float)textX, (float)textY, 0xFFFFFF);
            }
        }
    }
}

