/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.platform;

import com.tom.storagemod.Content;
import com.tom.storagemod.util.GameObject;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class Platform {
    public static final GameObject.GameRegistry<Item> ITEMS = new GameObject.GameRegistry(ForgeRegistries.ITEMS);
    public static final GameObject.GameRegistry<Block> BLOCKS = new GameObject.GameRegistry(ForgeRegistries.BLOCKS);
    public static final GameObject.GameRegistryBE BLOCK_ENTITY = new GameObject.GameRegistryBE();
    public static final GameObject.GameRegistry<MenuType<?>> MENU_TYPE = new GameObject.GameRegistry(ForgeRegistries.MENU_TYPES);
    public static final CreativeModeTab STORAGE_MOD_TAB = new CreativeModeTab("toms_storage.tab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Content.terminal.get());
        }
    };
    private static boolean curios = ModList.get().isLoaded("curios");

    public static Item.Properties itemProp() {
        return new Item.Properties().m_41491_(STORAGE_MOD_TAB);
    }

    public static <I extends Item> I registerItem(I item) {
        return item;
    }

    public static void register() {
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY.register();
        MENU_TYPE.register();
    }

    public static BlockState readBlockState(Level level, CompoundTag tag) {
        return NbtUtils.m_129241_((CompoundTag)tag);
    }

    public static Level getDimension(Level worldIn, ResourceLocation dim) {
        return worldIn.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dim));
    }

    public static ResourceLocation getItemId(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static void writeItemId(FriendlyByteBuf buf, Item item) {
        buf.m_236818_((IdMap)Registry.f_122827_, (Object)item);
    }

    public static Item readItemId(FriendlyByteBuf buf) {
        return (Item)buf.m_236816_((IdMap)Registry.f_122827_);
    }

    public static CompoundTag getSyncTag(ItemStack stack) {
        Item item = stack.m_41720_();
        CompoundTag compoundtag = null;
        if (item.isDamageable(stack) || item.m_41468_()) {
            compoundtag = stack.getShareTag();
        }
        return compoundtag;
    }

    public static InteractionResult checkUse(Level worldIn, BlockHitResult lookingAt, Player playerIn, InteractionHand handIn) {
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(playerIn, handIn, lookingAt.m_82425_(), lookingAt);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        return null;
    }

    public static <C extends Container> ItemStack assembleRecipe(Level level, C container, Recipe<C> recipe) {
        return recipe.m_5874_(container);
    }

    public static <M extends AbstractContainerMenu> MenuType<M> createMenuType(MenuType.MenuSupplier<M> create) {
        return new MenuType(create);
    }

    public static <T> T checkExtraSlots(Player player, Predicate<ItemStack> is, T def, Function<ItemStack, T> map) {
        List s;
        if (curios && !(s = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, is)).isEmpty()) {
            return map.apply(((SlotResult)s.get(0)).stack());
        }
        return def;
    }
}

