/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.tracking.benefits;

import com.tarinoita.solsweetpotato.tracking.benefits.Benefit;
import com.tarinoita.solsweetpotato.tracking.benefits.EffectBenefitsCapability;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public final class EffectBenefit
extends Benefit {
    private MobEffect effect;
    private final int DEFAULT_DURATION = 300;
    private final int REAPPLY_DURATION = 200;

    public EffectBenefit(String name, double value, double threshold, boolean detriment) {
        super("effect", name, value, threshold, detriment);
    }

    @Override
    public void applyTo(Player player) {
        if (!this.checkUsage() || player.f_19853_.f_46443_) {
            return;
        }
        EffectBenefitsCapability effectBenefits = EffectBenefitsCapability.get(player);
        effectBenefits.addEffectBenefitUnique(this);
    }

    public void onTick(Player player) {
        if (!this.checkUsage() || player.f_19853_.f_46443_) {
            return;
        }
        MobEffectInstance currentEffect = player.m_21124_(this.effect);
        if (currentEffect != null && currentEffect.m_19564_() >= (int)this.value && currentEffect.m_19557_() > 200) {
            return;
        }
        player.m_7292_(new MobEffectInstance(this.effect, 300, (int)this.value, false, false));
    }

    @Override
    public void removeFrom(Player player) {
        if (!this.checkUsage() || player.f_19853_.f_46443_) {
            return;
        }
        EffectBenefitsCapability effectBenefits = EffectBenefitsCapability.get(player);
        effectBenefits.removeEffectBenefit(this);
    }

    private boolean checkUsage() {
        if (this.invalid) {
            return false;
        }
        if (this.effect == null) {
            this.createEffect();
            return !this.invalid;
        }
        return true;
    }

    private void createEffect() {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(Registry.f_122900_);
        try {
            this.effect = (MobEffect)registry.getValue(new ResourceLocation(this.name));
        }
        catch (ResourceLocationException e) {
            this.markInvalid();
            return;
        }
        if (this.effect == null) {
            this.markInvalid();
            return;
        }
        if (this.value < 0.0 || this.value > 255.0) {
            this.markInvalid();
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        StringTag type = StringTag.m_129297_((String)this.benefitType);
        StringTag n = StringTag.m_129297_((String)this.name);
        DoubleTag v = DoubleTag.m_128500_((double)this.value);
        DoubleTag thresh = DoubleTag.m_128500_((double)this.threshold);
        ByteTag detr = ByteTag.m_128266_((byte)((byte)(this.detriment ? 1 : 0)));
        tag.m_128365_("type", (Tag)type);
        tag.m_128365_("name", (Tag)n);
        tag.m_128365_("value", (Tag)v);
        tag.m_128365_("threshold", (Tag)thresh);
        tag.m_128365_("detriment", (Tag)detr);
        return tag;
    }

    public static EffectBenefit fromNBT(CompoundTag tag) {
        String type = tag.m_128461_("type");
        if (!type.equals("effect")) {
            throw new RuntimeException("Mismatching benefit type");
        }
        String n = tag.m_128461_("name");
        double v = tag.m_128459_("value");
        double thresh = tag.m_128459_("threshold");
        boolean detr = tag.m_128445_("detriment") == 1;
        return new EffectBenefit(n, v, thresh, detr);
    }
}

