/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.item.foodcontainer;

import com.tarinoita.solsweetpotato.integration.Origins;
import com.tarinoita.solsweetpotato.item.foodcontainer.FoodContainerCapabilityProvider;
import com.tarinoita.solsweetpotato.item.foodcontainer.FoodContainerProvider;
import com.tarinoita.solsweetpotato.tracking.FoodList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class FoodContainerItem
extends Item {
    private String displayName;
    private int nslots;

    public FoodContainerItem(int nslots, String displayName) {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1).setNoRepair());
        this.displayName = displayName;
        this.nslots = nslots;
    }

    public boolean m_41472_() {
        return true;
    }

    public FoodProperties m_41473_() {
        return new FoodProperties.Builder().m_38767_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_ && player.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new FoodContainerProvider(this.displayName), (BlockPos)player.m_20183_());
        }
        if (!player.m_6047_()) {
            return this.processRightClick(world, player, hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    private InteractionResultHolder<ItemStack> processRightClick(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (FoodContainerItem.isInventoryEmpty(stack) || ModList.get().isLoaded("origins") && Origins.hasRestrictedDiet(player)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_36391_(false)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private static boolean isInventoryEmpty(ItemStack container) {
        ItemStackHandler handler = FoodContainerItem.getInventory(container);
        if (handler == null) {
            return true;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_41614_()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FoodContainerCapabilityProvider(stack, this.nslots);
    }

    @Nullable
    public static ItemStackHandler getInventory(ItemStack bag) {
        if (bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return (ItemStackHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
        }
        return null;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ItemStackHandler handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return stack;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return stack;
        }
        ItemStack bestFood = handler.getStackInSlot(bestFoodSlot);
        ItemStack foodCopy = bestFood.m_41777_();
        if (bestFood.m_41614_() && !bestFood.m_41619_()) {
            ItemStack result = bestFood.m_41671_(world, entity);
            if (!result.m_41614_()) {
                handler.setStackInSlot(bestFoodSlot, ItemStack.f_41583_);
                Player playerEntity = (Player)entity;
                if (!playerEntity.m_150109_().m_36054_(result)) {
                    playerEntity.m_36176_(result, false);
                }
            }
            if (!world.f_46443_) {
                ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)foodCopy, (int)0, (ItemStack)result);
            }
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public static int getBestFoodSlot(ItemStackHandler handler, Player player) {
        FoodList foodList = FoodList.get(player);
        double maxDiversity = -1.7976931348623157E308;
        int bestFoodSlot = -1;
        for (int i = 0; i < handler.getSlots(); ++i) {
            double diversityChange;
            ItemStack food = handler.getStackInSlot(i);
            if (!food.m_41614_() || food.m_41619_() || !((diversityChange = foodList.simulateFoodAdd(food.m_41720_())) > maxDiversity)) continue;
            maxDiversity = diversityChange;
            bestFoodSlot = i;
        }
        return bestFoodSlot;
    }
}

