/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.client.gui;

import com.tarinoita.solsweetpotato.client.gui.FoodBookScreen;
import com.tarinoita.solsweetpotato.client.gui.Page;
import com.tarinoita.solsweetpotato.client.gui.elements.UILabel;
import com.tarinoita.solsweetpotato.lib.Localization;
import com.tarinoita.solsweetpotato.tracking.benefits.BenefitInfo;
import com.tarinoita.solsweetpotato.utils.RomanNumber;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class BenefitsPage
extends Page {
    private static final int BENEFITS_PER_PAGE = 3;
    private final Color activeColor;

    private BenefitsPage(Rectangle frame, String header, List<BenefitInfo> benefitInfo, Color activeColor) {
        super(frame, header);
        this.activeColor = activeColor;
        for (BenefitInfo info : benefitInfo) {
            this.addBenefitInfo(info);
        }
    }

    public static List<BenefitsPage> pages(Rectangle frame, String header, List<BenefitInfo> benefitInfo, Color activeColor) {
        ArrayList<BenefitsPage> pages = new ArrayList<BenefitsPage>();
        for (int startIndex = 0; startIndex < benefitInfo.size(); startIndex += 3) {
            int endIndex = Math.min(startIndex + 3, benefitInfo.size());
            pages.add(new BenefitsPage(frame, header, benefitInfo.subList(startIndex, endIndex), activeColor));
        }
        return pages;
    }

    private void addBenefitInfo(BenefitInfo info) {
        String thresh = "" + info.threshold;
        Object name = info.name;
        double value = info.value;
        if (info.type.equals("effect")) {
            name = this.getEffectName((String)name);
            int amplifier = (int)value;
            name = (String)name + " " + RomanNumber.toRoman(amplifier + 1);
        } else if (info.type.equals("attribute")) {
            name = this.getAttributeName((String)name);
            String op = "+";
            if (value < 0.0) {
                op = "-";
            }
            String modifierValue = op + Math.abs(value);
            name = (String)name + " " + modifierValue;
        }
        UILabel thresholdLabel = new UILabel(Localization.localized("gui", "food_book.benefits.threshold_label", new Object[0]) + ": " + thresh);
        thresholdLabel.color = this.activeColor;
        if (this.activeColor.equals(FoodBookScreen.activeGreen)) {
            thresholdLabel.tooltip = Localization.localized("gui", "food_book.benefits.active_tooltip", new Object[0]);
        } else if (this.activeColor.equals(FoodBookScreen.inactiveRed)) {
            thresholdLabel.tooltip = Localization.localized("gui", "food_book.benefits.inactive_tooltip", new Object[0]);
        }
        UILabel nameLabel = new UILabel((String)name);
        nameLabel.color = FoodBookScreen.lessBlack;
        this.mainStack.addChild(thresholdLabel);
        this.mainStack.addChild(nameLabel);
        this.mainStack.addChild(this.makeSeparatorLine());
        this.updateMainStack();
    }

    private String getAttributeName(String name) {
        Attribute attribute;
        try {
            attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(name));
        }
        catch (ResourceLocationException e) {
            return "Invalid: " + name;
        }
        if (attribute == null) {
            return "Invalid: " + name;
        }
        return I18n.m_118938_((String)attribute.m_22087_(), (Object[])new Object[0]);
    }

    private String getEffectName(String name) {
        MobEffect effect;
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(Registry.f_122900_);
        try {
            effect = (MobEffect)registry.getValue(new ResourceLocation(name));
        }
        catch (ResourceLocationException e) {
            return "Invalid: " + name;
        }
        if (effect == null) {
            return "Invalid: " + name;
        }
        return I18n.m_118938_((String)effect.m_19482_().getString(), (Object[])new Object[0]);
    }
}

