/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.gui.TransparentButton;
import com.chaosthedude.explorerscompass.gui.TransparentTextField;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.CompassSearchPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.chaosthedude.explorerscompass.sorting.ISorting;
import com.chaosthedude.explorerscompass.sorting.NameSorting;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExplorersCompassScreen
extends Screen {
    private Level level;
    private Player player;
    private List<ResourceLocation> allowedStructureKeys;
    private List<ResourceLocation> structureKeysMatchingSearch;
    private ItemStack stack;
    private ExplorersCompassItem explorersCompass;
    private Button searchButton;
    private Button searchGroupButton;
    private Button sortByButton;
    private Button teleportButton;
    private Button cancelButton;
    private TransparentTextField searchTextField;
    private StructureSearchList selectionList;
    private ISorting sortingCategory;

    public ExplorersCompassScreen(Level level, Player player, ItemStack stack, ExplorersCompassItem explorersCompass, List<ResourceLocation> allowedStructureKeys) {
        super((Component)Component.m_237115_((String)"string.explorerscompass.selectStructure"));
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.explorersCompass = explorersCompass;
        this.allowedStructureKeys = new ArrayList<ResourceLocation>(allowedStructureKeys);
        this.structureKeysMatchingSearch = new ArrayList<ResourceLocation>(this.allowedStructureKeys);
        this.sortingCategory = new NameSorting();
    }

    public boolean m_6050_(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.m_6050_(scroll1, scroll2, scroll3);
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.setupWidgets();
    }

    public void m_86600_() {
        this.searchTextField.m_94120_();
        boolean bl = this.teleportButton.f_93623_ = this.explorersCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedStructureKeys.size() != ExplorersCompass.allowedStructureKeys.size()) {
            this.m_169411_((GuiEventListener)this.selectionList);
            this.allowedStructureKeys = new ArrayList<ResourceLocation>(ExplorersCompass.allowedStructureKeys);
            this.structureKeysMatchingSearch = new ArrayList<ResourceLocation>(this.allowedStructureKeys);
            this.selectionList = new StructureSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
            this.m_142416_((GuiEventListener)this.selectionList);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        ExplorersCompassScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)65, (int)15, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        boolean ret = super.m_7933_(par1, par2, par3);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        boolean ret = super.m_5534_(typedChar, keyCode);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void selectStructure(StructureSearchEntry entry) {
        boolean enable;
        this.searchButton.f_93623_ = enable = entry != null;
        this.searchGroupButton.f_93623_ = enable;
    }

    public void searchForStructure(ResourceLocation key) {
        ExplorersCompass.network.sendToServer((Object)new CompassSearchPacket(key, List.of(key), this.player.m_20183_()));
        this.f_96541_.m_91152_(null);
    }

    public void searchForGroup(ResourceLocation key) {
        ExplorersCompass.network.sendToServer((Object)new CompassSearchPacket(key, ExplorersCompass.typeKeysToStructureKeys.get((Object)key), this.player.m_20183_()));
        this.f_96541_.m_91152_(null);
    }

    public void teleport() {
        ExplorersCompass.network.sendToServer((Object)new TeleportPacket());
        this.f_96541_.m_91152_(null);
    }

    public void processSearchTerm() {
        this.structureKeysMatchingSearch = new ArrayList<ResourceLocation>();
        for (ResourceLocation key : this.allowedStructureKeys) {
            if (!StructureUtils.getPrettyStructureName(key).toLowerCase().contains(this.searchTextField.m_94155_().toLowerCase())) continue;
            this.structureKeysMatchingSearch.add(key);
        }
        this.selectionList.refreshList();
    }

    public List<ResourceLocation> sortStructures() {
        List<ResourceLocation> structures = this.structureKeysMatchingSearch;
        Collections.sort(structures, new NameSorting());
        Collections.sort(structures, this.sortingCategory);
        return structures;
    }

    private void setupWidgets() {
        this.m_169413_();
        this.searchButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 40, 110, 20, (Component)Component.m_237115_((String)"string.explorerscompass.search"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.m_93511_()).searchForStructure();
            }
        }));
        this.searchGroupButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 65, 110, 20, (Component)Component.m_237115_((String)"string.explorerscompass.searchForGroup"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.m_93511_()).searchForGroup();
            }
        }));
        this.sortByButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 90, 110, 20, (Component)Component.m_237115_((String)"string.explorerscompass.sortBy").m_7220_((Component)Component.m_237113_((String)(": " + this.sortingCategory.getLocalizedName()))), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.m_93666_((Component)Component.m_237115_((String)"string.explorerscompass.sortBy").m_7220_((Component)Component.m_237113_((String)(": " + this.sortingCategory.getLocalizedName()))));
            this.selectionList.refreshList();
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, this.f_96544_ - 30, 110, 20, (Component)Component.m_237115_((String)"gui.cancel"), onPress -> this.f_96541_.m_91152_(null)));
        this.teleportButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(this.f_96543_ - 120, 10, 110, 20, (Component)Component.m_237115_((String)"string.explorerscompass.teleport"), onPress -> this.teleport()));
        this.searchButton.f_93623_ = false;
        this.searchGroupButton.f_93623_ = false;
        this.teleportButton.f_93624_ = ExplorersCompass.canTeleport;
        this.searchTextField = new TransparentTextField(this.f_96547_, this.f_96543_ / 2 - 82, 10, 140, 20, (Component)Component.m_237115_((String)"string.explorerscompass.search"));
        this.m_142416_((GuiEventListener)this.searchTextField);
        if (this.selectionList == null) {
            this.selectionList = new StructureSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
        }
        this.m_142416_((GuiEventListener)this.selectionList);
    }
}

