/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.network;

import com.google.common.collect.Iterables;
import net.combatroll.CombatRoll;
import net.combatroll.api.event.Event;
import net.combatroll.api.event.ServerSideRollEvents;
import net.combatroll.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.combatroll.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.combatroll.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.combatroll.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.combatroll.network.Packets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ServerNetwork {
    private static FriendlyByteBuf configSerialized = PacketByteBufs.create();

    public static void initializeHandlers() {
        configSerialized = Packets.ConfigSync.write(CombatRoll.config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> sender.sendPacket(Packets.ConfigSync.ID, configSerialized));
        ServerPlayNetworking.registerGlobalReceiver(Packets.RollPublish.ID, (server, player, handler, buf, responseSender) -> {
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.m_129785_(), element -> element == player.f_19853_).orNull();
            if (world == null || world.f_46443_) {
                return;
            }
            Packets.RollPublish packet = Packets.RollPublish.read(buf);
            Vec3 velocity = packet.velocity();
            FriendlyByteBuf forwardBuffer = new Packets.RollAnimation(player.m_19879_(), packet.visuals(), packet.velocity()).write();
            PlayerLookup.tracking((Entity)player).forEach(serverPlayer -> {
                try {
                    if (serverPlayer.m_19879_() != player.m_19879_() && ServerPlayNetworking.canSend(serverPlayer, Packets.RollAnimation.ID)) {
                        ServerPlayNetworking.send(serverPlayer, Packets.RollAnimation.ID, forwardBuffer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            world.m_7654_().m_201446_(() -> {
                player.m_36399_(CombatRoll.config.exhaust_on_roll);
                Event.Proxy proxy = (Event.Proxy)ServerSideRollEvents.PLAYER_START_ROLLING;
                proxy.handlers.forEach(hander -> hander.onPlayerStartedRolling(player, velocity));
            });
        });
    }
}

