/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import java.util.Optional;
import net.combatroll.CombatRoll;
import net.combatroll.client.animation.AdjustmentModifier;
import net.combatroll.client.animation.AnimatablePlayer;
import net.combatroll.client.animation.AnimationRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerEntityMixin
extends Player
implements AnimatablePlayer {
    private final ModifierLayer base = new ModifierLayer(null, new AbstractModifier[0]);
    private final SpeedModifier speedModifier = new SpeedModifier();
    private Vec3 lastRollDirection;

    public AbstractClientPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile, @Nullable ProfilePublicKey publicKey) {
        super(world, pos, yaw, gameProfile, publicKey);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientLevel world, GameProfile profile, ProfilePublicKey publicKey, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        this.base.addModifier((AbstractModifier)this.createAdjustmentModifier(), 0);
        this.base.addModifier((AbstractModifier)this.speedModifier, 0);
        this.speedModifier.speed = 1.2f;
        stack.addAnimLayer(1000, (IAnimation)this.base);
    }

    @Override
    public void playRollAnimation(String animationName, Vec3 direction) {
        try {
            Player player = this;
            KeyframeAnimation animation = AnimationRegistry.animations.get(animationName);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.lastRollDirection = direction;
            int fadeIn = copy.beginTick;
            float length = copy.endTick;
            this.speedModifier.speed = length / (float)CombatRoll.config.roll_duration;
            this.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(copy.build(), 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AdjustmentModifier createAdjustmentModifier() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            switch (partName) {
                case "body": {
                    if (this.lastRollDirection != null) {
                        Vec3 absoluteOrientation = new Vec3(0.0, 0.0, 1.0).m_82524_((float)Math.toRadians(-1.0 * (double)player.f_20883_));
                        float angle = (float)this.angleWithSignBetween(absoluteOrientation, this.lastRollDirection, new Vec3(0.0, 1.0, 0.0));
                        rotationY = (float)Math.toRadians(angle);
                        break;
                    }
                    return Optional.empty();
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private double angleWithSignBetween(Vec3 a, Vec3 b, Vec3 planeNormal) {
        double cosineTheta = a.m_82526_(b) / (a.m_82553_() * b.m_82553_());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        Vec3 cross = a.m_82537_(b);
        if (Double.isNaN(angle *= Math.signum(cross.m_82526_(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }
}

