/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.forge;

import net.combatroll.CombatRoll;
import net.combatroll.api.Enchantments_CombatRoll;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.fabricmc.fabric.api.networking.v1.NetworkHandler;
import net.combatroll.utils.SoundHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="combatroll")
public class ForgeMod {
    public static DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"combatroll");

    public ForgeMod() {
        CombatRoll.init();
        NetworkHandler.registerMessages();
        this.registerSounds();
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CombatRoll.configureEnchantments();
    }

    @SubscribeEvent
    public void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ATTRIBUTES, helper -> {
            helper.register(EntityAttributes_CombatRoll.distanceId, (Object)EntityAttributes_CombatRoll.DISTANCE);
            helper.register(EntityAttributes_CombatRoll.rechargeId, (Object)EntityAttributes_CombatRoll.RECHARGE);
            helper.register(EntityAttributes_CombatRoll.countId, (Object)EntityAttributes_CombatRoll.COUNT);
        });
        event.register(ForgeRegistries.Keys.ENCHANTMENTS, helper -> {
            CombatRoll.configureEnchantments();
            helper.register(Enchantments_CombatRoll.distanceId, (Object)Enchantments_CombatRoll.DISTANCE);
            helper.register(Enchantments_CombatRoll.rechargeId, (Object)Enchantments_CombatRoll.RECHARGE);
            helper.register(Enchantments_CombatRoll.countId, (Object)Enchantments_CombatRoll.COUNT);
        });
    }

    private void registerSounds() {
        for (String soundKey : SoundHelper.soundKeys) {
            SOUNDS.register(soundKey, () -> new SoundEvent(new ResourceLocation("combatroll", soundKey)));
        }
    }
}

