/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.DamageType;
import net.mehvahdjukaar.dummmmmmy.common.DummyMobType;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.mehvahdjukaar.dummmmmmy.configs.CommonConfigs;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundDamageNumberMessage;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundSyncEquipMessage;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundUpdateAnimationMessage;
import net.mehvahdjukaar.dummmmmmy.network.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TargetDummyEntity
extends Mob {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(TargetDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float prevAnimationPosition = 0.0f;
    private float shakeAmount = 0.0f;
    private float prevShakeAmount = 0.0f;
    private int lastTickActuallyDamaged;
    private float totalDamageTakenInCombat;
    private boolean critical = false;
    private DummyMobType mobType = DummyMobType.UNDEFINED;
    private int damageNumberPos = 0;
    private final NonNullList<ItemStack> lastArmorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final Map<ServerPlayer, Integer> currentlyAttacking = new HashMap<ServerPlayer, Integer>();
    private DamageSource currentDamageSource = null;

    public TargetDummyEntity(EntityType<TargetDummyEntity> type, Level world) {
        super(type, world);
    }

    public TargetDummyEntity(Level world) {
        this(Dummmmmmy.TARGET_DUMMY.get(), world);
        this.f_21364_ = 0;
        Arrays.fill(this.f_21348_, 1.1f);
    }

    public float getShake(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevShakeAmount, (float)this.shakeAmount);
    }

    public float getAnimationPosition(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevAnimationPosition, (float)this.f_20925_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public Packet<?> m_5654_() {
        return PlatformHelper.getEntitySpawnPacket((Entity)this);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Type", this.mobType.ordinal());
        tag.m_128405_("NumberPos", this.damageNumberPos);
        tag.m_128379_("Sheared", this.isSheared());
        this.applyEquipmentModifiers();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.mobType = DummyMobType.values()[tag.m_128451_("Type")];
        this.damageNumberPos = tag.m_128451_("NumberPos");
        this.setSheared(tag.m_128471_("Sheared"));
    }

    public void m_5618_(float pOffset) {
        float r;
        this.f_19859_ = r = this.m_146908_();
        this.f_20884_ = this.f_20883_ = r;
    }

    public void m_5616_(float pRotation) {
        float r;
        this.f_19859_ = r = this.m_146908_();
        this.f_20886_ = this.f_20885_ = r;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        boolean inventoryChanged = false;
        if (!player.m_5833_() && player.m_150110_().f_35938_) {
            ItemStack itemstack = player.m_21120_(hand);
            EquipmentSlot equipmentSlot = TargetDummyEntity.m_147233_((ItemStack)itemstack);
            Item item = itemstack.m_41720_();
            if (item instanceof BannerItem || DummyMobType.get(itemstack) != DummyMobType.UNDEFINED || ForgeHelper.canEquipItem((LivingEntity)this, (ItemStack)itemstack, (EquipmentSlot)EquipmentSlot.HEAD)) {
                equipmentSlot = EquipmentSlot.HEAD;
            }
            if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                equipmentSlot = this.getClickedSlot(vec);
                if (this.m_21033_(equipmentSlot)) {
                    if (player.f_19853_.f_46443_) {
                        return InteractionResult.CONSUME;
                    }
                    this.unEquipArmor(player, equipmentSlot, hand);
                    inventoryChanged = true;
                }
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR) {
                if (player.f_19853_.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.equipArmor(player, equipmentSlot, itemstack, hand);
                inventoryChanged = true;
            } else if (item instanceof ShearsItem && !this.isSheared()) {
                this.f_19853_.m_6269_(player, (Entity)this, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player.f_19853_.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.setSheared(true);
                return InteractionResult.SUCCESS;
            }
            if (inventoryChanged) {
                this.setLastArmorItem(equipmentSlot, itemstack);
                if (!this.f_19853_.f_46443_) {
                    NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)this, (Message)new ClientBoundSyncEquipMessage(this.m_19879_(), equipmentSlot.m_20749_(), this.m_6844_(equipmentSlot)));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void unEquipArmor(Player player, EquipmentSlot slot, InteractionHand hand) {
        ItemStack itemstack = this.m_6844_(slot);
        ItemStack itemstack2 = itemstack.m_41777_();
        player.m_21008_(hand, itemstack2);
        this.m_8061_(slot, ItemStack.f_41583_);
        this.m_21204_().m_22161_(itemstack2.m_41638_(slot));
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = DummyMobType.UNDEFINED;
        }
    }

    private void equipArmor(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack currentItem = this.m_6844_(slot);
        ItemStack newItem = stack.m_41777_();
        newItem.m_41764_(1);
        player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)stack.m_41777_(), (Player)player, (ItemStack)currentItem, (boolean)player.m_7500_()));
        this.m_8061_(slot, newItem);
        this.m_21204_().m_22178_(newItem.m_41638_(slot));
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = DummyMobType.get(newItem);
        }
    }

    public boolean canScare() {
        return this.mobType == DummyMobType.SCARECROW;
    }

    public boolean canAttract() {
        return this.mobType == DummyMobType.DECOY;
    }

    private EquipmentSlot getClickedSlot(Vec3 vec3) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        double d0 = vec3.f_82480_;
        EquipmentSlot slot = EquipmentSlot.FEET;
        if (d0 >= 0.1 && d0 < 0.55 && this.m_21033_(slot)) {
            equipmentSlot = EquipmentSlot.FEET;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.m_21033_(EquipmentSlot.CHEST)) {
            equipmentSlot = EquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2000000000000002 && this.m_21033_(EquipmentSlot.LEGS)) {
            equipmentSlot = EquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            equipmentSlot = EquipmentSlot.HEAD;
        }
        return equipmentSlot;
    }

    private void setLastArmorItem(EquipmentSlot type, ItemStack stack) {
        this.lastArmorItems.set(type.m_20749_(), (Object)stack);
    }

    public void applyEquipmentModifiers() {
        if (!this.f_19853_.f_46443_) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = (ItemStack)this.lastArmorItems.get(equipmentSlot.m_20749_());
                ItemStack slot = this.m_6844_(equipmentSlot);
                if (ItemStack.m_41728_((ItemStack)slot, (ItemStack)itemstack)) continue;
                if (!slot.equals(itemstack)) {
                    ForgeHelper.onEquipmentChange((LivingEntity)this, (EquipmentSlot)equipmentSlot, (ItemStack)itemstack, (ItemStack)slot);
                }
                if (!itemstack.m_41619_()) {
                    this.m_21204_().m_22161_(itemstack.m_41638_(equipmentSlot));
                }
                if (slot.m_41619_()) continue;
                this.m_21204_().m_22178_(slot.m_41638_(equipmentSlot));
            }
        }
    }

    public void m_5907_() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armor = this.m_6844_(slot)).m_41619_()) continue;
            this.m_5552_(armor, 1.0f);
        }
    }

    public void dismantle(boolean drops) {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (drops) {
                this.m_5907_();
                this.m_20000_((ItemLike)Dummmmmmy.DUMMY_ITEM.get(), 1);
            }
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5592_(), this.m_5720_(), 1.0f, 1.0f);
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6074_() {
        this.dismantle(true);
    }

    @PlatformOnly(value={"forge"})
    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)Dummmmmmy.DUMMY_ITEM.get());
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19312_ || source == DamageSource.f_19310_;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source == DamageSource.f_19317_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        if (source.m_7640_() instanceof WitherBoss || source.m_7639_() instanceof WitherBoss) {
            this.dismantle(true);
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                this.currentlyAttacking.put(sp, CommonConfigs.MAX_COMBAT_INTERVAL.get());
            }
            if (player.m_6144_() && player.m_21205_().m_41619_()) {
                this.dismantle(!player.m_7500_());
                return false;
            }
        }
        this.currentDamageSource = source;
        boolean result = super.m_6469_(source, damage);
        this.currentDamageSource = null;
        this.f_20916_ = 0;
        return result;
    }

    public void m_21153_(float newHealth) {
        if (newHealth == this.m_21233_()) {
            super.m_21153_(newHealth);
        } else {
            float damage = this.m_21223_() - newHealth;
            if (damage > 0.0f) {
                if (this.lastTickActuallyDamaged != this.f_19797_) {
                    this.f_20925_ = 0.0f;
                }
                this.f_20925_ = Math.min(this.f_20925_ + damage, 60.0f);
                this.lastTickActuallyDamaged = this.f_19797_;
                if (!this.f_19853_.f_46443_) {
                    DamageSource actualSource = null;
                    if (PlatformHelper.getPlatform().isForge()) {
                        CombatEntry currentCombatEntry = this.m_21231_().m_146698_();
                        if (currentCombatEntry != null && currentCombatEntry.m_146684_() == this.f_19797_ && Mth.m_14033_((float)damage, (float)currentCombatEntry.m_19264_())) {
                            actualSource = currentCombatEntry.m_19263_();
                        }
                    } else {
                        actualSource = this.currentDamageSource;
                    }
                    if (this.currentDamageSource != null) {
                        this.showDamageDealt(damage, DamageType.get(actualSource, this.critical));
                    }
                    this.critical = false;
                }
            }
        }
    }

    private void showDamageDealt(float damage, DamageType type) {
        NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)this, (Message)new ClientBoundUpdateAnimationMessage(this.m_19879_(), this.f_20925_));
        for (ServerPlayer p : this.currentlyAttacking.keySet()) {
            NetworkHandler.CHANNEL.sendToClientPlayer(p, (Message)new ClientBoundDamageNumberMessage(this.m_19879_(), damage, type.ordinal()));
        }
        this.totalDamageTakenInCombat += damage;
    }

    public void m_8119_() {
        float trueDamage;
        if (this.lastTickActuallyDamaged + 1 == this.f_19797_ && !this.f_19853_.f_46443_ && (trueDamage = this.m_21233_() - this.m_21223_()) > 0.0f) {
            this.m_5634_(trueDamage);
            this.showDamageDealt(trueDamage, DamageType.TRUE);
        }
        BlockPos onPos = this.m_20097_();
        if (this.f_19853_.m_46467_() % 20L == 0L && !this.f_19853_.f_46443_ && this.f_19853_.m_46859_(onPos)) {
            this.dismantle(true);
            return;
        }
        this.m_20242_(true);
        BlockState onState = this.f_19853_.m_8055_(onPos);
        onState.m_60734_().m_141947_(this.f_19853_, onPos, onState, (Entity)this);
        this.m_6075_();
        this.f_19853_.m_46473_().m_6180_("travel");
        this.m_7023_(new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_));
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("push");
        this.m_6138_();
        this.f_19853_.m_46473_().m_7238_();
        if (this.f_19853_.f_46443_) {
            this.f_20916_ = 0;
            this.prevShakeAmount = this.shakeAmount;
            this.prevAnimationPosition = this.f_20925_;
            if (this.f_20925_ > 0.0f) {
                this.shakeAmount += 1.0f;
                this.f_20925_ -= 0.8f;
                if (this.f_20925_ <= 0.0f) {
                    this.shakeAmount = 0.0f;
                    this.f_20925_ = 0.0f;
                }
            }
        } else {
            CombatTracker tracker = this.m_21231_();
            if (tracker.m_146697_() && this.totalDamageTakenInCombat > 0.0f) {
                float combatDuration = tracker.m_19295_();
                CommonConfigs.DpsMode dpsMode = CommonConfigs.DYNAMIC_DPS.get();
                if (dpsMode != CommonConfigs.DpsMode.OFF && combatDuration > 0.0f) {
                    boolean dynamic = dpsMode == CommonConfigs.DpsMode.DYNAMIC;
                    float seconds = combatDuration / 20.0f + 1.0f;
                    float dps = this.totalDamageTakenInCombat / seconds;
                    ArrayList<ServerPlayer> outOfCombat = new ArrayList<ServerPlayer>();
                    for (Map.Entry<ServerPlayer, Integer> e : this.currentlyAttacking.entrySet()) {
                        boolean showMessage;
                        ServerPlayer p = e.getKey();
                        int timer = e.getValue() - 1;
                        this.currentlyAttacking.replace(p, timer);
                        boolean bl = showMessage = dynamic && this.lastTickActuallyDamaged + 1 == this.f_19797_;
                        if (timer <= 0) {
                            outOfCombat.add(p);
                            if (!dynamic) {
                                showMessage = true;
                            }
                        }
                        if (!showMessage || !(p.m_20270_((Entity)this) < 64.0f)) continue;
                        p.m_5661_((Component)Component.m_237110_((String)"message.dummmmmmy.dps", (Object[])new Object[]{this.m_5446_(), new DecimalFormat("#.##").format(dps)}), true);
                    }
                    outOfCombat.forEach(this.currentlyAttacking::remove);
                }
            } else {
                this.currentlyAttacking.clear();
                this.totalDamageTakenInCombat = 0.0f;
            }
        }
    }

    public void m_20256_(Vec3 motionIn) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_5834_() {
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11683_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    @NotNull
    public MobType m_6336_() {
        return this.mobType.getType();
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    public void updateClientDamage(float damage, int damageType) {
        if (ClientConfigs.DAMAGE_NUMBERS.get().booleanValue()) {
            this.f_19853_.m_7106_((ParticleOptions)Dummmmmmy.NUMBER_PARTICLE.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), (double)damage, (double)damageType, (double)this.damageNumberPos++);
        }
    }

    public void updateAnimation(float shake) {
        this.f_20925_ = shake;
    }

    public void moist() {
        this.critical = true;
    }
}

