/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class EntityUtils {
    public static void moveTowardsPosition(Entity entity, Vec3 targetPos, double speed) {
        Vec3 motion = targetPos.m_82546_(entity.m_20182_()).m_82541_().m_82490_(speed);
        entity.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    public static int getSlotWithItem(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getSlotsWithItem(Player player, Item item) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != item) continue;
            list.add(i);
            if (i != player.m_150109_().m_6643_()) continue;
            return list;
        }
        return list;
    }

    public static void addItem(Player player, ItemStack stack) {
        if (player.m_36356_(stack)) {
            return;
        }
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        ItemEntity drop = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
        drop.m_20334_((double)(MathUtils.randomFloat(random) * 0.15f), (double)(0.1f + random.m_188501_() * 0.2f), (double)(MathUtils.randomFloat(random) * 0.15f));
        drop.m_32010_(20);
        level.m_7967_((Entity)drop);
    }

    public static EntityHitResult rayTraceEntity(Entity shooter, Predicate<? super Entity> filter, double distance) {
        Level world = shooter.f_19853_;
        Vec3 startVec = shooter.m_20299_(1.0f);
        Vec3 endVec = shooter.m_20299_(1.0f).m_82549_(shooter.m_20252_(1.0f).m_82490_(distance));
        double d0 = distance * distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.m_6249_(shooter, shooter.m_20191_().m_82369_(shooter.m_20252_(1.0f).m_82490_(distance * distance)).m_82400_(1.0), filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_());
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (axisalignedbb.m_82390_(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.m_82557_(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == shooter.m_20201_() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    private static String getAttributeName(ItemStack stack, Attribute attribute) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + "_" + ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).m_135815_();
    }

    public static void applyAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || instance.m_22109_(modifier)) {
            return;
        }
        instance.m_22118_(modifier);
    }

    public static void removeAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(uuid, name, instance.m_22135_(), operation);
        if (!instance.m_22109_(modifier)) {
            return;
        }
        instance.m_22130_(modifier);
    }

    public static void resetAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        EntityUtils.removeAttribute(entity, stack, attribute, operation);
        EntityUtils.applyAttribute(entity, stack, attribute, value, operation);
    }

    public static ItemStack findEquippedCurio(Entity entity, Item item) {
        if (!(entity instanceof Player)) {
            return ItemStack.f_41583_;
        }
        Player player = (Player)entity;
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player);
        if (optional.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)((ImmutableTriple)optional.get()).getRight();
    }

    public static int getExperienceForLevel(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static int getTotalExperienceForLevel(int level) {
        int result = 0;
        for (int i = 0; i < level; ++i) {
            result += EntityUtils.getExperienceForLevel(i);
        }
        return result;
    }

    public static int getPlayerTotalExperience(Player player) {
        int result = player.f_36079_;
        for (int level = 0; level < player.f_36078_; ++level) {
            result += EntityUtils.getExperienceForLevel(level);
        }
        return result;
    }

    public static boolean isAlliedTo(@Nullable Entity source, @Nullable Entity target) {
        OwnableEntity ownable;
        return source == null || target == null || source.m_7307_(target) || target.m_7307_(source) || target.m_20148_().equals(source.m_20148_()) || target instanceof OwnableEntity && (ownable = (OwnableEntity)target).m_21805_() != null && ownable.m_21805_().equals(source.m_20148_());
    }

    public static boolean hurt(LivingEntity entity, DamageSource source, float amount) {
        LivingEntity sourceEntity;
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity && EntityUtils.isAlliedTo((Entity)(sourceEntity = (LivingEntity)entity2), (Entity)entity)) {
            return false;
        }
        return entity.m_6469_(source, amount);
    }

    public static List<ItemStack> getEquippedRelics(LivingEntity entity) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (!(entity instanceof Player)) {
            return items;
        }
        Player player = (Player)entity;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof IRelicItem)) continue;
            items.add(stack);
        }
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (!(stack.m_41720_() instanceof RelicItem)) continue;
                items.add(stack);
            }
        });
        return items;
    }
}

