/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.abilities;

import it.hurts.sskirillss.relics.client.hud.abilities.ActiveAbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SpellCastPacket {
    private final CastType type;
    private final CastStage stage;
    private final String ability;
    private final int slot;

    public SpellCastPacket(FriendlyByteBuf buf) {
        this.ability = buf.m_130277_();
        this.slot = buf.readInt();
        this.type = (CastType)buf.m_130066_(CastType.class);
        this.stage = (CastStage)buf.m_130066_(CastStage.class);
    }

    public SpellCastPacket(CastType type, CastStage stage, String ability, int slot) {
        this.ability = ability;
        this.slot = slot;
        this.type = type;
        this.stage = stage;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.ability);
        buf.writeInt(this.slot);
        buf.m_130068_((Enum)this.type);
        buf.m_130068_((Enum)this.stage);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot((Player)player, this.slot);
            Item patt1718$temp = stack.m_41720_();
            if (!(patt1718$temp instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)patt1718$temp;
            if (!ActiveAbilityUtils.getRelicActiveAbilities(stack).contains(this.ability) || !relic.canPlayerUseActiveAbility((Player)player, stack, this.ability)) {
                if (relic.isAbilityTicking(stack, this.ability)) {
                    relic.setAbilityTicking(stack, this.ability, false);
                    relic.castActiveAbility(stack, (Player)player, this.ability, this.type, CastStage.END);
                }
                return;
            }
            block0 : switch (this.type) {
                case CYCLICAL: 
                case TOGGLEABLE: {
                    switch (this.stage) {
                        case START: {
                            relic.setAbilityTicking(stack, this.ability, true);
                            break block0;
                        }
                        case END: {
                            relic.setAbilityTicking(stack, this.ability, false);
                        }
                    }
                }
            }
            relic.castActiveAbility(stack, (Player)player, this.ability, this.type, this.stage);
        });
        return true;
    }
}

