/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.feet.AmphibianBootItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketSyncEntityEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @ModifyArg(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setAirSupply(I)V", ordinal=0))
    private int relics$modifyAirConsumption(int decreasedAirSupply) {
        LivingEntity instance = (LivingEntity)this;
        if (AmphibianBootItem.canBreathe(instance)) {
            return instance.m_20146_();
        }
        return decreasedAirSupply;
    }

    @ModifyVariable(method={"travel"}, name={"f2"}, index=8, ordinal=0, at=@At(value="STORE"))
    protected float setBlockFriction(float original) {
        LivingEntity entity = (LivingEntity)this;
        LivingSlippingEvent event = new LivingSlippingEvent(entity, entity.f_19853_.m_8055_(entity.m_20099_()), original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getFriction();
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onAiStep(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)EffectRegistry.STUN.get())) {
            cir.setReturnValue((Object)true);
        }
        if (entity.m_21023_((MobEffect)EffectRegistry.PARALYSIS.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="TAIL")})
    protected void onEffectAdded(MobEffectInstance effect, Entity target, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.m_20193_();
        if (level.m_5776_()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        effect.m_19555_(tag);
        NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new PacketSyncEntityEffects(entity.m_19879_(), tag, PacketSyncEntityEffects.Action.ADD));
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="TAIL")})
    protected void onEffectRemoved(MobEffectInstance effect, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.m_20193_();
        if (level.m_5776_()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        effect.m_19555_(tag);
        NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new PacketSyncEntityEffects(entity.m_19879_(), tag, PacketSyncEntityEffects.Action.REMOVE));
    }

    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canBeSeenByAnyone(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)EffectRegistry.VANISHING.get())) {
            cir.setReturnValue((Object)false);
        }
    }
}

