/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class AmphibianBootItem
extends RelicItem
implements IRenderableCurio {
    private static final String TAG_SWIMMING_DURATION = "swimming_duration";
    private static final String TAG_SLIPPING_DURATION = "slipping_duration";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("swimming").stat(StatData.builder("speed").initialValue(0.005, 0.01).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value * 100.0 * 4.0, 1)).build()).stat(StatData.builder("duration").initialValue(15.0, 35.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value / 5.0, 1)).build()).build()).ability(AbilityData.builder("slipping").stat(StatData.builder("speed").initialValue(0.005, 0.01).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value * 100.0 * 4.0, 1)).build()).stat(StatData.builder("duration").initialValue(15.0, 25.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value / 5.0, 1)).build()).build()).ability(AbilityData.builder("gills").stat(StatData.builder("chance").initialValue(0.01, 0.1).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().background(Backgrounds.AQUATIC).build()).loot(LootData.builder().entry(LootCollections.AQUATIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int swimmingDuration = NBTUtils.getInt(stack, TAG_SWIMMING_DURATION, 0);
        if (player.m_6069_()) {
            if (player.f_19797_ % 20 == 0) {
                this.addExperience((Entity)player, stack, 1);
            }
            if ((double)swimmingDuration < this.getAbilityValue(stack, "swimming", "duration")) {
                NBTUtils.setInt(stack, TAG_SWIMMING_DURATION, swimmingDuration + 1);
            }
        } else if (swimmingDuration > 0) {
            NBTUtils.setInt(stack, TAG_SWIMMING_DURATION, --swimmingDuration);
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (swimmingDuration > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.SWIM_SPEED.get(), (float)((double)swimmingDuration * this.getAbilityValue(stack, "swimming", "speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        int slippingDuration = NBTUtils.getInt(stack, TAG_SLIPPING_DURATION, 0);
        if (player.m_20142_() && player.m_9236_().m_46758_(player.m_20183_()) && !player.m_6144_() && !player.m_20069_() && !player.m_20077_()) {
            if (player.f_19797_ % 20 == 0) {
                this.addExperience((Entity)player, stack, 1);
            }
            if ((double)slippingDuration < this.getAbilityValue(stack, "slipping", "duration") && player.f_19797_ % 4 == 0) {
                NBTUtils.setInt(stack, TAG_SLIPPING_DURATION, slippingDuration + 1);
            }
        } else if (slippingDuration > 0) {
            NBTUtils.setInt(stack, TAG_SLIPPING_DURATION, --slippingDuration);
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (slippingDuration > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, Attributes.f_22279_, (float)((double)slippingDuration * this.getAbilityValue(stack, "slipping", "speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.6f, AttributeModifier.Operation.ADDITION);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.m_41720_() == newStack.m_41720_()) {
            return;
        }
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute(slotContext.entity(), stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION);
    }

    public Rarity m_41460_(ItemStack pStack) {
        return Rarity.UNCOMMON;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.m_41720_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        sidedModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_85837_(0.0, 0.0, (double)-0.025f);
        sidedModel.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition rightLeg = mesh.m_171576_().m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        rightLeg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(1.5f, 6.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        rightLeg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.325f, 6.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftLeg = mesh.m_171576_().m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        leftLeg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(1.5f, 6.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        leftLeg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.325f, 6.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }

    public static boolean canBreathe(LivingEntity entity) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.AMPHIBIAN_BOOT.get());
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)item;
        return entity.m_217043_().m_188500_() <= relic.getAbilityValue(stack, "gills", "chance");
    }
}

