/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.leveling;

import com.mojang.datafixers.util.Function3;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class AbilityData {
    private final String id;
    private Function3<Player, ItemStack, String, String> icon;
    private Map<String, StatData> stats;
    private int maxLevel;
    private int requiredLevel;
    private int requiredPoints;
    private Pair<CastType, CastPredicate> castData;

    public static AbilityDataBuilder builder(String id) {
        AbilityDataBuilder builder = new AbilityDataBuilder();
        builder.id(id);
        return builder;
    }

    private static Function3<Player, ItemStack, String, String> $default$icon() {
        return (player, stack, ability) -> ability;
    }

    private static int $default$maxLevel() {
        return 10;
    }

    private static int $default$requiredLevel() {
        return 0;
    }

    private static int $default$requiredPoints() {
        return 1;
    }

    AbilityData(String id, Function3<Player, ItemStack, String, String> icon, Map<String, StatData> stats, int maxLevel, int requiredLevel, int requiredPoints, Pair<CastType, CastPredicate> castData) {
        this.id = id;
        this.icon = icon;
        this.stats = stats;
        this.maxLevel = maxLevel;
        this.requiredLevel = requiredLevel;
        this.requiredPoints = requiredPoints;
        this.castData = castData;
    }

    public String getId() {
        return this.id;
    }

    public Function3<Player, ItemStack, String, String> getIcon() {
        return this.icon;
    }

    public Map<String, StatData> getStats() {
        return this.stats;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public int getRequiredPoints() {
        return this.requiredPoints;
    }

    public Pair<CastType, CastPredicate> getCastData() {
        return this.castData;
    }

    public void setIcon(Function3<Player, ItemStack, String, String> icon) {
        this.icon = icon;
    }

    public void setStats(Map<String, StatData> stats) {
        this.stats = stats;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    public void setRequiredPoints(int requiredPoints) {
        this.requiredPoints = requiredPoints;
    }

    public void setCastData(Pair<CastType, CastPredicate> castData) {
        this.castData = castData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbilityData)) {
            return false;
        }
        AbilityData other = (AbilityData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        if (this.getRequiredPoints() != other.getRequiredPoints()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Function3<Player, ItemStack, String, String> this$icon = this.getIcon();
        Function3<Player, ItemStack, String, String> other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        Map<String, StatData> this$stats = this.getStats();
        Map<String, StatData> other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        Pair<CastType, CastPredicate> this$castData = this.getCastData();
        Pair<CastType, CastPredicate> other$castData = other.getCastData();
        return !(this$castData == null ? other$castData != null : !this$castData.equals(other$castData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbilityData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + this.getRequiredLevel();
        result = result * 59 + this.getRequiredPoints();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Function3<Player, ItemStack, String, String> $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        Map<String, StatData> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        Pair<CastType, CastPredicate> $castData = this.getCastData();
        result = result * 59 + ($castData == null ? 43 : $castData.hashCode());
        return result;
    }

    public String toString() {
        return "AbilityData(id=" + this.getId() + ", icon=" + this.getIcon() + ", stats=" + this.getStats() + ", maxLevel=" + this.getMaxLevel() + ", requiredLevel=" + this.getRequiredLevel() + ", requiredPoints=" + this.getRequiredPoints() + ", castData=" + this.getCastData() + ")";
    }

    public static class AbilityDataBuilder {
        private String id;
        private boolean icon$set;
        private Function3<Player, ItemStack, String, String> icon$value;
        private boolean maxLevel$set;
        private int maxLevel$value;
        private boolean requiredLevel$set;
        private int requiredLevel$value;
        private boolean requiredPoints$set;
        private int requiredPoints$value;
        private Map<String, StatData> stats = new HashMap<String, StatData>();
        private Pair<CastType, CastPredicate> castData = Pair.of((Object)((Object)CastType.NONE), (Object)CastPredicate.builder().build());

        public AbilityDataBuilder stat(StatData stat) {
            this.stats.put(stat.getId(), stat);
            return this;
        }

        private AbilityDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AbilityDataBuilder active(CastType type) {
            this.castData = Pair.of((Object)((Object)type), (Object)CastPredicate.builder().build());
            return this;
        }

        public AbilityDataBuilder active(CastType type, CastPredicate predicates) {
            this.castData = Pair.of((Object)((Object)type), (Object)predicates);
            return this;
        }

        AbilityDataBuilder() {
        }

        public AbilityDataBuilder icon(Function3<Player, ItemStack, String, String> icon) {
            this.icon$value = icon;
            this.icon$set = true;
            return this;
        }

        public AbilityDataBuilder stats(Map<String, StatData> stats) {
            this.stats = stats;
            return this;
        }

        public AbilityDataBuilder maxLevel(int maxLevel) {
            this.maxLevel$value = maxLevel;
            this.maxLevel$set = true;
            return this;
        }

        public AbilityDataBuilder requiredLevel(int requiredLevel) {
            this.requiredLevel$value = requiredLevel;
            this.requiredLevel$set = true;
            return this;
        }

        public AbilityDataBuilder requiredPoints(int requiredPoints) {
            this.requiredPoints$value = requiredPoints;
            this.requiredPoints$set = true;
            return this;
        }

        public AbilityDataBuilder castData(Pair<CastType, CastPredicate> castData) {
            this.castData = castData;
            return this;
        }

        public AbilityData build() {
            Function3<Player, ItemStack, String, String> icon$value = this.icon$value;
            if (!this.icon$set) {
                icon$value = AbilityData.$default$icon();
            }
            int maxLevel$value = this.maxLevel$value;
            if (!this.maxLevel$set) {
                maxLevel$value = AbilityData.$default$maxLevel();
            }
            int requiredLevel$value = this.requiredLevel$value;
            if (!this.requiredLevel$set) {
                requiredLevel$value = AbilityData.$default$requiredLevel();
            }
            int requiredPoints$value = this.requiredPoints$value;
            if (!this.requiredPoints$set) {
                requiredPoints$value = AbilityData.$default$requiredPoints();
            }
            return new AbilityData(this.id, icon$value, this.stats, maxLevel$value, requiredLevel$value, requiredPoints$value, this.castData);
        }

        public String toString() {
            return "AbilityData.AbilityDataBuilder(id=" + this.id + ", icon$value=" + this.icon$value + ", stats=" + this.stats + ", maxLevel$value=" + this.maxLevel$value + ", requiredLevel$value=" + this.requiredLevel$value + ", requiredPoints$value=" + this.requiredPoints$value + ", castData=" + this.castData + ")";
        }
    }
}

