/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import it.hurts.sskirillss.octolib.config.data.ConfigContext;
import it.hurts.sskirillss.octolib.config.data.OctoConfig;
import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.hurts.sskirillss.relics.capability.utils.CapabilityUtils;
import it.hurts.sskirillss.relics.config.ConfigHelper;
import it.hurts.sskirillss.relics.entities.RelicExperienceOrbEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.predicate.PredicateEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.predicate.misc.PredicateData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.capability.CapabilitySyncPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public interface IRelicItem {
    @Nullable
    default public Item getItem() {
        Item item;
        IRelicItem iRelicItem = this;
        return iRelicItem instanceof Item ? (item = (Item)iRelicItem) : null;
    }

    public RelicData constructDefaultRelicData();

    @Nullable
    default public OctoConfig getConfig() {
        return ConfigHelper.getRelicConfig(this);
    }

    default public void appendConfig(ConfigContext context) {
    }

    default public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
    }

    default public void tickActiveAbilitySelection(ItemStack stack, Player player, String ability) {
    }

    @Nullable
    default public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().build();
    }

    @Nullable
    default public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().build();
    }

    default public RelicData getRelicData() {
        if (!RelicStorage.RELICS.containsKey(this)) {
            RelicStorage.RELICS.put(this, this.constructDefaultRelicData());
        }
        return RelicStorage.RELICS.get(this);
    }

    default public void setRelicData(RelicData data) {
        RelicStorage.RELICS.put(this, data);
    }

    default public AbilityData getAbilityData(String ability) {
        return this.getRelicData().getAbilities().getAbilities().get(ability);
    }

    default public StatData getStatData(String ability, String stat) {
        return this.getRelicData().getAbilities().getAbilities().get(ability).getStats().get(stat);
    }

    default public LevelingData getLevelingData() {
        return this.getRelicData().getLeveling();
    }

    default public LootData getLootData() {
        return this.getRelicData().getLoot();
    }

    default public StyleData getStyleData() {
        return this.getRelicData().getStyle();
    }

    default public boolean isItemResearched(Player player) {
        Item item = this.getItem();
        return item != null && CapabilityUtils.getRelicsCapability(player).getResearchData().m_128471_(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_() + "_researched");
    }

    default public void setItemResearched(Player player, boolean researched) {
        Item item = this.getItem();
        if (item == null) {
            return;
        }
        CapabilityUtils.getRelicsCapability(player).getResearchData().m_128379_(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_() + "_researched", researched);
        if (!player.m_9236_().m_5776_()) {
            NetworkHandler.sendToClient(new CapabilitySyncPacket((CompoundTag)CapabilityUtils.getRelicsCapability(player).serializeNBT()), (ServerPlayer)player);
        }
    }

    default public int getMaxQuality() {
        return 10;
    }

    default public int getStatQuality(ItemStack stack, String ability, String stat) {
        double max;
        StatData statData = this.getStatData(ability, stat);
        if (statData == null) {
            return 0;
        }
        Function<Double, ? extends Number> format = statData.getFormatValue();
        double initial = format.apply(this.getAbilityInitialValue(stack, ability, stat)).doubleValue();
        double min = format.apply((Double)statData.getInitialValue().getKey()).doubleValue();
        if (min == (max = format.apply((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return this.getMaxQuality();
        }
        return Mth.m_14045_((int)((int)Math.round((initial - min) / ((max - min) / (double)this.getMaxQuality()))), (int)0, (int)this.getMaxQuality());
    }

    default public double getStatByQuality(String ability, String stat, int quality) {
        double max;
        StatData statData = this.getStatData(ability, stat);
        if (statData == null) {
            return 0.0;
        }
        double min = (Double)statData.getInitialValue().getKey();
        if (min == (max = ((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return this.getMaxQuality();
        }
        return MathUtils.round(min + (max - min) / (double)this.getMaxQuality() * (double)quality, 5);
    }

    default public int getAbilityQuality(ItemStack stack, String ability) {
        Map<String, StatData> stats = this.getAbilityData(ability).getStats();
        if (stats.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (String stat : stats.keySet()) {
            sum += this.getStatQuality(stack, ability, stat);
        }
        return Mth.m_14045_((int)(sum / stats.size()), (int)0, (int)this.getMaxQuality());
    }

    default public int getRelicQuality(ItemStack stack) {
        Map<String, AbilityData> abilities = this.getRelicData().getAbilities().getAbilities();
        if (abilities.isEmpty()) {
            return 0;
        }
        int size = abilities.size();
        int sum = 0;
        for (Map.Entry<String, AbilityData> entry : abilities.entrySet()) {
            if (entry.getValue().getMaxLevel() == 0) {
                --size;
                continue;
            }
            sum += this.getAbilityQuality(stack, entry.getKey());
        }
        return Mth.m_14045_((int)(sum / size), (int)0, (int)this.getMaxQuality());
    }

    default public CompoundTag getLevelingTag(ItemStack stack) {
        return NBTUtils.getCompound(stack, "leveling", new CompoundTag());
    }

    default public void setLevelingTag(ItemStack stack, CompoundTag data) {
        NBTUtils.setCompound(stack, "leveling", data);
    }

    default public int getPoints(ItemStack stack) {
        return this.getLevelingTag(stack).m_128451_("points");
    }

    default public void setPoints(ItemStack stack, int amount) {
        CompoundTag tag = this.getLevelingTag(stack);
        tag.m_128405_("points", Math.max(0, amount));
        this.setLevelingTag(stack, tag);
    }

    default public void addPoints(ItemStack stack, int amount) {
        this.setPoints(stack, this.getPoints(stack) + amount);
    }

    default public int getLevel(ItemStack stack) {
        return this.getLevelingTag(stack).m_128451_("level");
    }

    default public void setLevel(ItemStack stack, int level) {
        CompoundTag tag = this.getLevelingTag(stack);
        tag.m_128405_("level", Mth.m_14045_((int)level, (int)0, (int)this.getLevelingData().getMaxLevel()));
        this.setLevelingTag(stack, tag);
    }

    default public void addLevel(ItemStack stack, int amount) {
        if (amount > 0) {
            this.addPoints(stack, Mth.m_14045_((int)amount, (int)0, (int)(this.getLevelingData().getMaxLevel() - this.getLevel(stack))));
        }
        this.setLevel(stack, this.getLevel(stack) + amount);
    }

    default public int getExperience(ItemStack stack) {
        return this.getLevelingTag(stack).m_128451_("experience");
    }

    default public void setExperience(ItemStack stack, int experience) {
        int level = this.getLevel(stack);
        if (level >= this.getLevelingData().getMaxLevel()) {
            return;
        }
        int requiredExp = this.getExperienceBetweenLevels(stack, level, level + 1);
        CompoundTag data = this.getLevelingTag(stack);
        if (experience >= requiredExp) {
            int sumExp = this.getTotalExperienceForLevel(stack, level) + experience;
            int resultLevel = this.getLevelFromExperience(stack, sumExp);
            data.m_128405_("experience", Math.max(0, sumExp - this.getTotalExperienceForLevel(stack, resultLevel)));
            this.setLevelingTag(stack, data);
            this.addPoints(stack, resultLevel - level);
            this.setLevel(stack, resultLevel);
        } else {
            data.m_128405_("experience", Mth.m_14045_((int)experience, (int)0, (int)requiredExp));
            this.setLevelingTag(stack, data);
        }
    }

    default public boolean addExperience(ItemStack stack, int amount) {
        return this.addExperience(null, stack, amount);
    }

    default public boolean addExperience(Entity entity, ItemStack stack, int amount) {
        ExperienceAddEvent event = new ExperienceAddEvent(entity instanceof Player ? (Player)entity : null, stack, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.setExperience(stack, this.getExperience(stack) + event.getAmount());
            return true;
        }
        return false;
    }

    default public void dropAllocableExperience(Level level, Vec3 pos, ItemStack stack, int amount) {
        this.dropAllocableExperience(level, pos, stack, amount, 0.75f);
    }

    default public void dropAllocableExperience(Level level, Vec3 pos, ItemStack stack, int amount, float priority) {
        this.dropExperience(level, pos, level.m_213780_().m_188501_() <= priority ? stack : ItemStack.f_41583_, amount);
    }

    default public void dropExperience(Level level, Vec3 pos, int amount) {
        this.dropExperience(level, pos, ItemStack.f_41583_, amount);
    }

    default public void dropExperience(Level level, Vec3 pos, ItemStack stack, int amount) {
        if (amount <= 0) {
            return;
        }
        RandomSource random = level.m_213780_();
        int orbs = Math.max(amount / RelicExperienceOrbEntity.getMaxExperience(), random.m_188503_(amount) + 1);
        for (int i = 0; i < orbs; ++i) {
            RelicExperienceOrbEntity orb = new RelicExperienceOrbEntity((EntityType<? extends RelicExperienceOrbEntity>)((EntityType)EntityRegistry.RELIC_EXPERIENCE_ORB.get()), level);
            orb.m_146884_(pos);
            orb.setExperience(amount / orbs);
            if (stack != null && !stack.m_41619_()) {
                orb.setStack(stack);
            }
            orb.m_20334_((-1.0f + 2.0f * random.m_188501_()) * 0.15f, 0.1f + random.m_188501_() * 0.2f, (-1.0f + 2.0f * random.m_188501_()) * 0.15f);
            level.m_7967_((Entity)orb);
        }
    }

    default public int getExperienceLeftForLevel(ItemStack stack, int level) {
        int currentLevel = this.getLevel(stack);
        return this.getExperienceBetweenLevels(stack, currentLevel, level) - this.getExperience(stack);
    }

    default public int getExperienceBetweenLevels(ItemStack stack, int from, int to) {
        return this.getTotalExperienceForLevel(stack, to) - this.getTotalExperienceForLevel(stack, from);
    }

    default public int getTotalExperienceForLevel(ItemStack stack, int level) {
        if (level <= 0) {
            return 0;
        }
        LevelingData levelingData = this.getLevelingData();
        if (levelingData == null) {
            return 0;
        }
        int result = levelingData.getInitialCost();
        for (int i = 1; i < level; ++i) {
            result += levelingData.getInitialCost() + levelingData.getStep() * i;
        }
        return result;
    }

    default public int getLevelFromExperience(ItemStack stack, int experience) {
        int amount;
        int result = 0;
        while ((amount = this.getTotalExperienceForLevel(stack, ++result)) <= experience) {
        }
        return result - 1;
    }

    default public boolean isMaxLevel(ItemStack stack) {
        return this.getLevel(stack) >= this.getLevelingData().getMaxLevel();
    }

    default public int getExchanges(ItemStack stack) {
        return NBTUtils.getInt(stack, "exchanges", 0);
    }

    default public void setExchanges(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, "exchanges", Math.max(0, amount));
    }

    default public void addExchanges(ItemStack stack, int amount) {
        this.setExchanges(stack, this.getExchanges(stack) + amount);
    }

    default public int getExchangeCost(ItemStack stack) {
        return (int)(5.0f + 5.0f * ((float)this.getExchanges(stack) * 0.01f));
    }

    default public boolean isExchangeAvailable(Player player, ItemStack stack) {
        return this.getExchangeCost(stack) <= EntityUtils.getPlayerTotalExperience(player);
    }

    default public CastPredicate getAbilityCastPredicates(String ability) {
        return (CastPredicate)this.getAbilityData(ability).getCastData().getValue();
    }

    default public PredicateEntry getAbilityCastPredicate(String ability, String predicate) {
        return this.getAbilityCastPredicates(ability).getPredicates().get(predicate);
    }

    default public boolean testAbilityCastPredicate(Player player, ItemStack stack, String ability, String predicate) {
        return this.getAbilityCastPredicate(ability, predicate).getPredicate().apply(new PredicateData(player, stack));
    }

    default public boolean testAbilityCastPredicates(Player player, ItemStack stack, String ability) {
        CastPredicate predicates = this.getAbilityCastPredicates(ability);
        for (Map.Entry<String, PredicateEntry> entry : predicates.getPredicates().entrySet()) {
            if (entry.getValue().getPredicate().apply(new PredicateData(player, stack)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    default public CompoundTag getAbilitiesTag(ItemStack stack) {
        return stack.m_41784_().m_128469_("abilities");
    }

    default public void setAbilitiesTag(ItemStack stack, CompoundTag nbt) {
        stack.m_41784_().m_128365_("abilities", (Tag)nbt);
    }

    default public CompoundTag getAbilityTag(ItemStack stack, String ability) {
        CompoundTag data = this.getAbilitiesTag(stack);
        if (data.m_128456_()) {
            return new CompoundTag();
        }
        return data.m_128469_(ability);
    }

    default public void setAbilityTag(ItemStack stack, String ability, CompoundTag nbt) {
        CompoundTag data = this.getAbilitiesTag(stack);
        data.m_128365_(ability, (Tag)nbt);
        this.setAbilitiesTag(stack, data);
    }

    default public CompoundTag getAbilityTempTag(ItemStack stack, String ability) {
        CompoundTag data = this.getAbilityTag(stack, ability);
        if (data.m_128456_()) {
            return new CompoundTag();
        }
        return data.m_128469_("temp");
    }

    default public void setAbilityTempTag(ItemStack stack, String ability, CompoundTag nbt) {
        CompoundTag data = this.getAbilityTag(stack, ability);
        data.m_128365_("temp", (Tag)nbt);
        this.setAbilityTag(stack, ability, data);
    }

    default public Map<String, Double> getAbilityInitialValues(ItemStack stack, String ability) {
        CompoundTag abilityTag = this.getAbilityTag(stack, ability);
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (abilityTag.m_128456_()) {
            return result;
        }
        CompoundTag statTag = abilityTag.m_128469_("stats");
        if (statTag.m_128456_()) {
            return result;
        }
        statTag.m_128431_().forEach(entry -> result.put((String)entry, statTag.m_128459_(entry)));
        return result;
    }

    default public double getAbilityInitialValue(ItemStack stack, String ability, String stat) {
        double result;
        try {
            result = this.getAbilityInitialValues(stack, ability).get(stat);
        }
        catch (NullPointerException exception) {
            if (this.getStatData(ability, stat) != null) {
                this.randomizeStats(stack, ability);
                result = this.getAbilityInitialValues(stack, ability).get(stat);
            }
            result = 0.0;
        }
        return result;
    }

    default public double getAbilityValue(ItemStack stack, String ability, String stat, int points) {
        StatData data = this.getStatData(ability, stat);
        double result = 0.0;
        if (data == null) {
            return result;
        }
        double current = this.getAbilityInitialValue(stack, ability, stat);
        double step = (Double)data.getUpgradeModifier().getValue();
        switch ((UpgradeOperation)((Object)data.getUpgradeModifier().getKey())) {
            case ADD: {
                result = current + (double)points * step;
                break;
            }
            case MULTIPLY_BASE: {
                result = current + current * step * (double)points;
                break;
            }
            case MULTIPLY_TOTAL: {
                result = current * Math.pow(step + 1.0, points);
            }
        }
        Pair<Double, Double> threshold = data.getThresholdValue();
        return MathUtils.round(Mth.m_14008_((double)result, (double)((Double)threshold.getKey()), (double)((Double)threshold.getValue())), 5);
    }

    default public double getAbilityValue(ItemStack stack, String ability, String stat) {
        return this.getAbilityValue(stack, ability, stat, this.getAbilityPoints(stack, ability));
    }

    default public void setAbilityValue(ItemStack stack, String ability, String stat, double value) {
        CompoundTag data = this.getAbilitiesTag(stack);
        CompoundTag abilityTag = this.getAbilityTag(stack, ability);
        CompoundTag statTag = abilityTag.m_128469_("stats");
        statTag.m_128347_(stat, value);
        abilityTag.m_128365_("stats", (Tag)statTag);
        data.m_128365_(ability, (Tag)abilityTag);
        this.setAbilitiesTag(stack, data);
    }

    default public void addAbilityValue(ItemStack stack, String ability, String stat, double value) {
        this.setAbilityValue(stack, ability, stat, this.getAbilityValue(stack, ability, stat) + value);
    }

    default public int getAbilityPoints(ItemStack stack, String ability) {
        return this.getAbilityTag(stack, ability).m_128451_("points");
    }

    default public void setAbilityPoints(ItemStack stack, String ability, int amount) {
        this.getAbilityTag(stack, ability).m_128405_("points", Math.max(0, amount));
    }

    default public void addAbilityPoints(ItemStack stack, String ability, int amount) {
        this.getAbilityTag(stack, ability).m_128405_("points", Math.max(0, this.getAbilityPoints(stack, ability) + amount));
    }

    default public boolean canUseAbility(ItemStack stack, String ability) {
        return this.getLevel(stack) >= this.getAbilityData(ability).getRequiredLevel();
    }

    default public void randomizeStat(ItemStack stack, String ability, String stat) {
        StatData entry = this.getStatData(ability, stat);
        double result = MathUtils.round(MathUtils.randomBetween(new Random(), (Double)entry.getInitialValue().getKey(), (Double)entry.getInitialValue().getValue()), 5);
        this.setAbilityValue(stack, ability, stat, result);
    }

    default public void randomizeStats(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        for (String stat : entry.getStats().keySet()) {
            this.randomizeStat(stack, ability, stat);
        }
    }

    default public int getUpgradeRequiredExperience(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return (this.getAbilityPoints(stack, ability) + 1) * entry.getRequiredPoints() * count * 15;
    }

    default public boolean isAbilityMaxLevel(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        return entry.getStats().isEmpty() || this.getAbilityPoints(stack, ability) >= (entry.getMaxLevel() == -1 ? this.getLevelingData().getMaxLevel() / entry.getRequiredPoints() : entry.getMaxLevel());
    }

    default public boolean mayUpgrade(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        return !entry.getStats().isEmpty() && !this.isAbilityMaxLevel(stack, ability) && this.getPoints(stack) >= entry.getRequiredPoints() && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerUpgrade(Player player, ItemStack stack, String ability) {
        return this.mayUpgrade(stack, ability) && player.f_36079_ >= this.getUpgradeRequiredExperience(stack, ability);
    }

    default public int getRerollRequiredExperience(String ability) {
        AbilityData entry = this.getAbilityData(ability);
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return 100 / count;
    }

    default public boolean mayReroll(ItemStack stack, String ability) {
        return !this.getAbilityData(ability).getStats().isEmpty() && this.getRerollRequiredExperience(ability) > 0 && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerReroll(Player player, ItemStack stack, String ability) {
        return this.mayReroll(stack, ability) && player.f_36079_ >= this.getRerollRequiredExperience(ability);
    }

    default public int getResetRequiredExperience(ItemStack stack, String ability) {
        return this.getAbilityPoints(stack, ability) * 50;
    }

    default public boolean mayReset(ItemStack stack, String ability) {
        return this.getResetRequiredExperience(stack, ability) > 0 && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerReset(Player player, ItemStack stack, String ability) {
        return !this.getAbilityData(ability).getStats().isEmpty() && this.mayReset(stack, ability) && player.f_36079_ >= this.getResetRequiredExperience(stack, ability);
    }

    default public int getAbilityCooldownCap(ItemStack stack, String ability) {
        return this.getAbilityTempTag(stack, ability).m_128451_("cooldown_cap");
    }

    default public void setAbilityCooldownCap(ItemStack stack, String ability, int amount) {
        CompoundTag data = this.getAbilityTempTag(stack, ability);
        data.m_128405_("cooldown_cap", amount);
        this.setAbilityTempTag(stack, ability, data);
    }

    default public int getAbilityCooldown(ItemStack stack, String ability) {
        return this.getAbilityTempTag(stack, ability).m_128451_("cooldown");
    }

    default public void setAbilityCooldown(ItemStack stack, String ability, int amount) {
        CompoundTag data = this.getAbilityTempTag(stack, ability);
        data.m_128405_("cooldown", amount);
        data.m_128405_("cooldown_cap", amount);
        this.setAbilityTempTag(stack, ability, data);
    }

    default public void addAbilityCooldown(ItemStack stack, String ability, int amount) {
        CompoundTag data = this.getAbilityTempTag(stack, ability);
        data.m_128405_("cooldown", this.getAbilityCooldown(stack, ability) + amount);
        this.setAbilityTempTag(stack, ability, data);
    }

    default public void setAbilityTicking(ItemStack stack, String ability, boolean ticking) {
        CompoundTag data = this.getAbilityTempTag(stack, ability);
        data.m_128379_("ticking", ticking);
        this.setAbilityTempTag(stack, ability, data);
    }

    default public boolean isAbilityTicking(ItemStack stack, String ability) {
        return this.getAbilityTempTag(stack, ability).m_128471_("ticking");
    }

    default public boolean isAbilityOnCooldown(ItemStack stack, String ability) {
        return this.getAbilityCooldown(stack, ability) > 0;
    }

    default public boolean canPlayerUseActiveAbility(Player player, ItemStack stack, String ability) {
        return this.canUseAbility(stack, ability) && !this.isAbilityOnCooldown(stack, ability) && this.testAbilityCastPredicates(player, stack, ability);
    }
}

