/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class MidnightRobeItem
extends RelicItem
implements IRenderableCurio {
    private static final String TAG_TARGET = "target";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("vanish").active(CastType.TOGGLEABLE).requiredPoints(2).stat(StatData.builder("light").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("speed").initialValue(0.1, 0.35).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).build()).ability(AbilityData.builder("backstab").stat(StatData.builder("damage").initialValue(1.25, 1.75).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(100.0 * MathUtils.round(value - 1.0, 1))).build()).stat(StatData.builder("distance").initialValue(15.0, 20.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        Level level = entity.m_20193_();
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity target = MidnightRobeItem.getTarget((Level)serverLevel, stack);
        if (target != null) {
            double radius = this.getAbilityValue(stack, "backstab", "distance");
            double step = 0.15;
            int offset = 16;
            double len = (float)(Math.PI * 2 * radius);
            int num = (int)(len / step);
            for (int i = 0; i < num; ++i) {
                int tries;
                double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / step - (double)num) / (double)num / len));
                double extraX = radius * Math.sin(angle) + target.m_20185_();
                double extraZ = radius * Math.cos(angle) + target.m_20189_();
                double extraY = target.m_20186_() + (double)(target.m_20206_() * 0.5f);
                boolean foundPos = false;
                for (tries = 0; tries < offset * 2; ++tries) {
                    Vec3 vec = new Vec3(extraX, extraY, extraZ);
                    BlockPos pos = new BlockPos(vec);
                    BlockState state = serverLevel.m_8055_(pos);
                    VoxelShape shape = state.m_60812_((BlockGetter)serverLevel, pos);
                    if (shape.m_83281_()) {
                        if (!foundPos) {
                            extraY -= 1.0;
                            continue;
                        }
                    } else {
                        foundPos = true;
                    }
                    if (shape.m_83281_()) break;
                    AABB aabb = shape.m_83215_();
                    if (!aabb.m_82338_(pos).m_82390_(vec)) {
                        if (!(aabb.f_82292_ >= 1.0)) break;
                        extraY += 1.0;
                        continue;
                    }
                    extraY += step;
                }
                if (tries >= offset * 2) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(50 + serverLevel.m_213780_().m_188503_(50), 0, 255), 0.25f, 3, 0.75f), extraX, extraY + (double)0.2f, extraZ, 1, 0.05, 0.05, 0.05, 0.025);
            }
        }
        if (!MidnightRobeItem.canHide(entity)) {
            EntityUtils.removeAttribute(entity, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (target != null && (target.m_21224_() || target.m_20182_().m_82554_(entity.m_20182_()) >= this.getAbilityValue(stack, "backstab", "distance"))) {
                NBTUtils.clearTag(stack, TAG_TARGET);
            }
        } else {
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
            EntityUtils.applyAttribute(entity, stack, Attributes.f_22279_, (float)this.getAbilityValue(stack, "vanish", "speed"), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    @Nullable
    private static LivingEntity getTarget(Level level, ItemStack stack) {
        LivingEntity target;
        if (level.m_5776_()) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String string = NBTUtils.getString(stack, TAG_TARGET, "");
        if (string.isEmpty()) {
            return null;
        }
        Entity entity = serverLevel.m_8791_(UUID.fromString(string));
        if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).m_21224_()) {
            NBTUtils.clearTag(stack, TAG_TARGET);
            return null;
        }
        return target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canHide(LivingEntity entity) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.MIDNIGHT_ROBE.get());
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) return false;
        IRelicItem relic = (IRelicItem)item;
        Level world = entity.m_20193_();
        BlockPos position = entity.m_20183_().m_7494_();
        double light = relic.getAbilityValue(stack, "vanish", "light");
        if (!relic.isAbilityTicking(stack, "vanish")) return false;
        if (!NBTUtils.getString(stack, TAG_TARGET, "").isEmpty()) return false;
        double d = (double)world.m_45517_(LightLayer.BLOCK, position) + (double)world.m_45517_(LightLayer.SKY, position) / 2.0;
        double d2 = world.m_46462_() ? light * 1.5 : light;
        if (!(d <= d2)) return false;
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-5.0f, -1.275f, -1.75f, 10.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -0.5f, -3.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(32, 8).m_171488_(-5.0f, -6.6f, -1.6f, 10.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-5.0f, -6.6f, 4.4f, 10.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171480_().m_171488_(-4.99f, -6.6f, -1.6f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 28).m_171488_(4.99f, -6.6f, -1.6f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)17.9046f, (float)1.5671f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-5.0f, -4.65f, -3.9f, 10.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.5f, (float)1.5f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-1.0f, -2.25f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171480_().m_171488_(-3.0f, -2.25f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"head"});
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm", "body"});
    }

    @Mod.EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            IRelicItem relic;
            ItemStack stack;
            Player player;
            LivingEntity target;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            target = event.getEntity();
                            Level level = target.m_20193_();
                            Entity entity = event.getSource().m_7639_();
                            if (!(entity instanceof Player)) break block4;
                            player = (Player)entity;
                            if (!level.m_5776_() && !target.m_20149_().equals(player.m_20149_())) break block5;
                        }
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.MIDNIGHT_ROBE.get());
                    Item item = stack.m_41720_();
                    if (!(item instanceof IRelicItem)) break block6;
                    relic = (IRelicItem)item;
                    if (!MidnightRobeItem.canHide((LivingEntity)player)) break block6;
                    Vec3 vec3 = new Vec3(target.m_20185_(), player.m_20186_(), target.m_20189_());
                    if (!(player.m_20182_().m_82554_(vec3) > relic.getAbilityValue(stack, "backstab", "distance"))) break block7;
                }
                return;
            }
            relic.addExperience((Entity)player, stack, Math.round(event.getAmount() * 0.5f));
            event.setAmount((float)((double)event.getAmount() * relic.getAbilityValue(stack, "backstab", "damage")));
            NBTUtils.setString(stack, MidnightRobeItem.TAG_TARGET, target.m_20149_());
        }
    }
}

