/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@Mod.EventBusSubscriber
public class ElytraBoosterItem
extends RelicItem
implements IRenderableCurio {
    public static final String TAG_FUEL = "fuel";
    public static final String TAG_SPEED = "speed";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("boost").maxLevel(10).active(CastType.CYCLICAL, CastPredicate.builder().predicate(TAG_FUEL, data -> NBTUtils.getInt(data.getStack(), TAG_FUEL, 0) > 0).predicate("elytra", data -> data.getPlayer().m_21255_()).build()).stat(StatData.builder("capacity").initialValue(50.0, 100.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder(TAG_SPEED).initialValue(1.1, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value * 16.0, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.END).build()).build();
    }

    public int getBreathCapacity(ItemStack stack) {
        return (int)Math.round(this.getAbilityValue(stack, "boost", "capacity"));
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("boost") && stage == CastStage.TICK) {
            int fuel = NBTUtils.getInt(stack, TAG_FUEL, 0);
            if (fuel > 0 && player.f_19797_ % 20 == 0) {
                NBTUtils.setInt(stack, TAG_FUEL, --fuel);
            }
            double speed = NBTUtils.getDouble(stack, TAG_SPEED, 1.0);
            if (player.f_19797_ % 3 == 0) {
                double maxSpeed = this.getAbilityValue(stack, "boost", TAG_SPEED);
                if (speed < maxSpeed) {
                    speed = Math.min(maxSpeed, speed + (maxSpeed - 1.0) / 100.0);
                    NBTUtils.setDouble(stack, TAG_SPEED, speed);
                } else {
                    player.m_204079_(5);
                }
            }
            Vec3 look = player.m_20154_();
            Vec3 motion = player.m_20184_();
            Level world = player.m_20193_();
            RandomSource random = world.m_213780_();
            player.m_20256_(motion.m_82520_(look.f_82479_ * 0.1 + (look.f_82479_ * speed - motion.f_82479_) * 0.5, look.f_82480_ * 0.1 + (look.f_82480_ * speed - motion.f_82480_) * 0.5, look.f_82481_ * 0.1 + (look.f_82481_ * speed - motion.f_82481_) * 0.5));
            int i = 0;
            while ((double)i < speed * 3.0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_() + (double)(MathUtils.randomFloat(random) * 0.4f), player.m_20186_() + (double)(MathUtils.randomFloat(random) * 0.4f), player.m_20189_() + (double)(MathUtils.randomFloat(random) * 0.4f), 0.0, 0.0, 0.0);
                ++i;
            }
            if (player.f_19797_ % Math.max(1, (int)Math.round((10.0 - speed * 2.0) / (double)(player.m_20070_() ? 2 : 1))) == 0) {
                NBTUtils.setInt(stack, TAG_FUEL, --fuel);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        double speed = NBTUtils.getDouble(stack, TAG_SPEED, 1.0);
        int fuel = NBTUtils.getInt(stack, TAG_FUEL, 0);
        if (speed > 1.0 && (fuel <= 0 || !player.m_21255_())) {
            NBTUtils.setDouble(stack, TAG_SPEED, 1.0);
        }
    }

    @Override
    public ResourceLocation getTexture(ItemStack stack) {
        return new ResourceLocation("relics", "textures/models/items/elytra_booster_" + (NBTUtils.getInt(stack, TAG_FUEL, 0) > 0 ? 1 : 0) + ".png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        model.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition body = mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone = body.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-5.0f, -0.075f, 1.25f, 10.0f, 6.0f, 4.0f, new CubeDeformation(0.025f)).m_171555_(false).m_171514_(0, 23).m_171488_(-2.0f, -2.0f, 3.75f, 4.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = bone.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-3.75f, -11.0f, -1.001f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171480_().m_171488_(-3.75f, -8.0f, -1.0f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)11.25f, (float)2.25f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition cube_r2 = bone.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171480_().m_171488_(2.75f, -11.0f, -1.001f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 10).m_171488_(-2.25f, -8.0f, -1.0f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)11.25f, (float)2.25f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r3 = bone.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(28, 7).m_171480_().m_171488_(-0.15f, -2.975f, -1.8f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-8.7786f, (float)3.4288f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition cube_r4 = bone.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(28, 7).m_171488_(-3.875f, -2.975f, -1.8f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.7786f, (float)3.4288f, (float)4.25f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @SubscribeEvent
    public static void onSlotClick(ContainerSlotClickEvent event) {
        if (event.getAction() != ClickAction.PRIMARY) {
            return;
        }
        Player player = event.getEntity();
        ItemStack heldStack = event.getHeldStack();
        ItemStack slotStack = event.getSlotStack();
        Item item = slotStack.m_41720_();
        if (!(item instanceof ElytraBoosterItem)) {
            return;
        }
        ElytraBoosterItem booster = (ElytraBoosterItem)item;
        int time = ForgeHooks.getBurnTime((ItemStack)heldStack, (RecipeType)RecipeType.f_44108_) / 20;
        int amount = NBTUtils.getInt(slotStack, TAG_FUEL, 0);
        int capacity = booster.getBreathCapacity(slotStack);
        int sum = amount + time;
        if (time <= 0) {
            return;
        }
        NBTUtils.setInt(slotStack, TAG_FUEL, Math.min(capacity, sum));
        int left = sum > capacity ? time - (sum - capacity) : time;
        booster.addExperience((Entity)player, slotStack, (int)Math.floor((float)left / 10.0f));
        ItemStack result = heldStack.getCraftingRemainingItem();
        heldStack.m_41774_(1);
        if (!result.m_41619_()) {
            if (heldStack.m_41619_()) {
                player.f_36096_.m_142503_(result);
            } else {
                player.m_150109_().m_36054_(result);
            }
        }
        player.m_5496_(SoundEvents.f_11705_, 0.75f, 2.0f / ((float)time * 0.025f));
        event.setCanceled(true);
    }
}

