/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.entities.ShadowGlaiveEntity;
import it.hurts.sskirillss.relics.entities.ShadowSawEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicsTab;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class ShadowGlaiveItem
extends RelicItem {
    public static final String TAG_CHARGES = "charges";
    public static final String TAG_TIME = "time";
    public static final String TAG_SAW = "saw";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("glaive").stat(StatData.builder("recharge").initialValue(30.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.09).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("bounces").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("damage").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("radius").initialValue(2.5, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder(TAG_SAW).requiredLevel(5).stat(StatData.builder("speed").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> MathUtils.round(value / 20.0, 2)).build()).stat(StatData.builder("damage").initialValue(0.75, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.END).entry(LootCollections.SCULK).build()).build();
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (group != RelicsTab.RELICS_TAB) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.SHADOW_GLAIVE.get());
        NBTUtils.setInt(stack, TAG_CHARGES, 8);
        items.add((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.m_5776_()) {
            return;
        }
        int charges = NBTUtils.getInt(stack, TAG_CHARGES, 0);
        if (entityIn.f_19797_ % 20 != 0 || charges >= 8) {
            return;
        }
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (this.getSaw(stack, worldIn) != null) {
            return;
        }
        if ((double)time >= this.getAbilityValue(stack, "glaive", "recharge")) {
            NBTUtils.setInt(stack, TAG_CHARGES, charges + 1);
            NBTUtils.setInt(stack, TAG_TIME, 0);
        } else {
            NBTUtils.setInt(stack, TAG_TIME, time + 1);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        int charges = NBTUtils.getInt(stack, TAG_CHARGES, 0);
        RandomSource random = playerIn.m_217043_();
        if (playerIn.m_36335_().m_41519_(stack.m_41720_())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ShadowSawEntity entity = this.getSaw(stack, worldIn);
        if (entity != null) {
            if (!entity.isReturning) {
                entity.isReturning = true;
            }
        } else if (playerIn.m_6144_() && this.canUseAbility(stack, TAG_SAW)) {
            if (charges == 8 && this.getSaw(stack, worldIn) == null) {
                ShadowSawEntity saw = new ShadowSawEntity(stack, (LivingEntity)playerIn);
                saw.setStack(stack);
                saw.m_5602_((Entity)playerIn);
                saw.m_6021_(playerIn.m_20185_(), playerIn.m_20186_() + (double)(playerIn.m_20206_() * 0.5f), playerIn.m_20189_());
                saw.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.75f, 1.0f, 0.0f);
                worldIn.m_7967_((Entity)saw);
                worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), (SoundEvent)SoundRegistry.THROW.get(), SoundSource.MASTER, 0.5f, 0.35f + random.m_188501_() * 0.25f);
                NBTUtils.setInt(stack, TAG_CHARGES, 0);
                NBTUtils.setString(stack, TAG_SAW, saw.m_20149_());
            }
        } else if (charges > 0) {
            Entity entity2;
            ShadowGlaiveEntity glaive = new ShadowGlaiveEntity(worldIn, (LivingEntity)playerIn);
            glaive.setStack(stack);
            glaive.m_5602_((Entity)playerIn);
            glaive.m_6021_(playerIn.m_20185_(), playerIn.m_20186_() + (double)(playerIn.m_20206_() * 0.5f), playerIn.m_20189_());
            glaive.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.75f, 1.0f, 0.0f);
            worldIn.m_7967_((Entity)glaive);
            EntityHitResult result = EntityUtils.rayTraceEntity((Entity)playerIn, entry -> !EntityUtils.isAlliedTo((Entity)playerIn, entry), 32.0);
            if (result != null && (entity2 = result.m_82443_()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity2;
                glaive.setTarget(target);
            }
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), (SoundEvent)SoundRegistry.THROW.get(), SoundSource.MASTER, 0.5f, 0.75f + random.m_188501_() * 0.5f);
            NBTUtils.setInt(stack, TAG_CHARGES, charges - 1);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Nullable
    public ShadowSawEntity getSaw(ItemStack stack, Level level) {
        try {
            UUID uuid = UUID.fromString(NBTUtils.getString(stack, TAG_SAW, ""));
            if (level.m_5776_()) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.m_8791_(uuid);
            if (entity instanceof ShadowSawEntity) {
                ShadowSawEntity saw = (ShadowSawEntity)entity;
                return saw;
            }
            NBTUtils.clearTag(stack, TAG_SAW);
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

