/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.entities.BlockSimulationEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ShockwaveEntity
extends ThrowableProjectile {
    private int radius;
    private float damage;
    private int step;
    private List<BlockPos> poses = new ArrayList<BlockPos>();

    public ShockwaveEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ShockwaveEntity(Level level, int radius, float damage) {
        super((EntityType)EntityRegistry.SHOCKWAVE.get(), level);
        this.radius = radius;
        this.damage = damage;
    }

    public void m_8119_() {
        super.m_8119_();
        BlockPos center = this.m_20183_();
        Level level = this.m_9236_();
        if (this.poses.isEmpty()) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                float r1 = Mth.m_14116_((float)(this.radius * this.radius - i * i));
                int j = -((int)r1);
                while ((float)j <= r1) {
                    this.poses.add(center.m_7918_(i, 0, j));
                    ++j;
                }
            }
        }
        if (!this.poses.isEmpty()) {
            Entity owner = this.m_37282_();
            Vec3 centerVec = new Vec3((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_());
            List<BlockPos> closest = this.poses.stream().filter(p -> new Vec3((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_()).m_82554_(centerVec) <= (double)this.step).toList();
            this.poses.removeAll(closest);
            for (BlockPos p2 : closest) {
                BlockState state;
                if (!level.m_5776_()) {
                    float damage = (float)this.radius * this.damage / (float)this.step;
                    for (LivingEntity entity : level.m_45976_(LivingEntity.class, new AABB(p2, p2.m_6630_(3)).m_82400_(0.5))) {
                        if (owner != null && entity.m_20149_().equals(owner.m_20149_())) continue;
                        Entity entity2 = this.m_37282_();
                        if (entity2 instanceof Player) {
                            Player player = (Player)entity2;
                            EntityUtils.hurt(entity, DamageSource.m_19344_((Player)player), damage);
                        } else {
                            entity.m_6469_(DamageSource.f_19319_, damage);
                        }
                        entity.m_20256_(entity.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82546_(centerVec).m_82541_().m_82542_(2.0, 1.0, 2.0));
                    }
                }
                if (!(state = level.m_8055_(p2)).m_60767_().m_76334_() || level.m_8055_(p2.m_7494_()).m_60767_().m_76334_()) continue;
                BlockSimulationEntity entity = new BlockSimulationEntity(level, state);
                entity.m_6034_((float)p2.m_123341_() + 0.5f, (float)p2.m_123342_() + 0.5f, (float)p2.m_123343_() + 0.5f);
                entity.m_20334_(0.0, (float)this.step * 0.02f, 0.0);
                level.m_7967_((Entity)entity);
            }
            ++this.step;
            if (this.poses.isEmpty() || this.step >= this.poses.size()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.radius = compound.m_128451_("Radius");
        this.damage = compound.m_128457_("Damage");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Radius", this.radius);
        compound.m_128350_("Damage", this.damage);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public List<BlockPos> getPoses() {
        return this.poses;
    }

    public void setPoses(List<BlockPos> poses) {
        this.poses = poses;
    }
}

