/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.mixin.EntityAccess;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public class RelicExperienceOrbEntity
extends Entity {
    private static final EntityDataAccessor<Integer> EXPERIENCE = SynchedEntityData.m_135353_(RelicExperienceOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(RelicExperienceOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public RelicExperienceOrbEntity(EntityType<? extends RelicExperienceOrbEntity> type, Level level) {
        super(type, level);
    }

    public ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(STACK);
    }

    public void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(STACK, (Object)stack);
    }

    public static int getMaxExperience() {
        return 10;
    }

    public int getExperience() {
        return (Integer)this.m_20088_().m_135370_(EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.m_20088_().m_135381_(EXPERIENCE, (Object)experience);
    }

    public int getStage() {
        int stages = 5;
        return Mth.m_14045_((int)(this.getExperience() <= 1 ? 1 : Math.min(this.getExperience() / (RelicExperienceOrbEntity.getMaxExperience() / Math.max(1, stages - 1)) + 1, stages)), (int)1, (int)stages);
    }

    private List<ItemStack> getUpgradeableRelics(Player player) {
        return EntityUtils.getEquippedRelics((LivingEntity)player).stream().filter(stack -> {
            IRelicItem relic = (IRelicItem)stack.m_41720_();
            return !relic.isMaxLevel((ItemStack)stack);
        }).toList();
    }

    private List<ItemStack> getSuitableRelics(Player player) {
        return this.getUpgradeableRelics(player).stream().filter(stack -> this.getStack().m_41619_() || stack.m_41720_() == this.getStack().m_41720_()).toList();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (!this.f_19853_.m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        if (this.f_19797_ >= 15) {
            if (this.getExperience() < RelicExperienceOrbEntity.getMaxExperience()) {
                for (RelicExperienceOrbEntity orb : this.f_19853_.m_45976_(RelicExperienceOrbEntity.class, this.m_20191_())) {
                    if (orb.m_20148_().equals(this.m_20148_()) || orb.m_213877_() || orb.getExperience() >= RelicExperienceOrbEntity.getMaxExperience()) continue;
                    int diff = RelicExperienceOrbEntity.getMaxExperience() - this.getExperience();
                    if (orb.getExperience() < diff) {
                        this.setExperience(this.getExperience() + orb.getExperience());
                        orb.m_146870_();
                        continue;
                    }
                    orb.setExperience(orb.getExperience() - diff);
                    this.setExperience(RelicExperienceOrbEntity.getMaxExperience());
                }
            }
            double maxDistance = 16.0;
            Player player = this.f_19853_.m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), maxDistance, entity -> {
                Player entry = (Player)entity;
                return !entry.m_5833_() && !this.getUpgradeableRelics(entry).isEmpty();
            });
            if (player != null) {
                this.m_20256_(this.m_20184_().m_82549_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_((maxDistance - this.m_20182_().m_82554_(player.m_20182_())) / (maxDistance * 10.0))));
                if (this.m_20182_().m_82554_(player.m_20182_()) <= (double)(player.m_20205_() * 1.25f)) {
                    List<ItemStack> upgradeable = this.getUpgradeableRelics(player);
                    List<ItemStack> suitable = this.getSuitableRelics(player);
                    ItemStack stack = suitable.isEmpty() ? upgradeable.get(this.f_19796_.m_188503_(upgradeable.size())) : suitable.get(this.f_19796_.m_188503_(suitable.size()));
                    IRelicItem relic = (IRelicItem)stack.m_41720_();
                    if (relic.addExperience((Entity)player, stack, this.getExperience())) {
                        this.m_146870_();
                        this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11871_, SoundSource.MASTER, 0.5f, 1.25f + this.f_19853_.m_213780_().m_188501_() * 0.75f);
                    }
                }
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float friction = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            friction = this.f_19853_.m_8055_(pos).getFriction((LevelReader)this.f_19853_, pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)friction, 0.98, (double)friction));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (this.f_19797_ >= 1000) {
            this.m_146870_();
        }
    }

    protected void m_7378_(CompoundTag tag) {
        this.setExperience(tag.m_128451_("experience"));
        this.setStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack")));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("experience", this.getExperience());
        this.getStack().m_41739_(tag.m_128469_("stack"));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(EXPERIENCE, (Object)0);
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
    }

    public BlockPos m_20099_() {
        return ((EntityAccess)((Object)this)).invokeGetOnPos(0.999f);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public SoundSource m_5720_() {
        return SoundSource.AMBIENT;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (EXPERIENCE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        float scale = 0.15f + (float)this.getStage() * 0.05f;
        return EntityDimensions.m_20395_((float)scale, (float)scale);
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82400_((double)0.2f).m_82309_();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }
}

