/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityCardIconWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private static final ResourceLocation UNLOCKED = new ResourceLocation("relics", "textures/gui/description/card_highlight_unlocked.png");
    private static final ResourceLocation LOCKED = new ResourceLocation("relics", "textures/gui/description/card_highlight_locked.png");
    private static final ResourceLocation AVAILABLE = new ResourceLocation("relics", "textures/gui/description/upgrade_available.png");
    private final RelicDescriptionScreen screen;
    private final String ability;
    private float scale = 1.0f;

    public AbilityCardIconWidget(int x, int y, RelicDescriptionScreen screen, String ability) {
        super(x, y, 30, 46);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void m_5691_() {
        this.MC.m_91152_((Screen)new AbilityDescriptionScreen(this.screen.pos, this.screen.stack, this.ability));
    }

    public void m_6303_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TextureManager manager = this.MC.m_91097_();
        boolean canUse = relic.canUseAbility(this.screen.stack, this.ability);
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)this.MC.f_91074_, this.screen.stack, this.ability);
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)this.screen.stack.m_41720_()).m_135815_() + "/" + (String)relic.getAbilityData(this.ability).getIcon().apply((Object)this.MC.f_91074_, (Object)this.screen.stack, (Object)this.ability) + ".png");
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)card);
        manager.m_174784_(card);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_85837_((double)(((float)this.f_93620_ + (float)this.f_93618_ / 2.0f) / this.scale), (double)(((float)this.f_93621_ + (float)this.f_93619_ / 2.0f) / this.scale), 0.0);
        if (!canUse) {
            RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)this.scale);
        } else if (canUpgrade) {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)this.scale);
        }
        AbilityCardIconWidget.m_93133_((PoseStack)poseStack, (int)-11, (int)-16, (float)0.0f, (float)0.0f, (int)20, (int)29, (int)20, (int)29);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.m_174784_(RelicDescriptionScreen.TEXTURE);
        if (canUse) {
            AbilityCardIconWidget.m_93133_((PoseStack)poseStack, (int)(-(this.f_93618_ / 2)), (int)(-(this.f_93619_ / 2)), (float)302.0f, (float)61.0f, (int)this.f_93618_, (int)this.f_93619_, (int)512, (int)512);
            if (this.f_93622_) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)UNLOCKED);
                RenderSystem.m_69478_();
                RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, 0.0f, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
                RenderSystem.m_69461_();
            }
        } else {
            AbilityCardIconWidget.m_93133_((PoseStack)poseStack, (int)(-(this.f_93618_ / 2) - 1), (int)(-(this.f_93619_ / 2)), (float)333.0f, (float)61.0f, (int)(this.f_93618_ + 1), (int)this.f_93619_, (int)512, (int)512);
            if (this.f_93622_) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)LOCKED);
                RenderSystem.m_69478_();
                RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, 0.0f, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
                RenderSystem.m_69461_();
            }
        }
        if (canUpgrade) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)AVAILABLE);
            manager.m_174784_(AVAILABLE);
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, -1.0f, -1.0f, 32.0f, 256.0f, 32.0f, 32.0f, 0.9f + (float)(Math.sin(((float)this.screen.ticksExisted + pPartialTick) * 0.25f) * (double)0.025f), AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 20));
            RenderSystem.m_69461_();
        }
        int xOff = 0;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RelicDescriptionScreen.TEXTURE);
        manager.m_174784_(RelicDescriptionScreen.TEXTURE);
        for (int i = 1; i < relic.getAbilityQuality(this.screen.stack, this.ability) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            AbilityCardIconWidget.m_93133_((PoseStack)poseStack, (int)(-(this.f_93618_ / 2) + xOff + 2), (int)(-(this.f_93619_ / 2) + 38), (float)((canUse ? 302 : 334) + (isAliquot ? 0 : 2)), (float)108.0f, (int)(isAliquot ? 2 : 3), (int)4, (int)512, (int)512);
            xOff += isAliquot ? 2 : 3;
        }
        MutableComponent title = Component.m_237113_((String)String.valueOf(relic.getAbilityPoints(this.screen.stack, this.ability))).m_130940_(ChatFormatting.BOLD);
        float textScale = 0.5f;
        poseStack.m_85841_(textScale, textScale, textScale);
        this.MC.f_91062_.m_92763_(poseStack, (Component)title, -((float)(this.f_93618_ + 1) / 2.0f) - (float)this.MC.f_91062_.m_92852_((FormattedText)title) / 2.0f + 13.0f, -((float)this.f_93619_ / 2.0f) - 19.0f, 16764566);
        poseStack.m_85849_();
    }

    @Override
    public void onTick() {
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        float maxScale = 1.1f;
        float minScale = 1.0f;
        RandomSource random = this.MC.f_91074_.m_217043_();
        if (relic.mayPlayerUpgrade((Player)this.MC.f_91074_, this.screen.stack, this.ability) && this.screen.ticksExisted % 7 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), this.f_93620_ + 5 + random.m_188503_(18), this.f_93621_ + 18, 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
        }
        if (this.f_93622_) {
            if (this.screen.ticksExisted % 3 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(relic.canUseAbility(this.screen.stack, this.ability) ? new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0) : new Color(100 + random.m_188503_(100), 100 + random.m_188503_(100), 100 + random.m_188503_(100)), this.f_93620_ + random.m_188503_(this.f_93618_), this.f_93621_ - 1, 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + (maxScale - this.scale) * 0.25f);
            }
        } else if (this.scale != minScale) {
            this.scale = Math.max(minScale, this.scale - 0.025f);
        }
    }

    @Override
    public void onHovered(PoseStack poseStack, int mouseX, int mouseY) {
        int requiredLevel;
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityData data = relic.getAbilityData(this.ability);
        if (data == null) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 110;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.screen.stack.m_41720_()).m_135815_() + ".ability." + this.ability)).m_130940_(ChatFormatting.BOLD)});
        int level = relic.getLevel(this.screen.stack);
        if (level < (requiredLevel = data.getRequiredLevel())) {
            entries.add(Component.m_237113_((String)" "));
            entries.add(Component.m_237113_((String)"\u25b6 ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.ability.tooltip.low_level", (Object[])new Object[]{requiredLevel, Component.m_237115_((String)"tooltip.relics.relic.status.negative").m_130940_(ChatFormatting.RED)})));
        } else if (data.getMaxLevel() == 0) {
            entries.add(Component.m_237113_((String)" "));
            entries.add(Component.m_237113_((String)"\u25b6 ").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.relic.ability.tooltip.no_stats")));
        } else if (relic.mayPlayerUpgrade((Player)this.MC.f_91074_, this.screen.stack, this.ability)) {
            entries.add(Component.m_237113_((String)" "));
            entries.add(Component.m_237113_((String)"\u25b6 ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.ability.tooltip.ready_to_upgrade", (Object[])new Object[]{Component.m_237115_((String)"tooltip.relics.relic.status.positive").m_130940_(ChatFormatting.GREEN)})));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 4.5f);
        int y = this.m_93694_() / 2;
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_85837_((double)(((float)this.f_93620_ + (float)this.m_5711_() / 2.0f) / this.scale), (double)(((float)this.f_93621_ + (float)this.m_93694_() / 2.0f) / this.scale), 0.0);
        ScreenUtils.drawTexturedTooltipBorder(poseStack, RelicDescriptionScreen.BORDER_PAPER, renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.MC.f_91062_.m_92877_(poseStack, entry, -((float)this.MC.f_91062_.m_92724_(entry) / 2.0f), (float)((y + yOff + 9) * 2), 4269832);
            yOff += 5;
            poseStack.m_85849_();
        }
    }
}

