/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.ability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class AbilityRerollButtonWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final AbilityDescriptionScreen screen;
    private final String ability;

    public AbilityRerollButtonWidget(int x, int y, AbilityDescriptionScreen screen, String ability) {
        super(x, y, 17, 17);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.screen.stack.m_41720_();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerReroll((Player)this.MC.f_91074_, this.screen.stack, this.ability);
    }

    @Override
    public void m_7435_(SoundManager handler) {
        if (!this.isLocked()) {
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundRegistry.TABLE_REROLL.get()), (float)1.0f));
        }
    }

    @Override
    public void m_5691_() {
        if (!this.isLocked()) {
            NetworkHandler.sendToServer(new PacketRelicTweak(this.screen.pos, this.ability, PacketRelicTweak.Operation.REROLL));
        }
    }

    public void m_6303_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbilityDescriptionScreen.TEXTURE);
        manager.m_174784_(AbilityDescriptionScreen.TEXTURE);
        AbilityRerollButtonWidget.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)(this.isLocked() ? 320.0f : 302.0f), (float)88.0f, (int)this.f_93618_, (int)this.f_93619_, (int)512, (int)512);
        if (this.f_93622_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("relics", "textures/gui/description/reroll_highlight_" + (this.isLocked() ? "locked" : "unlocked") + ".png"));
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, (float)this.f_93620_ + (float)this.f_93618_ / 2.0f, (float)this.f_93621_ + (float)this.f_93619_ / 2.0f, 32.0f, 384.0f, 32.0f, 32.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.m_69461_();
        }
    }

    @Override
    public void onHovered(PoseStack poseStack, int mouseX, int mouseY) {
        IRelicItem relic;
        Item item = this.screen.stack.m_41720_();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).canUseAbility(this.screen.stack, this.ability)) {
            return;
        }
        AbilityData data = relic.getAbilityData(this.ability);
        if (data.getStats().isEmpty()) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        int requiredExperience = relic.getRerollRequiredExperience(this.ability);
        int experience = this.MC.f_91074_.f_36079_;
        MutableComponent negativeStatus = Component.m_237115_((String)"tooltip.relics.relic.status.negative").m_130940_(ChatFormatting.RED);
        MutableComponent positiveStatus = Component.m_237115_((String)"tooltip.relics.relic.status.positive").m_130940_(ChatFormatting.GREEN);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.reroll.description").m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)" "), Component.m_237110_((String)"tooltip.relics.relic.reroll.cost", (Object[])new Object[]{requiredExperience, requiredExperience > experience ? negativeStatus : positiveStatus})});
        for (MutableComponent entry : entries) {
            int entryWidth = (this.MC.f_91062_.m_92852_((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 4.5f);
        int renderX = this.f_93620_ + this.f_93618_ + 1;
        int renderY = mouseY - height / 2 - 9;
        ScreenUtils.drawTexturedTooltipBorder(poseStack, RelicDescriptionScreen.BORDER_PAPER, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            this.MC.f_91062_.m_92877_(poseStack, entry, (float)((renderX + 9) * 2), (float)((renderY + 9 + yOff) * 2), 4269832);
            yOff += 5;
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void onTick() {
        RandomSource random = this.MC.f_91074_.m_217043_();
        if (this.m_198029_() && this.screen.ticksExisted % 10 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(this.isLocked() ? new Color(100 + random.m_188503_(100), 100 + random.m_188503_(100), 100 + random.m_188503_(100)) : new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), this.f_93620_ + random.m_188503_(this.f_93618_), this.f_93621_ + random.m_188503_(this.f_93619_), 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
        }
    }
}

