/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.AbilityCardIconWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.ExperienceExchangeWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends Screen
implements IAutoScaledScreen {
    private final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/relic_background.png");
    public static final ResourceLocation LEVELING_POINT_HIGHLIGHT = new ResourceLocation("relics", "textures/gui/description/leveling_point_highlight.png");
    public static final ResourceLocation LEVELING_POINT = new ResourceLocation("relics", "textures/gui/description/leveling_point.png");
    public static final ResourceLocation BORDER_PAPER = new ResourceLocation("relics", "textures/gui/tooltip/border/paper.png");
    public static final ResourceLocation RELIC_EXPERIENCE_HIGHLIGHT = new ResourceLocation("relics", "textures/gui/description/relic_experience_highlight.png");
    public static final ResourceLocation VANILLA_EXPERIENCE_HIGHLIGHT = new ResourceLocation("relics", "textures/gui/description/experience_highlight.png");
    public final BlockPos pos;
    public ItemStack stack;
    public int backgroundHeight = 171;
    public int backgroundWidth = 268;
    public int ticksExisted;

    public RelicDescriptionScreen(BlockPos pos) {
        super((Component)Component.m_237119_());
        this.pos = pos;
        this.gatherData();
    }

    public void gatherData() {
        ClientLevel level = this.MC.f_91073_;
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (!(blockEntity instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        ItemStack stack = tile.getStack();
        if (!(stack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        this.stack = stack;
    }

    protected void m_7856_() {
        Item item;
        if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        int step = 0;
        for (Map.Entry<String, AbilityData> ability : relic.getRelicData().getAbilities().getAbilities().entrySet()) {
            this.m_142416_((GuiEventListener)new AbilityCardIconWidget(x + 41 + step, y + 105, this, ability.getKey()));
            step += 39;
        }
        this.m_142416_((GuiEventListener)new ExperienceExchangeWidget(x + 239, y + 72, this));
    }

    public void m_86600_() {
        Item item;
        super.m_86600_();
        LocalPlayer player = this.MC.f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (!(blockEntity instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        this.stack = tile.getStack();
        if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        ++this.ticksExisted;
        RandomSource random = player.m_217043_();
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        if (this.ticksExisted % 3 == 0) {
            int xOff;
            float percentage;
            int sourceWidth;
            int maxWidth;
            int xOff2;
            int relicLevel = relic.getLevel(this.stack);
            int sourceWidth2 = 206;
            float percentage2 = relic.isMaxLevel(this.stack) ? 100.0f : (float)relic.getExperience(this.stack) / ((float)relic.getExperienceBetweenLevels(this.stack, relicLevel, relicLevel + 1) / 100.0f);
            int maxWidth2 = (int)((float)sourceWidth2 * (percentage2 / 100.0f));
            if (maxWidth2 > 0 && (xOff2 = random.m_188503_(sourceWidth2)) <= maxWidth2) {
                ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), x + 30 + xOff2, y + 73, 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
            }
            if ((maxWidth = (int)((float)(sourceWidth = 206) * ((percentage = (float)((int)((float)player.f_36079_ / ((float)player.f_36079_ / player.f_36080_ / 100.0f)))) / 100.0f))) > 0 && (xOff = random.m_188503_(sourceWidth)) <= maxWidth) {
                ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(100 + random.m_188503_(50), 200 + random.m_188503_(50), 0), x + 30 + xOff, y + 86, 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
            }
        }
        if (this.ticksExisted % 10 == 0 && relic.getPoints(this.stack) > 0) {
            ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), x + this.backgroundWidth + 15 + random.m_188503_(16), y + 8 + random.m_188503_(10), 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int renderY;
        int renderX;
        int height;
        int entryWidth;
        ArrayList entries;
        int renderWidth;
        int maxWidth;
        ArrayList tooltip;
        IRelicItem relic;
        LocalPlayer player;
        block25: {
            block24: {
                Item item;
                player = this.MC.f_91074_;
                if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) break block24;
                relic = (IRelicItem)item;
                if (player != null) break block25;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        TextureManager manager = this.MC.m_91097_();
        this.m_7333_(pPoseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.backgroundWidth, (int)this.backgroundHeight, (int)texWidth, (int)texHeight);
        int level = relic.getLevel(this.stack);
        float percentage = (float)relic.getExperience(this.stack) / ((float)relic.getExperienceBetweenLevels(this.stack, level, level + 1) / 100.0f);
        boolean isMaxLevel = relic.isMaxLevel(this.stack);
        RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 30), (int)(y + 72), (float)302.0f, (float)144.0f, (int)(isMaxLevel ? 206 : (int)Math.ceil(percentage / 100.0f * 206.0f)), (int)3, (int)texWidth, (int)texHeight);
        boolean hoveredRelicExperience = ScreenUtils.isHovered(x + 30, y + 72, 206, 3, pMouseX, pMouseY);
        if (hoveredRelicExperience) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)RELIC_EXPERIENCE_HIGHLIGHT);
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(pPoseStack, (float)x + 133.0f, (float)y + 73.5f, 210.0f, 98.0f, 210.0f, 7.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2));
            RenderSystem.m_69461_();
        }
        percentage = (float)player.f_36079_ / ((float)player.f_36079_ / player.f_36080_ / 100.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 30), (int)(y + 85), (float)302.0f, (float)148.0f, (int)((int)Math.ceil(percentage / 100.0f * 206.0f)), (int)3, (int)texWidth, (int)texHeight);
        boolean hoveredVanillaExperience = ScreenUtils.isHovered(x + 30, y + 85, 206, 3, pMouseX, pMouseY);
        if (hoveredVanillaExperience) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)VANILLA_EXPERIENCE_HIGHLIGHT);
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(pPoseStack, (float)x + 133.0f, (float)y + 86.5f, 210.0f, 98.0f, 210.0f, 7.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2));
            RenderSystem.m_69461_();
        }
        ResourceLocation background = relic.getStyleData().getBackground();
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        float color = (float)(0.75 + Math.sin((float)player.f_19797_ * 0.1f) * (double)0.05f);
        RenderSystem.m_157429_((float)color, (float)color, (float)color, (float)1.0f);
        RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 18), (int)(y + 15), (float)0.0f, (float)0.0f, (int)34, (int)34, (int)34, (int)34);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 13), (int)(y + 10), (float)302.0f, (float)5.0f, (int)46, (int)55, (int)texWidth, (int)texHeight);
        float scale = 1.75f;
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85837_((double)(x + 21), (double)((float)y + 18.5f), 0.0);
        RenderSystem.m_157191_().m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_115123_(this.stack, 0, 0);
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int xOff = 0;
        for (int i = 1; i < relic.getRelicQuality(this.stack) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 15 + xOff), (int)(y + 51), (float)(353 + (isAliquot ? 0 : 5)), (float)3.0f, (int)(isAliquot ? 5 : 4), (int)9, (int)texWidth, (int)texHeight);
            xOff += isAliquot ? 5 : 3;
        }
        MutableComponent name = Component.m_237113_((String)this.stack.m_41611_().getString().replace("[", "").replace("]", "")).m_130940_(ChatFormatting.BOLD);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        this.MC.f_91062_.m_92889_(pPoseStack, (Component)name, (float)((x + 62) * 2), (float)((y + 21) * 2), 4269832);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.75f, 0.75f, 0.75f);
        MutableComponent experience = isMaxLevel ? Component.m_237115_((String)"tooltip.relics.relic.max_level") : Component.m_237113_((String)String.valueOf(level));
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, ((float)x + 135.75f) * 1.33f, (float)(y + 71) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, ((float)x + 134.25f) * 1.33f, (float)(y + 71) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 71.75f) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 70.25f) * 1.33f, 7942912, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, (float)(y + 71) * 1.33f, 0xFFF500, false);
        experience = Component.m_237113_((String)String.valueOf(player.f_36078_));
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, ((float)x + 135.75f) * 1.33f, (float)(y + 84) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, ((float)x + 134.25f) * 1.33f, (float)(y + 84) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 84.75f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 83.25f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, (float)(y + 84) * 1.33f, 8322080, false);
        pPoseStack.m_85849_();
        String registryName = ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        int yOff = 9;
        ArrayList lines = new ArrayList();
        for (String entry : Component.m_237115_((String)("tooltip.relics." + registryName + ".leveling")).getString().lines().toList()) {
            lines.addAll(this.MC.f_91062_.m_92923_((FormattedText)Component.m_237113_((String)"\u25cf ").m_130946_(entry), 350));
        }
        for (FormattedCharSequence line : lines) {
            this.MC.f_91062_.m_92877_(pPoseStack, line, (float)((x + 62) * 2), (float)((y + 26) * 2 + yOff), 4269832);
            yOff += 9;
        }
        pPoseStack.m_85849_();
        int points = relic.getPoints(this.stack);
        if (points > 0) {
            pPoseStack.m_85836_();
            MutableComponent value = Component.m_237113_((String)String.valueOf(points)).m_130940_(ChatFormatting.BOLD);
            manager.m_174784_(LEVELING_POINT);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)LEVELING_POINT);
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + this.backgroundWidth + 5), (int)(y - 2), (float)0.0f, (float)0.0f, (int)50, (int)31, (int)50, (int)31);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)value, (float)(x + this.backgroundWidth + 39) - (float)this.MC.f_91062_.m_92852_((FormattedText)value) / 2.0f, (float)(y + 10), 16764566);
            pPoseStack.m_85849_();
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (hoveredRelicExperience) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.0, 10.0);
            tooltip = Lists.newArrayList();
            maxWidth = 200;
            renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.relic_experience.title").m_130940_(ChatFormatting.BOLD)});
            if (!isMaxLevel) {
                entries.add(Component.m_237113_((String)" "));
                entries.add(Component.m_237113_((String)"\u25cf ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.relic_experience.current_amount", (Object[])new Object[]{relic.getExperience(this.stack), relic.getExperienceBetweenLevels(this.stack, level, level + 1), MathUtils.round((float)relic.getExperience(this.stack) / ((float)relic.getExperienceBetweenLevels(this.stack, level, level + 1) / 100.0f), 1)})));
            }
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX - 9 - renderWidth / 2;
            renderY = y + 77;
            ScreenUtils.drawTexturedTooltipBorder(pPoseStack, BORDER_PAPER, renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                this.MC.f_91062_.m_92877_(pPoseStack, entry, (float)((renderX + 9) * 2), (float)((renderY + 9 + yOff) * 2), 4269832);
                yOff += 5;
            }
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
        }
        if (hoveredVanillaExperience) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.0, 10.0);
            tooltip = Lists.newArrayList();
            maxWidth = 200;
            renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.vanilla_experience.title").m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)" "), Component.m_237113_((String)"\u25cf ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.vanilla_experience.current_amount", (Object[])new Object[]{player.f_36079_ - EntityUtils.getTotalExperienceForLevel(player.f_36078_), EntityUtils.getTotalExperienceForLevel(player.f_36078_ + 1) - EntityUtils.getTotalExperienceForLevel(player.f_36078_), MathUtils.round(player.f_36080_ * 100.0f, 1)})), Component.m_237113_((String)"\u25cf ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.vanilla_experience.total_amount", (Object[])new Object[]{player.f_36079_}))});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX - 9 - renderWidth / 2;
            renderY = y + 90;
            ScreenUtils.drawTexturedTooltipBorder(pPoseStack, BORDER_PAPER, renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                this.MC.f_91062_.m_92877_(pPoseStack, entry, (float)((renderX + 9) * 2), (float)((renderY + 9 + yOff) * 2), 4269832);
                yOff += 5;
            }
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
        }
        if (points > 0 && ScreenUtils.isHovered(x + this.backgroundWidth + 5, y - 2, 50, 31, pMouseX, pMouseY)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)LEVELING_POINT_HIGHLIGHT);
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(pPoseStack, x + this.backgroundWidth + 5 + 25, y - 2 + 15, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.m_69461_();
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.0, 10.0);
            tooltip = Lists.newArrayList();
            maxWidth = 200;
            renderWidth = 0;
            entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.leveling_points.title").m_130940_(ChatFormatting.BOLD)});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX + 1;
            renderY = pMouseY + 1;
            ScreenUtils.drawTexturedTooltipBorder(pPoseStack, BORDER_PAPER, renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                this.MC.f_91062_.m_92877_(pPoseStack, entry, (float)((renderX + 9) * 2), (float)((renderY + 9 + yOff) * 2), 4269832);
                yOff += 5;
            }
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
        }
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_198029_() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(pPoseStack, pMouseX, pMouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.MC.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }
}

