/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityRerollButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityResetButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityUpgradeButtonWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen
implements IAutoScaledScreen {
    private final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/ability_background.png");
    public final BlockPos pos;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 171;
    public int backgroundWidth = 268;
    public AbilityUpgradeButtonWidget upgradeButton;
    public AbilityRerollButtonWidget rerollButton;
    public AbilityResetButtonWidget resetButton;
    public int ticksExisted;

    public AbilityDescriptionScreen(BlockPos pos, ItemStack stack, String ability) {
        super((Component)Component.m_237119_());
        this.pos = pos;
        this.stack = stack;
        this.ability = ability;
    }

    protected void m_7856_() {
        if (this.stack == null || !(this.stack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        this.upgradeButton = new AbilityUpgradeButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 233, (this.f_96544_ - this.backgroundHeight) / 2 + 104, this, this.ability);
        this.rerollButton = new AbilityRerollButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 233, (this.f_96544_ - this.backgroundHeight) / 2 + 122, this, this.ability);
        this.resetButton = new AbilityResetButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 233, (this.f_96544_ - this.backgroundHeight) / 2 + 140, this, this.ability);
        this.m_142416_((GuiEventListener)this.upgradeButton);
        this.m_142416_((GuiEventListener)this.rerollButton);
        this.m_142416_((GuiEventListener)this.resetButton);
    }

    public void m_86600_() {
        int xOff;
        int percentage;
        int sourceWidth;
        int maxWidth;
        super.m_86600_();
        LocalPlayer player = this.MC.f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (!(blockEntity instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        this.stack = tile.getStack();
        if (this.stack == null || !(this.stack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        ++this.ticksExisted;
        RandomSource random = player.m_217043_();
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        if (this.ticksExisted % 3 == 0 && (maxWidth = (int)((float)(sourceWidth = 206) * ((float)(percentage = (int)((float)player.f_36079_ / ((float)player.f_36079_ / player.f_36080_ / 100.0f))) / 100.0f))) > 0 && (xOff = random.m_188503_(sourceWidth)) <= maxWidth) {
            ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(100 + random.m_188503_(50), 200 + random.m_188503_(50), 0), x + 30 + xOff, y + 82, 0.15f + random.m_188501_() * 0.25f, 100 + random.m_188503_(50)));
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int renderY;
        int renderX;
        int height;
        int entryWidth;
        int renderWidth;
        IRelicItem relic;
        LocalPlayer player;
        block30: {
            block29: {
                Item item;
                player = this.MC.f_91074_;
                if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) break block29;
                relic = (IRelicItem)item;
                if (player != null) break block30;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        AbilityData abilityData = relic.getAbilityData(this.ability);
        if (abilityData == null) {
            return;
        }
        TextureManager manager = this.MC.m_91097_();
        this.m_7333_(pPoseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.backgroundWidth, (int)this.backgroundHeight, (int)texWidth, (int)texHeight);
        int percentage = (int)((float)player.f_36079_ / ((float)player.f_36079_ / player.f_36080_ / 100.0f));
        AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 30), (int)(y + 82), (float)301.0f, (float)124.0f, (int)((int)Math.ceil((float)percentage / 100.0f * 206.0f)), (int)3, (int)texWidth, (int)texHeight);
        boolean hoveredVanillaExperience = ScreenUtils.isHovered(x + 30, y + 81, 206, 3, pMouseX, pMouseY);
        if (hoveredVanillaExperience) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)RelicDescriptionScreen.VANILLA_EXPERIENCE_HIGHLIGHT);
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(pPoseStack, (float)x + 134.0f, (float)y + 83.5f, 210.0f, 98.0f, 210.0f, 7.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2));
            RenderSystem.m_69461_();
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.75f, 0.75f, 0.75f);
        MutableComponent experience = Component.m_237113_((String)String.valueOf(player.f_36078_));
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, ((float)x + 135.75f) * 1.33f, (float)(y + 81) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, ((float)x + 134.25f) * 1.33f, (float)(y + 81) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 81.75f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, ((float)y + 80.25f) * 1.33f, 345347, false);
        ScreenUtils.drawCenteredString(pPoseStack, this.MC.f_91062_, (Component)experience, (float)(x + 135) * 1.33f, (float)(y + 81) * 1.33f, 8322080, false);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int level = relic.getAbilityPoints(this.stack, this.ability);
        int maxLevel = abilityData.getMaxLevel() == -1 ? relicData.getLeveling().getMaxLevel() / abilityData.getRequiredPoints() : abilityData.getMaxLevel();
        MutableComponent name = Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability));
        if (!abilityData.getStats().isEmpty()) {
            name.m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.ability.level", (Object[])new Object[]{level, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)}));
        }
        this.MC.f_91062_.m_92889_(pPoseStack, (Component)name.m_130940_(ChatFormatting.BOLD), (float)((x + 62) * 2), (float)((y + 20) * 2 - 1), 4269832);
        List lines = this.MC.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".description")), 350);
        for (int i = 0; i < lines.size(); ++i) {
            this.MC.f_91062_.m_92877_(pPoseStack, (FormattedCharSequence)lines.get(i), (float)((x + 62) * 2), (float)((y + 28 + i * 5) * 2), 4269832);
        }
        pPoseStack.m_85849_();
        int yOff = 0;
        int xOff = 0;
        boolean isLocked = !relic.canUseAbility(this.stack, this.ability);
        boolean isHoveredUpgrade = !isLocked && this.upgradeButton.m_198029_();
        boolean isHoveredReroll = !isLocked && this.rerollButton.m_198029_();
        boolean isHoveredReset = !isLocked && this.resetButton.m_198029_();
        for (String stat : relic.getAbilityInitialValues(this.stack, this.ability).keySet()) {
            int i;
            StatData statData = relic.getStatData(this.ability, stat);
            if (statData == null) continue;
            MutableComponent cost = Component.m_237113_((String)String.valueOf(statData.getFormatValue().apply(relic.getAbilityValue(this.stack, this.ability, stat))));
            if (isHoveredUpgrade && level < maxLevel) {
                cost.m_130946_(" \u27a0 " + statData.getFormatValue().apply(relic.getAbilityValue(this.stack, this.ability, stat, level + 1)));
            }
            if (isHoveredReroll) {
                cost.m_130946_(" \u27a0 ").m_7220_((Component)Component.m_237113_((String)"X.XXX").m_130940_(ChatFormatting.OBFUSCATED));
            }
            if (isHoveredReset && level > 0) {
                cost.m_130946_(" \u27a0 " + statData.getFormatValue().apply(relic.getAbilityValue(this.stack, this.ability, stat, 0)));
            }
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".stat." + stat + ".title")), (float)((x + 35) * 2), (float)((y + yOff + 102) * 2), 4269832);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)Component.m_237113_((String)" \u25cf ").m_7220_((Component)Component.m_237110_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".stat." + stat + ".value"), (Object[])new Object[]{cost})), (float)((x + 40) * 2), (float)((y + yOff + 107) * 2), 4269832);
            pPoseStack.m_85849_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            for (i = 0; i < 5; ++i) {
                AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + xOff + 202), (int)(y + yOff + 102), (float)398.0f, (float)15.0f, (int)4, (int)4, (int)512, (int)512);
                xOff += 5;
            }
            xOff = 0;
            manager.m_174784_(TEXTURE);
            for (i = 1; i < relic.getStatQuality(this.stack, this.ability, stat) + 1; ++i) {
                boolean isAliquot = i % 2 == 1;
                AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + xOff + 202), (int)(y + yOff + 102), (float)((isLocked ? 407 : 398) + (isAliquot ? 0 : 2)), (float)10.0f, (int)(isAliquot ? 2 : 3), (int)4, (int)512, (int)512);
                xOff += isAliquot ? 2 : 3;
            }
            yOff += 14;
            xOff = 0;
        }
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + "/" + (String)abilityData.getIcon().apply((Object)player, (Object)this.stack, (Object)this.ability) + ".png");
        RenderSystem.m_157456_((int)0, (ResourceLocation)card);
        manager.m_174784_(card);
        if (GlStateManager.m_84384_((int)3553, (int)0, (int)4097) == 29) {
            if (isLocked) {
                RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            AbilityDescriptionScreen.m_93160_((PoseStack)pPoseStack, (int)(x + 17), (int)(y + 11), (int)36, (int)50, (float)0.0f, (float)0.0f, (int)20, (int)29, (int)20, (int)29);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        if (isLocked) {
            AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 12), (int)(y + 7), (float)349.0f, (float)0.0f, (int)47, (int)69, (int)texWidth, (int)texHeight);
        } else {
            AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 13), (int)(y + 7), (float)302.0f, (float)0.0f, (int)46, (int)69, (int)texWidth, (int)texHeight);
        }
        for (int i = 1; i < relic.getAbilityQuality(this.stack, this.ability) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 15 + xOff), (int)(y + 63), (float)((isLocked ? 407 : 397) + (isAliquot ? 0 : 5)), (float)0.0f, (int)(isAliquot ? 5 : 4), (int)9, (int)texWidth, (int)texHeight);
            xOff += isAliquot ? 5 : 3;
        }
        int points = relic.getPoints(this.stack);
        if (points > 0) {
            pPoseStack.m_85836_();
            MutableComponent value = Component.m_237113_((String)String.valueOf(points)).m_130940_(ChatFormatting.BOLD);
            manager.m_174784_(RelicDescriptionScreen.LEVELING_POINT);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)RelicDescriptionScreen.LEVELING_POINT);
            AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + this.backgroundWidth + 5), (int)(y - 2), (float)0.0f, (float)0.0f, (int)50, (int)31, (int)50, (int)31);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)value, (float)(x + this.backgroundWidth + 39) - (float)this.MC.f_91062_.m_92852_((FormattedText)value) / 2.0f, (float)(y + 10), 16764566);
            pPoseStack.m_85849_();
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (hoveredVanillaExperience) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.0, 10.0);
            ArrayList tooltip = Lists.newArrayList();
            int maxWidth = 200;
            renderWidth = 0;
            ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.vanilla_experience.title").m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)" "), Component.m_237113_((String)"\u25cf ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.vanilla_experience.current_amount", (Object[])new Object[]{player.f_36079_ - EntityUtils.getTotalExperienceForLevel(player.f_36078_), EntityUtils.getTotalExperienceForLevel(player.f_36078_ + 1) - EntityUtils.getTotalExperienceForLevel(player.f_36078_), MathUtils.round(player.f_36080_ * 100.0f, 1)})), Component.m_237113_((String)"\u25cf ").m_7220_((Component)Component.m_237110_((String)"tooltip.relics.relic.vanilla_experience.total_amount", (Object[])new Object[]{player.f_36079_}))});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX - 9 - renderWidth / 2;
            renderY = y + 87;
            ScreenUtils.drawTexturedTooltipBorder(pPoseStack, RelicDescriptionScreen.BORDER_PAPER, renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                this.MC.f_91062_.m_92877_(pPoseStack, entry, (float)((renderX + 9) * 2), (float)((renderY + 9 + yOff) * 2), 4269832);
                yOff += 5;
            }
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
        }
        if (points > 0 && ScreenUtils.isHovered(x + this.backgroundWidth + 5, y - 2, 50, 31, pMouseX, pMouseY)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)RelicDescriptionScreen.LEVELING_POINT_HIGHLIGHT);
            RenderSystem.m_69478_();
            RenderUtils.renderAnimatedTextureFromCenter(pPoseStack, (float)(x + this.backgroundWidth + 5) + 25.0f, (float)(y - 2) + 15.5f, 64.0f, 768.0f, 64.0f, 64.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2));
            RenderSystem.m_69461_();
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.0, 10.0);
            ArrayList tooltip = Lists.newArrayList();
            int maxWidth = 200;
            renderWidth = 0;
            ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.leveling_points.title").m_130940_(ChatFormatting.BOLD)});
            for (MutableComponent entry : entries) {
                entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
                if (entryWidth > renderWidth) {
                    renderWidth = Math.min(entryWidth, maxWidth);
                }
                tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
            }
            height = Math.round((float)tooltip.size() * 4.5f);
            renderX = pMouseX + 1;
            renderY = pMouseY + 1;
            ScreenUtils.drawTexturedTooltipBorder(pPoseStack, RelicDescriptionScreen.BORDER_PAPER, renderWidth, height, renderX, renderY);
            yOff = 0;
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            for (FormattedCharSequence entry : tooltip) {
                this.MC.f_91062_.m_92877_(pPoseStack, entry, (float)((renderX + 9) * 2), (float)((renderY + 9 + yOff) * 2), 4269832);
                yOff += 5;
            }
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
        }
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_198029_() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(pPoseStack, pMouseX, pMouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.MC.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7379_() {
        this.MC.m_91152_((Screen)new RelicDescriptionScreen(this.pos));
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }
}

