/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.hud.abilities;

import it.hurts.sskirillss.relics.client.hud.abilities.AbilitiesRenderHandler;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;

public class ActiveAbilityUtils {
    public static ItemStack getStackInCuriosSlot(Player player, int slot) {
        return CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).map(handler -> handler.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public static List<AbilitiesRenderHandler.AbilityEntry> getActiveEntries(Player player) {
        ArrayList<AbilitiesRenderHandler.AbilityEntry> entries = new ArrayList<AbilitiesRenderHandler.AbilityEntry>();
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                Item patt1203$temp = stack.m_41720_();
                if (!(patt1203$temp instanceof IRelicItem)) continue;
                IRelicItem relic = (IRelicItem)patt1203$temp;
                List<String> abilities = ActiveAbilityUtils.getRelicActiveAbilities(stack);
                if (abilities.isEmpty()) continue;
                for (String ability : abilities) {
                    if (!relic.canUseAbility(stack, ability)) continue;
                    entries.add(new AbilitiesRenderHandler.AbilityEntry(slot, ability));
                }
            }
        });
        return entries;
    }

    public static List<String> getRelicActiveAbilities(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return new ArrayList<String>();
        }
        IRelicItem relic = (IRelicItem)item;
        ArrayList<String> abilities = new ArrayList<String>();
        for (Map.Entry<String, AbilityData> ability : relic.getRelicData().getAbilities().getAbilities().entrySet()) {
            if (ability.getValue().getCastData().getKey() == CastType.NONE) continue;
            abilities.add(ability.getKey());
        }
        return abilities;
    }
}

