/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import satisfy.bakery.registry.RecipeTypeRegistry;
import satisfy.bakery.util.GeneralUtil;

public class BakerStationRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public BakerStationRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 1, 2);
    }

    public ItemStack m_5874_(Container inventory) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.BAKER_STATION_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.BAKER_STATION_RECIPE_TYPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BakerStationRecipe> {
        public BakerStationRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = GeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Baker Station Recipe");
            }
            if (ingredients.size() > 2) {
                throw new JsonParseException("Too many ingredients for Baker Station Recipe");
            }
            return new BakerStationRecipe(id, ingredients, ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")));
        }

        public BakerStationRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            return new BakerStationRecipe(id, (NonNullList<Ingredient>)ingredients, buf.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf buf, BakerStationRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.m_130055_(recipe.m_8043_());
        }
    }
}

