/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfy.bakery.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum BakerStationRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    CAKE(new ItemStack((ItemLike)Blocks.f_50145_)),
    CUPCAKE(new ItemStack((ItemLike)ObjectRegistry.APPLE_CUPCAKE.get()));

    public static final List<IRecipeBookGroup> CAKE_GROUPS;
    private final List<ItemStack> icons;

    private BakerStationRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SEARCH -> true;
            case CAKE -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(((Item)ObjectRegistry.BLANK_CAKE.get()).m_7968_()));
            case CUPCAKE -> recipe.m_7527_().stream().noneMatch(ingredient -> ingredient.test(((Item)ObjectRegistry.SWEET_DOUGH.get()).m_7968_()));
        };
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        CAKE_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)CAKE), (Object)((Object)CUPCAKE));
    }
}

