/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.block;

import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfy.bakery.registry.StorageTypeRegistry;

public class CakeStandBlock
extends StorageBlock {
    public static VoxelShape SHAPE = CakeStandBlock.makeShape();

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5000625, (double)0.125, (double)0.125, (double)1.0000625, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5000625, (double)0.125, (double)0.875, (double)1.0000625, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5000625, (double)0.875, (double)0.875, (double)1.0000625, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)1.0000625, (double)0.125, (double)0.875, (double)1.0000625, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.5000625, (double)0.125, (double)0.875, (double)1.0000625, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)1.0, (double)0.4375, (double)0.5625, (double)1.0625, (double)0.5625));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.6875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)0.4375, (double)0.75));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.5, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.34375, (double)0.0625, (double)0.34375, (double)0.65625, (double)0.1875, (double)0.65625));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.4375, (double)0.125, (double)0.9375, (double)0.5, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.4375, (double)0.125, (double)0.125, (double)0.5, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.0625, (double)0.875, (double)0.5, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.875, (double)0.875, (double)0.5, (double)0.9375));
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public CakeStandBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public int findFirstEmpty(NonNullList<ItemStack> inv) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (!stack.m_41619_()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public int findFirstFull(NonNullList<ItemStack> inv) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.m_41619_()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity shelfBlockEntity = (StorageBlockEntity)blockEntity;
            LinkedList items = new LinkedList();
            shelfBlockEntity.getInventory().forEach(stack -> {
                if (!stack.m_41619_()) {
                    items.add(stack.m_41720_());
                }
            });
            if (player.m_6144_()) {
                boolean cCake = false;
                for (Item item : items) {
                    if (!(item instanceof BlockItem)) continue;
                    cCake = true;
                    break;
                }
                if (cCake) {
                    this.remove(world, pos, player, shelfBlockEntity, 0);
                    return InteractionResult.m_19078_((boolean)world.m_5776_());
                }
                int i = this.findFirstFull((NonNullList<ItemStack>)shelfBlockEntity.getInventory());
                if (i != Integer.MIN_VALUE) {
                    this.remove(world, pos, player, shelfBlockEntity, i);
                    return InteractionResult.m_19078_((boolean)world.m_5776_());
                }
            } else {
                ItemStack stack2 = player.m_21120_(hand);
                if (!stack2.m_41619_() && this.canInsertStack(stack2)) {
                    int i;
                    if (stack2.m_41720_() instanceof BlockItem) {
                        if (items.isEmpty()) {
                            this.add(world, pos, player, shelfBlockEntity, stack2, 0);
                            return InteractionResult.m_19078_((boolean)world.m_5776_());
                        }
                    } else if (!(((ItemStack)shelfBlockEntity.getInventory().get(0)).m_41720_() instanceof BlockItem) && (i = this.findFirstEmpty((NonNullList<ItemStack>)shelfBlockEntity.getInventory())) != Integer.MIN_VALUE) {
                        this.add(world, pos, player, shelfBlockEntity, stack2, i);
                        return InteractionResult.m_19078_((boolean)world.m_5776_());
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public int size() {
        return 3;
    }

    public ResourceLocation type() {
        return StorageTypeRegistry.CAKE_STAND;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_41614_() || stack.m_41720_() instanceof BlockItem;
    }

    public int getSection(Float x, Float y) {
        return 0;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.bakery.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        tooltip.add((Component)Component.m_237115_((String)"block.bakery.cakestand_1.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.WHITE}));
        tooltip.add((Component)Component.m_237115_((String)"block.bakery.cakestand_2.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.WHITE}));
    }
}

