/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.mixin;

import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import com.aqutheseal.celestisynth.common.network.util.SetPersistentIntPacket;
import com.aqutheseal.celestisynth.manager.CSNetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerMixinSupport {
    private static final String CAMERA_ANGLE_ORDINAL = "cs.cameraOrdinal";
    private static final String SCREENSHAKE_DURATION = "cs.screenShakeDuration";
    private static final String SCREENSHAKE_FADEOUTBEGIN = "cs.screenShakeFadeoutStart";
    private static final String SCREENSHAKE_INTENSITY = "cs.screenShakeIntensity";

    private PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract Inventory m_150109_();

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void celestisynth$attack(Entity pTarget, CallbackInfo ci) {
        if (this.cancelCI(this.m_21205_()) || this.cancelCI(this.m_21206_())) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void celestisynth$tick(CallbackInfo ci) {
        CSWeapon cs;
        Item item;
        if (this.f_19853_.m_5776_() && this.getScreenShakeDuration() > 0) {
            if (this.getScreenShakeIntensity() > 1.0f) {
                this.setScreenShakeIntensity(1.0f);
            }
            this.setScreenShakeDuration(this.getScreenShakeDuration() - 1);
            if (this.getScreenShakeDuration() < this.getScreenShakeFadeoutBegin()) {
                this.setScreenShakeIntensity(Math.max(0.0f, this.getScreenShakeIntensity() - 0.001f));
            }
        }
        if ((item = this.m_21205_().m_41720_()) instanceof CSWeapon) {
            cs = (CSWeapon)item;
            cs.forceTick(this.m_21205_(), this.f_19853_, (Entity)this, this.m_150109_().f_35977_, this.m_150109_().m_36056_() == this.m_21205_());
        }
        if ((item = this.m_21206_().m_41720_()) instanceof CSWeapon) {
            cs = (CSWeapon)item;
            cs.forceTick(this.m_21206_(), this.f_19853_, (Entity)this, 40, this.m_150109_().m_36056_() == this.m_21206_());
        }
    }

    @Override
    public int getScreenShakeDuration() {
        return this.getPersistentData().m_128451_(SCREENSHAKE_DURATION);
    }

    @Override
    public void setScreenShakeDuration(int duration) {
        this.getPersistentData().m_128405_(SCREENSHAKE_DURATION, duration);
    }

    @Override
    public int getScreenShakeFadeoutBegin() {
        return this.getPersistentData().m_128451_(SCREENSHAKE_FADEOUTBEGIN);
    }

    @Override
    public void setScreenShakeFadeoutBegin(int beginByValue) {
        this.getPersistentData().m_128405_(SCREENSHAKE_FADEOUTBEGIN, beginByValue);
    }

    @Override
    public float getScreenShakeIntensity() {
        return this.getPersistentData().m_128457_(SCREENSHAKE_INTENSITY);
    }

    @Override
    public void setScreenShakeIntensity(float intensity) {
        this.getPersistentData().m_128350_(SCREENSHAKE_INTENSITY, intensity);
    }

    @Override
    public int getCameraAngleOrdinal() {
        return this.getPersistentData().m_128451_(CAMERA_ANGLE_ORDINAL);
    }

    @Override
    public void setCameraAngleOrdinal(int ordinal) {
        if (this.f_19853_.m_5776_()) {
            this.getPersistentData().m_128405_(CAMERA_ANGLE_ORDINAL, ordinal);
            CSNetworkManager.sendToServer(new SetPersistentIntPacket(CAMERA_ANGLE_ORDINAL, ordinal));
        }
    }

    private boolean cancelCI(ItemStack stack) {
        CompoundTag controllerTag;
        if (stack.m_41720_() instanceof CSWeapon && (controllerTag = stack.m_41737_("csController")) != null) {
            return controllerTag.m_128471_("cs.hasAnimationBegun");
        }
        return false;
    }
}

