/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.manager;

import com.aqutheseal.celestisynth.config.client.CSClientConfig;
import com.aqutheseal.celestisynth.config.common.CSCommonConfig;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class CSConfigManager {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CSCommonConfig COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CSClientConfig CLIENT;

    protected static void registerConfigs() {
        CSConfigManager.registerConfigFolder();
        CSConfigManager.registerClientConfig();
        CSConfigManager.registerCommonConfig();
        CSConfigManager.registerServerConfig();
    }

    private static void registerClientConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC, "celestisynth/celestisynth-client.toml");
    }

    private static void registerCommonConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, "celestisynth/celestisynth-common.toml");
    }

    private static void registerServerConfig() {
    }

    private static void registerConfigFolder() {
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("celestisynth"), (String)"celestisynth");
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(CSCommonConfig::new);
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(CSClientConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (CSCommonConfig)commonSpecPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (CSClientConfig)clientSpecPair.getLeft();
    }
}

