/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.events;

import com.aqutheseal.celestisynth.api.animation.player.AnimationManager;
import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.api.mixin.LivingMixinSupport;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import com.aqutheseal.celestisynth.common.entity.skill.SkillCastPoltergeistWard;
import com.aqutheseal.celestisynth.common.item.weapons.BreezebreakerItem;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CSCommonMiscEvents {
    @SubscribeEvent
    public static void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingMixinSupport lms;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingMixinSupport && (lms = (LivingMixinSupport)livingEntity).getQuasarImbued() != null) {
            double radius = 0.5 + (double)event.getEntity().m_20205_();
            double speed = 0.1;
            double offX = radius * Math.sin(speed * (double)event.getEntity().f_19797_);
            double offY = -Math.sin(event.getEntity().f_19797_) * 0.2;
            double offZ = radius * Math.cos(speed * (double)event.getEntity().f_19797_);
            ParticleUtil.sendParticle(event.getEntity().f_19853_, (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), event.getEntity().m_20185_() + offX, event.getEntity().m_20186_() + offY + 1.0, event.getEntity().m_20189_() + offZ);
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        CSCommonMiscEvents.checkAndCancelAttack(event, event.getEntity().m_21205_());
        CSCommonMiscEvents.checkAndCancelAttack(event, event.getEntity().m_21206_());
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        CSWeapon cs;
        LivingEntity entity = event.getEntity();
        ItemStack itemR = entity.m_21205_();
        ItemStack itemL = entity.m_21206_();
        Item item = itemR.m_41720_();
        if (item instanceof CSWeapon) {
            cs = (CSWeapon)item;
            if (!(itemL.m_41720_() instanceof CSWeapon)) {
                cs.onPlayerHurt(event, itemR, itemL);
            }
        }
        if ((item = itemL.m_41720_()) instanceof CSWeapon) {
            cs = (CSWeapon)item;
            if (!(itemR.m_41720_() instanceof CSWeapon)) {
                cs.onPlayerHurt(event, itemR, itemL);
            }
        }
        if ((item = itemR.m_41720_()) instanceof CSWeapon) {
            cs = (CSWeapon)item;
            if (itemL.m_41720_() instanceof CSWeapon) {
                cs.onPlayerHurt(event, itemR, itemL);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingMixinSupport lms;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CSWeaponUtil.disableRunningWeapon((Entity)player);
        }
        if ((livingEntity = event.getEntity()) instanceof LivingMixinSupport && (lms = (LivingMixinSupport)livingEntity).getPhantomTagger() != null) {
            SkillCastPoltergeistWard poltergeistProjectile = (SkillCastPoltergeistWard)((EntityType)CSEntityTypes.POLTERGEIST_WARD.get()).m_20615_(event.getEntity().m_9236_());
            poltergeistProjectile.setOwnerUuid(lms.getPhantomTagger().m_20148_());
            poltergeistProjectile.m_6027_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
            event.getEntity().m_9236_().m_7967_((Entity)poltergeistProjectile);
        }
    }

    @SubscribeEvent
    public static void onPlayerCopy(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            CSWeaponUtil.disableRunningWeapon((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onLivingFallEvent(LivingFallEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Item itemR = entity.m_21205_().m_41720_();
        Item itemL = entity.m_21206_().m_41720_();
        if (entity instanceof Player && (player = (Player)entity).m_9236_().m_5776_()) {
            AnimationManager.playAnimation(AnimationManager.AnimationsList.CLEAR, true);
        }
        if (itemR instanceof BreezebreakerItem || itemL instanceof BreezebreakerItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        Item itemR = entity.m_21205_().m_41720_();
        Item itemL = entity.m_21206_().m_41720_();
        if ((itemR instanceof BreezebreakerItem || itemL instanceof BreezebreakerItem) && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().m_5776_()) {
                AnimationManager.playAnimation(AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_JUMP, true);
            }
            player.m_216990_((SoundEvent)CSSoundEvents.CS_HOP.get());
            if (itemR instanceof CSWeapon) {
                CSWeapon wp = (CSWeapon)itemR;
                wp.sendExpandingParticles(entity.f_19853_, (ParticleType<?>)ParticleTypes.f_123762_, player.m_20183_(), 75, 0.35f);
            } else {
                CSWeapon wp = (CSWeapon)itemL;
                wp.sendExpandingParticles(entity.f_19853_, (ParticleType<?>)ParticleTypes.f_123762_, player.m_20183_(), 75, 0.35f);
            }
            player.m_20256_(entity.m_20184_().m_82542_(2.75, 2.25, 2.75));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Inventory inv = event.getEntity().m_150109_();
        ObjectArrayList invCompartments = Streams.concat((Stream[])new Stream[]{inv.f_35974_.stream(), inv.f_35975_.stream(), inv.f_35976_.stream()}).collect(Collectors.toCollection(ObjectArrayList::new));
        for (ItemStack stack : invCompartments) {
            if (stack.m_41619_() || stack.m_41737_("csController") == null) continue;
            stack.m_41783_().m_128473_("csController");
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isClient() && event.player.f_19853_.m_5776_() && (player = event.player) instanceof PlayerMixinSupport) {
            PlayerMixinSupport pms = (PlayerMixinSupport)player;
            pms.setCameraAngleOrdinal(Minecraft.m_91087_().f_91066_.m_92176_().ordinal());
        }
    }

    private static void checkAndCancelAttack(LivingAttackEvent event, ItemStack itemStack) {
        CompoundTag tagElement = itemStack.m_41737_("csController");
        if (tagElement != null && tagElement.m_128471_("cs.hasAnimationBegun") && tagElement.m_128471_("cs.atkOngoing")) {
            event.setCanceled(true);
        }
    }
}

