/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.base;

import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public abstract class EffectControllerEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> ANGLE_X = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_Y = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_Z = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_X = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_Y = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_Z = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final SoundEvent[] BASE_WEAPON_EFFECTS = new SoundEvent[]{(SoundEvent)CSSoundEvents.CS_SWORD_SWING.get(), (SoundEvent)CSSoundEvents.CS_SWORD_SWING_FIRE.get(), (SoundEvent)CSSoundEvents.CS_AIR_SWING.get(), (SoundEvent)CSSoundEvents.CS_SWORD_CLASH.get(), (SoundEvent)CSSoundEvents.CS_FIRE_SHOOT.get(), (SoundEvent)CSSoundEvents.CS_IMPACT_HIT.get()};

    public EffectControllerEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void playRandomBladeSound(Entity entity, int length) {
        SoundEvent randomSound = BASE_WEAPON_EFFECTS[entity.f_19853_.m_213780_().m_188503_(length)];
        entity.m_5496_(randomSound, 0.35f, 0.5f + new Random().nextFloat());
    }

    public void m_8119_() {
        Player ownerPlayer;
        super.m_8119_();
        UUID ownerUuid = this.getOwnerUuid();
        Player player = ownerPlayer = ownerUuid == null ? null : this.m_9236_().m_46003_(ownerUuid);
        if (ownerPlayer == null || ownerPlayer.m_21224_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public abstract Item getCorrespondingItem();

    public CSWeapon fromInterfaceWeapon() {
        Item item = this.getCorrespondingItem();
        if (item instanceof CSWeapon) {
            CSWeapon interfaceApplied = (CSWeapon)item;
            return interfaceApplied;
        }
        throw new IllegalStateException("Item [" + this.getCorrespondingItem() + "] is an invalid Celestisynth weapon for [" + this.m_5446_() + "].");
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ANGLE_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_Z, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag compoundNBT) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_7380_(CompoundTag compoundNBT) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void setOwnerUuid(@Nullable UUID ownerUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(ownerUuid));
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setAngleX(float angleX) {
        this.f_19804_.m_135381_(ANGLE_X, (Object)Float.valueOf(angleX));
    }

    public float getAngleX() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_X)).floatValue();
    }

    public void setAngleY(float angleY) {
        this.f_19804_.m_135381_(ANGLE_Y, (Object)Float.valueOf(angleY));
    }

    public float getAngleY() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_Y)).floatValue();
    }

    public void setAngleZ(float angleZ) {
        this.f_19804_.m_135381_(ANGLE_Z, (Object)Float.valueOf(angleZ));
    }

    public float getAngleZ() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_Z)).floatValue();
    }

    public void setAddAngleX(float angleX) {
        this.f_19804_.m_135381_(ANGLE_ADD_X, (Object)Float.valueOf(angleX));
    }

    public float getAddAngleX() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_X)).floatValue();
    }

    public void setAddAngleY(float angleY) {
        this.f_19804_.m_135381_(ANGLE_ADD_Y, (Object)Float.valueOf(angleY));
    }

    public float getAddAngleY() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_Y)).floatValue();
    }

    public void setAddAngleZ(float angleZ) {
        this.f_19804_.m_135381_(ANGLE_ADD_Z, (Object)Float.valueOf(angleZ));
    }

    public float getAddAngleZ() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_Z)).floatValue();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

