/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.client.events;

import com.aqutheseal.celestisynth.api.item.CSArmorItem;
import com.aqutheseal.celestisynth.api.item.CSArmorProperties;
import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import com.aqutheseal.celestisynth.common.item.weapons.AquafloraItem;
import com.aqutheseal.celestisynth.common.registry.CSRarityTypes;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CSClientMiscEvents {
    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Opening event) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ItemStack itemR = Minecraft.m_91087_().f_91074_.m_21205_();
            ItemStack itemL = Minecraft.m_91087_().f_91074_.m_21206_();
            if (itemR.m_41720_() instanceof CSWeapon && itemR.m_41737_("csController") != null && itemR.m_41737_("csController").m_128471_("cs.hasAnimationBegun")) {
                event.setCanceled(true);
            }
            if (itemL.m_41720_() instanceof CSWeapon && itemL.m_41737_("csController") != null && itemL.m_41737_("csController").m_128471_("cs.hasAnimationBegun")) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onTooltipColor(RenderTooltipEvent.Color event) {
        int argb = -16777216;
        if (event.getItemStack().m_41791_() == CSRarityTypes.CELESTIAL) {
            event.setBackgroundStart(argb + 925505);
            event.setBackgroundEnd(argb + 920361);
            event.setBorderStart(argb + 15650882);
            event.setBorderEnd(argb + 12538154);
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        PlayerMixinSupport supportedPlayer = (PlayerMixinSupport)player;
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            CSClientMiscEvents.checkAndSetAngle(event, player.m_21206_());
            CSClientMiscEvents.checkAndSetAngle(event, player.m_21205_());
        }
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        float intensity = supportedPlayer.getScreenShakeIntensity();
        float duration = supportedPlayer.getScreenShakeDuration();
        if (duration > 0.0f && !Minecraft.m_91087_().m_91104_() && player.f_19853_.m_5776_()) {
            event.setPitch((float)((double)event.getPitch() + (double)intensity * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)intensity * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)intensity * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent
    public static void onCameraZoom(ViewportEvent.ComputeFov event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            CSClientMiscEvents.checkAndSetFOV(event, mc.f_91074_.m_21206_());
            CSClientMiscEvents.checkAndSetFOV(event, mc.f_91074_.m_21205_());
        }
    }

    @SubscribeEvent
    public static void onToolTipComponent(RenderTooltipEvent.GatherComponents event) {
        ObjectArrayList elementsToAdd;
        Object elements;
        Item item;
        ItemStack stack = event.getItemStack();
        String name = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof CSArmorItem) {
            CSArmorItem armor = (CSArmorItem)item;
            elements = event.getTooltipElements();
            elementsToAdd = new ObjectArrayList();
            CSArmorProperties properties = armor.getArmorProperties();
            if (properties.isStunImmune()) {
                elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.armor_stun_immune").m_130940_(ChatFormatting.LIGHT_PURPLE)));
            }
            if (properties.getDamageReflectionPercent() > 0.0) {
                elementsToAdd.add(Either.left((Object)Component.m_237110_((String)"item.celestisynth.armor_damage_reflection_percent", (Object[])new Object[]{properties.getDamageReflectionPercent()}).m_130940_(ChatFormatting.LIGHT_PURPLE)));
            }
            if (properties.getDamageReflectionAddition() > 0.0) {
                elementsToAdd.add(Either.left((Object)Component.m_237110_((String)"item.celestisynth.armor_damage_reflection_addition", (Object[])new Object[]{properties.getDamageReflectionAddition()}).m_130940_(ChatFormatting.LIGHT_PURPLE)));
            }
            if (properties.getMobEffectDurationMultiplier() > 0.0) {
                elementsToAdd.add(Either.left((Object)Component.m_237110_((String)"item.celestisynth.armor_mob_effect_duration_multiplier", (Object[])new Object[]{properties.getMobEffectDurationMultiplier()}).m_130940_(ChatFormatting.LIGHT_PURPLE)));
            }
            if (properties.getSkillDamageMultiplier() > 0.0) {
                elementsToAdd.add(Either.left((Object)Component.m_237110_((String)"item.celestisynth.armor_skill_damage_multiplier", (Object[])new Object[]{properties.getSkillDamageMultiplier()}).m_130940_(ChatFormatting.LIGHT_PURPLE)));
            }
            ListIterator iterator = elementsToAdd.listIterator(elementsToAdd.size());
            while (iterator.hasPrevious()) {
                elements.add(1, (Either)iterator.previous());
            }
        }
        if (!stack.m_41619_() && (elements = stack.m_41720_()) instanceof CSWeapon) {
            CSWeapon cs = (CSWeapon)elements;
            elements = event.getTooltipElements();
            elementsToAdd = new ObjectArrayList();
            elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.celestial_tier").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD)));
            elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.shift_notice").m_130940_(ChatFormatting.GREEN)));
            CSClientMiscEvents.addBorders((List<Either<FormattedText, TooltipComponent>>)elementsToAdd);
            if (cs.hasPassive()) {
                elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.passive_notice").m_130940_(ChatFormatting.GOLD)));
                if (Screen.m_96638_() || Screen.m_96637_()) {
                    elementsToAdd.add(Either.left((Object)Component.m_237113_((String)" ")));
                }
                for (int i = 1; i < cs.getPassiveAmount() + 1; ++i) {
                    elementsToAdd.add(Either.left((Object)Component.m_237115_((String)("item.celestisynth." + name + ".passive_" + i)).m_130940_(ChatFormatting.LIGHT_PURPLE)));
                    if (!Screen.m_96638_() && !Screen.m_96637_()) continue;
                    elementsToAdd.add(Either.left((Object)Component.m_237115_((String)("item.celestisynth." + name + ".passive_desc_" + i)).m_130940_(ChatFormatting.GRAY)));
                    elementsToAdd.add(Either.left((Object)Component.m_237113_((String)" ")));
                }
                CSClientMiscEvents.addBorders((List<Either<FormattedText, TooltipComponent>>)elementsToAdd);
            }
            elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.skill_notice").m_130940_(ChatFormatting.GOLD)));
            if (Screen.m_96638_() || Screen.m_96637_()) {
                elementsToAdd.add(Either.left((Object)Component.m_237113_((String)" ")));
            }
            for (int i = 1; i < cs.getSkillsAmount() + 1; ++i) {
                elementsToAdd.add(Either.left((Object)Component.m_237115_((String)("item.celestisynth." + name + ".skill_" + i)).m_130940_(ChatFormatting.LIGHT_PURPLE)));
                if (!Screen.m_96638_() && !Screen.m_96637_()) continue;
                elementsToAdd.add(Either.left((Object)Component.m_237115_((String)("item.celestisynth." + name + ".condition_" + i)).m_130940_(ChatFormatting.RED)));
                elementsToAdd.add(Either.left((Object)Component.m_237115_((String)("item.celestisynth." + name + ".desc_" + i)).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC)));
                elementsToAdd.add(Either.left((Object)Component.m_237113_((String)" ")));
            }
            CSClientMiscEvents.addBorders((List<Either<FormattedText, TooltipComponent>>)elementsToAdd);
            ListIterator iterator = elementsToAdd.listIterator(elementsToAdd.size());
            while (iterator.hasPrevious()) {
                elements.add(1, (Either)iterator.previous());
            }
        }
    }

    private static void checkAndSetAngle(ViewportEvent.ComputeCameraAngles event, ItemStack itemStack) {
        CompoundTag tagElement;
        if (itemStack.m_41720_() instanceof AquafloraItem && (tagElement = itemStack.m_41737_("csController")) != null && tagElement.m_128471_("cs.hasAnimationBegun") && tagElement.m_128471_("cs.atkOngoing")) {
            event.setPitch(90.0f);
        }
    }

    private static void checkAndSetFOV(ViewportEvent.ComputeFov event, ItemStack itemStack) {
        Item item;
        CompoundTag tagElement = itemStack.m_41737_("csController");
        if (tagElement != null && (item = itemStack.m_41720_()) instanceof AquafloraItem) {
            AquafloraItem aq = (AquafloraItem)item;
            if (tagElement.m_128471_("cs.hasAnimationBegun") && tagElement.m_128471_("cs.atkOngoing")) {
                event.setFOV(140.0);
            }
        }
    }

    private static void addBorders(List<Either<FormattedText, TooltipComponent>> list) {
        boolean shouldExpand = Screen.m_96638_() || Screen.m_96637_();
        MutableComponent border = Component.m_237113_((String)(shouldExpand ? "[ -------------------- o -------------------- ]" : "[ ------------ o ------------ ]"));
        MutableComponent edge = Component.m_237113_((String)" ");
        list.add((Either<FormattedText, TooltipComponent>)Either.left((Object)edge));
        list.add((Either<FormattedText, TooltipComponent>)Either.left((Object)border.m_130940_(shouldExpand ? ChatFormatting.GREEN : ChatFormatting.GRAY)));
        list.add((Either<FormattedText, TooltipComponent>)Either.left((Object)edge));
    }
}

