/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.api.item;

import com.aqutheseal.celestisynth.api.animation.player.AnimationManager;
import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.common.network.util.ChangeCameraTypePacket;
import com.aqutheseal.celestisynth.common.network.util.ShakeScreenServerPacket;
import com.aqutheseal.celestisynth.manager.CSNetworkManager;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public interface CSWeaponUtil {
    public static final String CS_CONTROLLER_TAG_ELEMENT = "csController";
    public static final String CS_EXTRAS_ELEMENT = "csExtras";
    public static final String ANIMATION_TIMER_KEY = "cs.animationTimer";
    public static final String ANIMATION_BEGUN_KEY = "cs.hasAnimationBegun";

    default public void hurtNoKB(Player holder, LivingEntity target, float damage, boolean isBlockable) {
        if (damage == 0.0f) {
            return;
        }
        double preAttribute = target.m_21051_(Attributes.f_22278_).m_22135_();
        target.m_21051_(Attributes.f_22278_).m_22100_(100.0);
        target.f_19802_ = 0;
        if (!isBlockable || !(target.m_21211_().m_41720_() instanceof ShieldItem)) {
            target.m_6469_(DamageSource.m_19344_((Player)holder), damage);
        } else {
            this.useAndDamageItem(target.m_21211_(), target.f_19853_, target, (int)(damage / 3.0f));
        }
        target.m_19970_((LivingEntity)holder, (Entity)target);
        target.m_21051_(Attributes.f_22278_).m_22100_(preAttribute);
    }

    default public void hurtNoKB(Player holder, LivingEntity target, float damage) {
        this.hurtNoKB(holder, target, damage, false);
    }

    default public void setDeltaPlayer(Player player, double x, double y, double z) {
        player.f_19864_ = true;
        player.m_20334_(x, y, z);
    }

    default public void setDeltaPlayer(Player player, Vec3 vec) {
        player.f_19864_ = true;
        player.m_20256_(vec);
    }

    default public float getSharpnessValue(ItemStack stack, float multiplier) {
        return (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)stack) * multiplier;
    }

    default public void useAndDamageItem(ItemStack pStack, Level pLevel, LivingEntity targetOwnerEntity, int damageAmount) {
        if (!pLevel.f_46443_) {
            pStack.m_41622_(damageAmount, targetOwnerEntity, ownerEntity -> {
                if (targetOwnerEntity.m_21205_() == pStack) {
                    ownerEntity.m_21190_(InteractionHand.MAIN_HAND);
                } else if (targetOwnerEntity.m_21206_() == pStack) {
                    ownerEntity.m_21190_(InteractionHand.OFF_HAND);
                }
            });
        }
        if (targetOwnerEntity instanceof Player) {
            Player ownerPlayer = (Player)targetOwnerEntity;
            ownerPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)pStack.m_41720_()));
        }
    }

    default public void sendExpandingParticles(Level level, ParticleType<?> particleType, double x, double y, double z, int amount, float expansionMultiplier) {
        for (int i = 0; i < amount; ++i) {
            RandomSource random = level.m_213780_();
            float offX = (-0.5f + random.m_188501_()) * expansionMultiplier;
            float offY = (-0.5f + random.m_188501_()) * expansionMultiplier;
            float offZ = (-0.5f + random.m_188501_()) * expansionMultiplier;
            ParticleUtil.sendParticles(level, particleType, x, y, z, 0, (double)offX, (double)offY, (double)offZ);
        }
    }

    default public void sendExpandingParticles(Level level, ParticleType<?> particleType, BlockPos origin, int amount, float expansionMultiplier) {
        this.sendExpandingParticles(level, particleType, origin.m_123341_(), origin.m_123342_(), origin.m_123343_(), amount, expansionMultiplier);
    }

    default public AABB createAABB(BlockPos pos, double range) {
        return this.createAABB(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), range);
    }

    default public AABB createAABB(double x, double y, double z, double range) {
        return new AABB(x + range, y + range, z + range, x - range, y - range, z - range);
    }

    default public List<Entity> iterateEntities(Level level, AABB aabb) {
        return level.m_45976_(Entity.class, aabb);
    }

    default public boolean checkDualWield(Player player, Class<? extends CSWeapon> weapon) {
        return weapon.isInstance(player.m_21205_().m_41720_()) && weapon.isInstance(player.m_21206_().m_41720_());
    }

    default public Entity getLookedAtEntity(Player player, double range) {
        AABB aabb;
        double distance = range * range;
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 targetVec = eyePos.m_82520_(viewVec.f_82479_ * range, viewVec.f_82480_ * range, viewVec.f_82481_ * range);
        EntityHitResult hitResult = CSWeaponUtil.expandedHitResult((Entity)player, eyePos, targetVec, aabb = player.m_20191_().m_82369_(viewVec.m_82490_(range)).m_82377_(4.0, 4.0, 4.0), entity -> !entity.m_5833_(), distance);
        return hitResult != null ? hitResult.m_82443_() : null;
    }

    default public void shakeScreensForNearbyPlayers(Player holder, Level level, double range, int maxDuration, int startFadingOut, float maxIntensity) {
        if (level.m_5776_()) {
            List entities = level.m_45976_(Player.class, holder.m_20191_().m_82377_(range, range, range));
            for (Player entity : entities) {
                this.shakeScreens(entity, maxDuration, startFadingOut, Math.max(0.0f, maxIntensity - (float)(entity.m_20280_((Entity)holder) * 1.0E-4)));
            }
        }
    }

    default public void shakeScreens(Player target, int duration, int startFadingOut, float intensity) {
        if (target != null) {
            CSNetworkManager.sendToServer(new ShakeScreenServerPacket(target.m_20148_(), duration, startFadingOut, intensity));
        }
    }

    default public double calculateXLook(Player player) {
        return player.m_20154_().m_7096_();
    }

    default public double calculateYLook(Player player, double yMult) {
        double lookY = player.m_20154_().m_7098_();
        if (lookY > 0.0) {
            return lookY * yMult;
        }
        return lookY * 0.5;
    }

    default public double calculateYLook(Player player) {
        return player.m_20154_().m_7098_();
    }

    default public double calculateZLook(Player player) {
        return player.m_20154_().m_7094_();
    }

    default public void setCameraAngle(Player player, int ordinal) {
        if (!player.f_19853_.m_5776_()) {
            CSNetworkManager.sendToAll(new ChangeCameraTypePacket(player.m_19879_(), ordinal));
        }
    }

    public static void disableRunningWeapon(Entity owner) {
        if (owner instanceof Player) {
            Player playerOwner = (Player)owner;
            AnimationManager.playAnimation(owner.f_19853_, AnimationManager.AnimationsList.CLEAR);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                Item item = playerOwner.m_6844_(slot).m_41720_();
                if (!(item instanceof CSWeapon)) continue;
                CSWeapon cs = (CSWeapon)item;
                CompoundTag data = playerOwner.m_6844_(slot).m_41737_(CS_CONTROLLER_TAG_ELEMENT);
                CompoundTag dataAlt = playerOwner.m_6844_(slot).m_41737_(CS_EXTRAS_ELEMENT);
                if (data != null) {
                    data.m_128431_().clear();
                }
                if (dataAlt != null) {
                    dataAlt.m_128431_().clear();
                }
                cs.resetExtraValues(playerOwner.m_6844_(slot), playerOwner);
            }
            if (playerOwner.m_6117_()) {
                playerOwner.m_21253_();
            }
        }
    }

    @Nullable
    public static EntityHitResult expandedHitResult(Entity pShooter, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, double pDistance) {
        Level level = pShooter.f_19853_;
        double range = pDistance;
        Entity confirmedTarget = null;
        Vec3 clipVec = null;
        for (Entity potentialTarget : level.m_6249_(pShooter, pBoundingBox, pFilter)) {
            Vec3 vec31;
            double distToTargetPos;
            AABB boundsHitbox = potentialTarget.m_20191_().m_82400_((double)potentialTarget.m_6143_() + 1.5);
            Optional potentialClippedVec = boundsHitbox.m_82371_(pStartVec, pEndVec);
            if (boundsHitbox.m_82390_(pStartVec)) {
                if (!(range >= 0.0)) continue;
                confirmedTarget = potentialTarget;
                clipVec = potentialClippedVec.orElse(pStartVec);
                range = 0.0;
                continue;
            }
            if (!potentialClippedVec.isPresent() || !((distToTargetPos = pStartVec.m_82557_(vec31 = (Vec3)potentialClippedVec.get())) < range) && range != 0.0) continue;
            if (potentialTarget.m_20201_() == pShooter.m_20201_() && !potentialTarget.canRiderInteract()) {
                if (range != 0.0) continue;
                confirmedTarget = potentialTarget;
                clipVec = vec31;
                continue;
            }
            confirmedTarget = potentialTarget;
            clipVec = vec31;
            range = distToTargetPos;
        }
        return confirmedTarget == null ? null : new EntityHitResult(confirmedTarget, clipVec);
    }
}

