/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.goal.AlwaysWatchTargetGoal;
import twilightforest.entity.ai.goal.LichAbsorbMinionsGoal;
import twilightforest.entity.ai.goal.LichMinionsGoal;
import twilightforest.entity.ai.goal.LichPopMobsGoal;
import twilightforest.entity.ai.goal.LichShadowsGoal;
import twilightforest.entity.monster.LichMinion;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.EntityUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class Lich
extends Monster
implements EnforcedHomePoint {
    private static final EntityDataAccessor<Boolean> IS_CLONE = SynchedEntityData.m_135353_(Lich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHIELD_STRENGTH = SynchedEntityData.m_135353_(Lich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MINIONS_LEFT = SynchedEntityData.m_135353_(Lich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(Lich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_SHADOW_CLONES = 2;
    public static final int INITIAL_SHIELD_STRENGTH = 6;
    public static final int MAX_ACTIVE_MINIONS = 3;
    public static final int INITIAL_MINIONS_TO_SUMMON = 9;
    public static final int MAX_HEALTH = 100;
    @Nullable
    private Lich masterLich;
    private int attackCooldown;
    private int popCooldown;
    private int heldScepterTime;
    private int spawnTime;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_6);
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();

    public Lich(EntityType<? extends Lich> type, Level world) {
        super(type, world);
        this.setShadowClone(false);
        this.masterLich = null;
        this.f_21364_ = 217;
    }

    public Lich(Level level, Lich otherLich) {
        this((EntityType<? extends Lich>)((EntityType)TFEntities.LICH.get()), level);
        this.setShadowClone(true);
        this.masterLich = otherLich;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.45);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CLONE, (Object)false);
        this.f_19804_.m_135372_(SHIELD_STRENGTH, (Object)6);
        this.f_19804_.m_135372_(MINIONS_LEFT, (Object)9);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AlwaysWatchTargetGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LichPopMobsGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LichAbsorbMinionsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LichShadowsGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LichMinionsGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.75, true){

            public boolean m_8036_() {
                return Lich.this.getPhase() == 3 && super.m_8036_();
            }

            public void m_8056_() {
                super.m_8056_();
                this.f_25540_.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42430_));
            }
        });
        this.addRestrictionGoals((PathfinderMob)this, this.f_21345_);
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                Mob mob = this.f_26135_;
                if (mob instanceof Lich) {
                    Lich main = (Lich)mob;
                    mob = this.f_26135_.m_21188_();
                    if (mob instanceof Lich) {
                        Lich lich = (Lich)mob;
                        if (lich.masterLich == main.masterLich) {
                            return false;
                        }
                    }
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        compound.m_128379_("ShadowClone", this.isShadowClone());
        compound.m_128405_("ShieldStrength", this.getShieldStrength());
        compound.m_128405_("MinionsToSummon", this.getMinionsToSummon());
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadHomePointFromNbt(compound, 20);
        this.setShadowClone(compound.m_128471_("ShadowClone"));
        this.setShieldStrength(compound.m_128451_("ShieldStrength"));
        this.setMinionsToSummon(compound.m_128451_("MinionsToSummon"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8107_() {
        float angle = this.f_20883_ * (float)Math.PI / 180.0f;
        double dx = this.m_20185_() + (double)Mth.m_14089_((float)angle) * 0.65;
        double dy = this.m_20186_() + (double)this.m_20206_() * 0.94;
        double dz = this.m_20189_() + (double)Mth.m_14031_((float)angle) * 0.65;
        int factor = (80 - this.getAttackCooldown()) / 10;
        int particles = factor > 0 ? this.m_217043_().m_188503_(factor) : 1;
        for (int j1 = 0; j1 < particles; ++j1) {
            float sparkle = 1.0f - ((float)this.getAttackCooldown() + 1.0f) / 60.0f;
            sparkle *= sparkle;
            float red = 0.37f * sparkle;
            float grn = 0.99f * sparkle;
            float blu = 0.89f * sparkle;
            if (this.getNextAttackType() != 0) {
                red = 0.99f * sparkle;
                grn = 0.47f * sparkle;
                blu = 0.0f * sparkle;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, dx + this.m_217043_().m_188583_() * 0.025, dy + this.m_217043_().m_188583_() * 0.025, dz + this.m_217043_().m_188583_() * 0.025, (double)red, (double)grn, (double)blu);
        }
        if (this.getPhase() == 3) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 1.0 + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_217043_().m_188583_() * 0.02, this.m_217043_().m_188583_() * 0.02, this.m_217043_().m_188583_() * 0.02);
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.getPhase() == 1) {
                this.bossInfo.m_142711_((float)this.getShieldStrength() / 6.0f);
            } else {
                this.bossInfo.m_5648_(BossEvent.BossBarOverlay.PROGRESS);
                this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
                if (this.getPhase() == 2) {
                    this.bossInfo.m_6451_(BossEvent.BossBarColor.PURPLE);
                } else {
                    this.bossInfo.m_6451_(BossEvent.BossBarColor.RED);
                }
            }
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.getAttackCooldown() > 0 && this.spawnTime <= 0) {
            --this.attackCooldown;
        }
        if (this.getPopCooldown() > 0 && this.m_21223_() < this.m_21233_() && this.getScepterTimeLeft() <= 0) {
            --this.popCooldown;
        }
        if (this.getScepterTimeLeft() == 0 && this.getPopCooldown() < 30 && this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)TFItems.LIFEDRAIN_SCEPTER.get())) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)(this.getPhase() == 2 ? (ItemLike)TFItems.ZOMBIE_SCEPTER.get() : Items.f_42430_)));
        }
        if (this.getScepterTimeLeft() > 0) {
            --this.heldScepterTime;
        }
        if (this.m_5448_() != null && this.spawnTime > 0 && this.m_142582_((Entity)this.m_5448_())) {
            --this.spawnTime;
            if (this.spawnTime <= 0) {
                this.extinguishNearbyCandles();
            }
        }
    }

    public boolean m_6469_(DamageSource src, float damage) {
        if (src == DamageSource.f_19310_ && this.m_5448_() != null) {
            this.teleportToSightOfEntity((Entity)this.m_5448_());
        }
        if (this.isShadowClone() && src != DamageSource.f_19317_) {
            this.m_5496_((SoundEvent)TFSounds.LICH_CLONE_HURT.get(), 1.0f, this.m_6100_() * 2.0f);
            return false;
        }
        if (src.m_7639_() instanceof Lich) {
            return false;
        }
        if (src != DamageSource.f_19317_ && this.getShieldStrength() > 0) {
            if (src.m_19387_() && damage > 2.0f) {
                if (this.getShieldStrength() > 0) {
                    this.setShieldStrength(this.getShieldStrength() - 1);
                    this.m_5496_((SoundEvent)TFSounds.SHIELD_BREAK.get(), 1.0f, this.m_6100_() * 2.0f);
                    this.m_146850_(GameEvent.f_223706_);
                }
            } else {
                this.m_5496_((SoundEvent)TFSounds.SHIELD_BREAK.get(), 1.0f, this.m_6100_() * 2.0f);
                this.m_146850_(GameEvent.f_223706_);
                Entity entity = src.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    this.m_6703_(living);
                }
            }
            return false;
        }
        if (super.m_6469_(src, damage)) {
            ServerPlayer player;
            Entity entity;
            if (this.m_217043_().m_188503_(this.getPhase() == 3 ? 6 : 3) == 0) {
                this.teleportToSightOfEntity((Entity)this.m_5448_());
            }
            if ((entity = src.m_7639_()) instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
                this.hurtBy.add(player);
            }
            return true;
        }
        return false;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().m_5776_() && !this.isShadowClone()) {
            TFGenerationSettings.markStructureConquered(this.m_9236_(), this.m_20183_(), TFLandmark.LICH_TOWER);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            TFLootTables.entityDropsIntoContainer((LivingEntity)this, this.m_7771_(true, cause).m_78975_(LootContextParamSets.f_81415_), this.f_19796_.m_188499_() ? ((TFChestBlock)((Object)TFBlocks.TWILIGHT_OAK_CHEST.get())).m_49966_() : ((TFChestBlock)((Object)TFBlocks.CANOPY_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation((Mob)this));
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && !this.isShadowClone()) {
            if (this.m_21536_()) {
                this.m_9236_().m_46597_(this.m_21534_(), ((Block)TFBlocks.LICH_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public void launchProjectileAt(ThrowableProjectile projectile) {
        float bodyFacingAngle = this.f_20883_ * (float)Math.PI / 180.0f;
        double sx = this.m_20185_() + (double)Mth.m_14089_((float)bodyFacingAngle) * 0.65;
        double sy = this.m_20186_() + (double)this.m_20206_() * 0.82;
        double sz = this.m_20189_() + (double)Mth.m_14031_((float)bodyFacingAngle) * 0.65;
        double tx = Objects.requireNonNull(this.m_5448_()).m_20185_() - sx;
        double ty = this.m_5448_().m_20191_().f_82289_ + (double)(this.m_5448_().m_20206_() / 2.0f) - (this.m_20186_() + (double)(this.m_20206_() / 2.0f));
        double tz = this.m_5448_().m_20189_() - sz;
        this.m_5496_((SoundEvent)TFSounds.LICH_SHOOT.get(), this.m_6121_(), (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
        projectile.m_7678_(sx, sy, sz, this.m_146908_(), this.m_146909_());
        projectile.m_6686_(tx, ty, tz, 0.5f, 1.0f);
        this.m_9236_().m_7967_((Entity)projectile);
    }

    public boolean wantsNewClone(Lich clone) {
        return clone.isShadowClone() && this.countMyClones() < 2;
    }

    public int countMyClones() {
        int count = 0;
        for (Lich lich : this.getNearbyLiches()) {
            if (!lich.isShadowClone() || lich.getMasterLich() != this) continue;
            ++count;
        }
        return count;
    }

    public List<? extends Lich> getNearbyLiches() {
        return this.m_9236_().m_45976_(this.getClass(), new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82377_(32.0, 16.0, 32.0));
    }

    public boolean wantsNewMinion() {
        return this.countMyMinions() < 3;
    }

    public int countMyMinions() {
        return (int)this.m_9236_().m_45976_(LichMinion.class, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82377_(32.0, 16.0, 32.0)).stream().filter(m -> m.master == this).count();
    }

    public void teleportToSightOfEntity(@Nullable Entity entity) {
        Vec3 dest = this.findVecInLOSOf(entity);
        double srcX = this.m_20185_();
        double srcY = this.m_20186_();
        double srcZ = this.m_20189_();
        if (dest != null && entity != null) {
            this.teleportToNoChecks(dest.m_7096_(), dest.m_7098_(), dest.m_7094_());
            this.m_21563_().m_24960_(entity, 100.0f, 100.0f);
            this.f_20883_ = this.m_146908_();
            if (!this.m_21574_().m_148306_(entity)) {
                this.teleportToNoChecks(srcX, srcY, srcZ);
            }
        }
    }

    @Nullable
    public Vec3 findVecInLOSOf(@Nullable Entity targetEntity) {
        if (targetEntity == null) {
            return null;
        }
        double origX = this.m_20185_();
        double origY = this.m_20186_();
        double origZ = this.m_20189_();
        int tries = 100;
        for (int i = 0; i < tries; ++i) {
            double tx = targetEntity.m_20185_() + this.m_217043_().m_188583_() * 16.0;
            double ty = targetEntity.m_20186_();
            double tz = targetEntity.m_20189_() + this.m_217043_().m_188583_() * 16.0;
            boolean destClear = this.m_20984_(tx, ty, tz, true);
            boolean canSeeTargetAtDest = this.m_142582_(targetEntity);
            this.m_6021_(origX, origY, origZ);
            if (!destClear || !canSeeTargetAtDest) continue;
            return new Vec3(tx, ty, tz);
        }
        return null;
    }

    private void teleportToNoChecks(double destX, double destY, double destZ) {
        double srcX = this.m_20185_();
        double srcY = this.m_20186_();
        double srcZ = this.m_20189_();
        this.m_6021_(destX, destY, destZ);
        this.makeTeleportTrail(srcX, srcY, srcZ, destX, destY, destZ);
        this.m_9236_().m_6263_(null, srcX, srcY, srcZ, (SoundEvent)TFSounds.LICH_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
        this.m_5496_((SoundEvent)TFSounds.LICH_TELEPORT.get(), 1.0f, 1.0f);
        this.m_146850_(GameEvent.f_238175_);
        this.f_20899_ = false;
    }

    public void makeTeleportTrail(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 128;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
            float f1 = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
            float f2 = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
            double tx = srcX + (destX - srcX) * trailFactor + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            double ty = srcY + (destY - srcY) * trailFactor + this.m_217043_().m_188500_() * (double)this.m_20206_();
            double tz = srcZ + (destZ - srcZ) * trailFactor + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123806_, tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    public void makeMagicTrail(Vec3 source, Vec3 target, float red, float green, float blue) {
        int particles = 60;
        if (!this.m_9236_().m_5776_()) {
            for (ServerPlayer serverplayer : ((ServerLevel)this.m_9236_()).m_6907_()) {
                if (!(serverplayer.m_20238_(source) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < particles; ++i) {
                    double trailFactor = (double)i / ((double)particles - 1.0);
                    double tx = source.m_7096_() + (target.m_7096_() - source.m_7096_()) * trailFactor + this.m_217043_().m_188583_() * 0.005;
                    double ty = source.m_7098_() + 0.2 + (target.m_7098_() - source.m_7098_()) * trailFactor + this.m_217043_().m_188583_() * 0.005;
                    double tz = source.m_7094_() + (target.m_7094_() - source.m_7094_()) * trailFactor + this.m_217043_().m_188583_() * 0.005;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123811_, false, tx, ty, tz, red, green, blue);
                }
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)packet);
            }
        }
    }

    private void extinguishNearbyCandles() {
        for (BlockPos pos : WorldUtil.getAllAround(this.m_20183_(), 10)) {
            if (this.f_19853_.m_8055_(pos).m_60734_() instanceof AbstractCandleBlock && ((Boolean)this.f_19853_.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                this.f_19853_.m_46597_(pos, (BlockState)this.f_19853_.m_8055_(pos).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                this.f_19853_.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 2.0f, 1.0f);
                continue;
            }
            if (!(this.f_19853_.m_8055_(pos).m_60734_() instanceof AbstractLightableBlock) || this.f_19853_.m_8055_(pos).m_61143_(AbstractLightableBlock.LIGHTING) != AbstractLightableBlock.Lighting.NORMAL) continue;
            this.f_19853_.m_46597_(pos, (BlockState)this.f_19853_.m_8055_(pos).m_61124_(AbstractLightableBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.OMINOUS)));
            this.f_19853_.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 2.0f, 0.75f);
        }
    }

    public void setExtinguishTimer() {
        this.spawnTime = 20;
    }

    public int getPhase() {
        if (this.isShadowClone() || this.getShieldStrength() > 0) {
            return 1;
        }
        if (this.getMinionsToSummon() > 0 || this.countMyMinions() > 0) {
            return 2;
        }
        return 3;
    }

    @Nullable
    public Lich getMasterLich() {
        return this.masterLich;
    }

    public void setMaster(Lich lich) {
        this.masterLich = lich;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public int getPopCooldown() {
        return this.popCooldown;
    }

    public void setPopCooldown(int cooldown) {
        this.popCooldown = cooldown;
    }

    public int getScepterTimeLeft() {
        return this.heldScepterTime;
    }

    public void setScepterTime() {
        this.heldScepterTime = 20 + this.m_217043_().m_188503_(20);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)TFItems.LIFEDRAIN_SCEPTER.get()));
    }

    public void resetScepterTime() {
        this.heldScepterTime = 0;
    }

    public boolean isShadowClone() {
        return (Boolean)this.f_19804_.m_135370_(IS_CLONE);
    }

    public void setShadowClone(boolean shadowClone) {
        this.bossInfo.m_8321_(!shadowClone);
        this.f_19804_.m_135381_(IS_CLONE, (Object)shadowClone);
    }

    public int getShieldStrength() {
        return (Integer)this.f_19804_.m_135370_(SHIELD_STRENGTH);
    }

    public void setShieldStrength(int shieldStrength) {
        this.f_19804_.m_135381_(SHIELD_STRENGTH, (Object)shieldStrength);
    }

    public int getMinionsToSummon() {
        return (Integer)this.f_19804_.m_135370_(MINIONS_LEFT);
    }

    public void setMinionsToSummon(int minionsToSummon) {
        this.f_19804_.m_135381_(MINIONS_LEFT, (Object)minionsToSummon);
    }

    public int getNextAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setNextAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.LICH_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.LICH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.LICH_DEATH.get();
    }

    public ResourceLocation m_7582_() {
        return !this.isShadowClone() ? super.m_7582_() : null;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    protected boolean m_6125_() {
        return false;
    }

    public boolean m_21526_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }

    @Override
    public BlockPos getRestrictionCenter() {
        return this.m_21534_();
    }

    @Override
    public void setRestriction(BlockPos pos, int dist) {
        this.m_21446_(pos, dist);
    }
}

