/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class CharmEffect
extends Entity
implements ItemSupplier {
    private static final EntityDataAccessor<Integer> DATA_OWNER = SynchedEntityData.m_135353_(CharmEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEMID = SynchedEntityData.m_135353_(CharmEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final double DISTANCE = 0.75;
    private double interpTargetX;
    private double interpTargetY;
    private double interpTargetZ;
    private double interpTargetYaw;
    private double interpTargetPitch;
    private int newPosRotationIncrements;
    public float offset;

    public CharmEffect(EntityType<? extends CharmEffect> type, Level world) {
        super(type, world);
    }

    public CharmEffect(EntityType<? extends CharmEffect> type, Level world, LivingEntity owner, Item item) {
        this(type, world);
        this.setOwner(owner);
        this.setItemID(item);
        this.m_7678_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20192_(), owner.m_20189_(), owner.m_146908_(), owner.m_146909_());
        Vec3 look = new Vec3(0.75, 0.0, 0.0);
        double x = this.m_20185_() + look.m_7096_() * 0.75;
        double z = this.m_20189_() + look.m_7094_() * 0.75;
        this.m_6034_(x, this.m_20186_(), z);
    }

    public void m_8119_() {
        LivingEntity orbiting;
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        super.m_8119_();
        if (this.newPosRotationIncrements > 0) {
            double d0 = this.m_20185_() + (this.interpTargetX - this.m_20185_()) / (double)this.newPosRotationIncrements;
            double d1 = this.m_20186_() + (this.interpTargetY - this.m_20186_()) / (double)this.newPosRotationIncrements;
            double d2 = this.m_20189_() + (this.interpTargetZ - this.m_20189_()) / (double)this.newPosRotationIncrements;
            double d3 = Mth.m_14175_((double)(this.interpTargetYaw - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d3 / (double)this.newPosRotationIncrements));
            this.m_146926_((float)((double)this.m_146909_() + (this.interpTargetPitch - (double)this.m_146909_()) / (double)this.newPosRotationIncrements));
            --this.newPosRotationIncrements;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if ((orbiting = this.getOwner()) != null) {
            float rotation = (float)this.f_19797_ / 10.0f + this.offset;
            Vec3 look = new Vec3(0.75, 0.0, 0.0).m_82524_(rotation);
            this.m_7678_(orbiting.m_20185_() + look.m_7096_(), orbiting.m_20186_() + (double)orbiting.m_20192_(), orbiting.m_20189_() + look.m_7094_(), orbiting.m_146908_(), orbiting.m_146909_());
        }
        if (!this.getItemID().m_41619_()) {
            double dx = this.m_20185_() + 0.25 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
            double dy = this.m_20186_() + 0.25 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
            double dz = this.m_20189_() + 0.25 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getItemID()), dx, dy, dz, 0.0, 0.2, 0.0);
        }
        if (!this.m_9236_().m_5776_() && (this.f_19797_ > 200 || orbiting != null && !orbiting.m_6084_())) {
            this.m_146870_();
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ITEMID, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_OWNER, (Object)-1);
    }

    public void setOwner(LivingEntity owner) {
        this.f_19804_.m_135381_(DATA_OWNER, (Object)owner.m_19879_());
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity e = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_OWNER)).intValue());
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            return living;
        }
        return null;
    }

    public ItemStack getItemID() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEMID);
    }

    public void setItemID(Item item) {
        this.f_19804_.m_135381_(DATA_ITEMID, (Object)new ItemStack((ItemLike)item));
    }

    protected void m_7378_(CompoundTag cmp) {
    }

    protected void m_7380_(CompoundTag cmp) {
    }

    @Nonnull
    public ItemStack m_7846_() {
        return this.getItemID();
    }
}

