/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.breed;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.github.kay9.dragonmounts.util.DMLUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public record DragonBreed(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, Map<Attribute, Double> attributes, List<Ability.Factory<Ability>> abilityTypes, List<Habitat> habitats, ImmutableSet<String> immunities, Optional<SoundEvent> ambientSound, ResourceLocation deathLoot, int growthTime, int hatchTime, float sizeModifier, HolderSet<Item> tamingItems, HolderSet<Item> breedingItems, Either<Integer, String> reproLimit) {
    public static final Codec<DragonBreed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DMLUtil.HEX_CODEC.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)DMLUtil.HEX_CODEC.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)Codec.unboundedMap((Codec)Registry.f_122866_.m_194605_(), (Codec)Codec.DOUBLE).optionalFieldOf("attributes", (Object)ImmutableMap.of()).forGetter(DragonBreed::attributes), (App)Ability.CODEC.listOf().optionalFieldOf("abilities", (Object)ImmutableList.of()).forGetter(DragonBreed::abilityTypes), (App)Habitat.CODEC.listOf().optionalFieldOf("habitats", (Object)ImmutableList.of()).forGetter(DragonBreed::habitats), (App)Codec.STRING.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf).optionalFieldOf("immunities", (Object)ImmutableSet.of()).forGetter(DragonBreed::immunities), (App)Registry.f_122821_.m_194605_().optionalFieldOf("ambient_sound").forGetter(DragonBreed::ambientSound), (App)ResourceLocation.f_135803_.optionalFieldOf("death_loot", (Object)BuiltInLootTables.f_78712_).forGetter(DragonBreed::deathLoot), (App)Codec.INT.optionalFieldOf("growth_time", (Object)72000).forGetter(DragonBreed::growthTime), (App)Codec.INT.optionalFieldOf("hatch_time", (Object)12000).forGetter(DragonBreed::hatchTime), (App)Codec.FLOAT.optionalFieldOf("size_modifier", (Object)Float.valueOf(1.0f)).forGetter(DragonBreed::sizeModifier), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122904_).optionalFieldOf("taming_items", (Object)Registry.f_122827_.m_203561_(ItemTags.f_13156_)).forGetter(DragonBreed::tamingItems), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122904_).optionalFieldOf("breeding_items", (Object)Registry.f_122827_.m_203561_(ItemTags.f_13156_)).forGetter(DragonBreed::breedingItems), (App)Codec.either((Codec)Codec.INT, (Codec)Codec.STRING).optionalFieldOf("reproduction_limit", (Object)Either.left((Object)-1)).forGetter(DragonBreed::reproLimit)).apply((Applicative)instance, DragonBreed::new));
    public static final Codec<DragonBreed> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)Codec.INT.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)Registry.f_122821_.m_194605_().optionalFieldOf("ambient_sound").forGetter(DragonBreed::ambientSound), (App)Codec.INT.fieldOf("growth_time").forGetter(DragonBreed::growthTime), (App)Codec.INT.fieldOf("hatch_time").forGetter(DragonBreed::hatchTime), (App)Codec.FLOAT.optionalFieldOf("size_modifier", (Object)Float.valueOf(1.0f)).forGetter(DragonBreed::sizeModifier)).apply((Applicative)instance, DragonBreed::fromNetwork));

    public static DragonBreed fromNetwork(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, Optional<SoundEvent> ambientSound, int growthTime, int hatchTime, float sizeModifier) {
        return new DragonBreed(primaryColor, secondaryColor, hatchParticles, Map.of(), List.of(), List.of(), (ImmutableSet<String>)ImmutableSet.of(), ambientSound, BuiltInLootTables.f_78712_, growthTime, hatchTime, sizeModifier, (HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[0]), (HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[0]), (Either<Integer, String>)Either.left((Object)0));
    }

    public void initialize(TameableDragon dragon) {
        this.applyAttributes(dragon);
        for (Ability.Factory<Ability> factory : this.abilityTypes()) {
            Ability instance = factory.create();
            dragon.getAbilities().add(instance);
            instance.initialize(dragon);
        }
    }

    public void close(TameableDragon dragon) {
        this.cleanAttributes(dragon);
        for (Ability ability : dragon.getAbilities()) {
            ability.close(dragon);
        }
        dragon.getAbilities().clear();
    }

    public int getReproductionLimit() {
        return (Integer)this.reproLimit().map(Function.identity(), DMLConfig::getReproLimitFor);
    }

    public String getTranslationKey(RegistryAccess reg) {
        ResourceLocation name = this.id(reg);
        return "dragon_breed." + name.m_135827_() + "." + name.m_135815_();
    }

    public ResourceLocation id(RegistryAccess reg) {
        return BreedRegistry.registry(reg).m_7981_((Object)this);
    }

    private void applyAttributes(TameableDragon dragon) {
        float healthFrac = dragon.getHealthFraction();
        this.attributes().forEach((att, value) -> {
            AttributeInstance inst = dragon.m_21051_((Attribute)att);
            if (inst != null) {
                inst.m_22100_(value.doubleValue());
            }
        });
        dragon.m_21153_(dragon.m_21233_() * healthFrac);
    }

    private void cleanAttributes(TameableDragon dragon) {
        float healthFrac = dragon.getHealthFraction();
        AttributeSupplier defaults = DefaultAttributes.m_22297_((EntityType)((EntityType)DMLRegistry.DRAGON.get()));
        this.attributes().forEach((att, value) -> {
            AttributeInstance instance = dragon.m_21051_((Attribute)att);
            if (instance != null) {
                instance.m_22132_();
                instance.m_22100_(defaults.m_22253_(att));
            }
        });
        dragon.m_21153_(dragon.m_21233_() * healthFrac);
    }

    public static final class BuiltIn {
        public static final ResourceKey<DragonBreed> AETHER = BuiltIn.key("aether");
        public static final ResourceKey<DragonBreed> END = BuiltIn.key("end");
        public static final ResourceKey<DragonBreed> FIRE = BuiltIn.key("fire");
        public static final ResourceKey<DragonBreed> FOREST = BuiltIn.key("forest");
        public static final ResourceKey<DragonBreed> GHOST = BuiltIn.key("ghost");
        public static final ResourceKey<DragonBreed> ICE = BuiltIn.key("ice");
        public static final ResourceKey<DragonBreed> NETHER = BuiltIn.key("nether");
        public static final ResourceKey<DragonBreed> WATER = BuiltIn.key("water");

        private static ResourceKey<DragonBreed> key(String id) {
            return ResourceKey.m_135785_(BreedRegistry.REGISTRY_KEY, (ResourceLocation)DragonMountsLegacy.id(id));
        }

        private BuiltIn() {
        }
    }
}

