/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data.loot;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonEggLootMod
extends LootModifier {
    public static final Codec<DragonEggLootMod> CODEC = RecordCodecBuilder.create(i -> DragonEggLootMod.codecStart((RecordCodecBuilder.Instance)i).and((App)ResourceLocation.f_135803_.fieldOf("egg_breed").forGetter(m -> m.id)).and((App)Codec.BOOL.optionalFieldOf("replace_first", (Object)false).forGetter(m -> m.replaceFirst)).apply((Applicative)i, DragonEggLootMod::new));
    public static Target[] BUILT_IN_CHANCES = new Target[]{new Target(DragonBreed.BuiltIn.AETHER, BuiltInLootTables.f_78742_, 0.15), new Target(DragonBreed.BuiltIn.FIRE, BuiltInLootTables.f_78764_, 0.075), new Target(DragonBreed.BuiltIn.FOREST, BuiltInLootTables.f_78686_, 0.3), new Target(DragonBreed.BuiltIn.GHOST, BuiltInLootTables.f_78689_, 0.2), new Target(DragonBreed.BuiltIn.GHOST, BuiltInLootTables.f_78759_, 0.095), new Target(DragonBreed.BuiltIn.ICE, BuiltInLootTables.f_78688_, 0.2), new Target(DragonBreed.BuiltIn.NETHER, BuiltInLootTables.f_78697_, 0.35), new Target(DragonBreed.BuiltIn.WATER, BuiltInLootTables.f_78692_, 0.175)};
    private final ResourceLocation id;
    private final boolean replaceFirst;

    public DragonEggLootMod(LootItemCondition[] conditions, ResourceLocation breed, boolean replaceFirst) {
        super(conditions);
        this.id = breed;
        this.replaceFirst = replaceFirst;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RegistryAccess reg = context.m_78952_().m_5962_();
        DragonBreed breed = (DragonBreed)BreedRegistry.registry(reg).m_7745_(this.id);
        if (breed != null) {
            ItemStack egg = DMLEggBlock.Item.create(breed, reg, 12000);
            if (this.replaceFirst) {
                generatedLoot.set(0, (Object)egg);
            } else {
                generatedLoot.add((Object)egg);
            }
        } else {
            DragonMountsLegacy.LOG.error("Attempted to add a dragon egg to loot with unknown breed id: \"{}\"", (Object)this.id);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public record Target(ResourceKey<DragonBreed> forBreed, ResourceLocation target, double chance) {
    }
}

