/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public class CrossBreedingManager
extends SimpleJsonResourceReloadListener {
    public static final CrossBreedingManager INSTANCE = new CrossBreedingManager();
    private static final String PATH = "dragonmounts/cross_breeding";
    private final Map<Couple, ResourceKey<DragonBreed>> crosses = new HashMap<Couple, ResourceKey<DragonBreed>>();

    private CrossBreedingManager() {
        super(new GsonBuilder().create(), PATH);
    }

    protected void apply(Map<ResourceLocation, JsonElement> entries, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.crosses.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entries.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement json = entry.getValue();
            CrossBreedResult cross = (CrossBreedResult)CrossBreedResult.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, Util.m_137489_((String)("Unable to parse Cross Breeding result for: " + id), arg_0 -> ((Logger)DragonMountsLegacy.LOG).error(arg_0)));
            this.crosses.put(new Couple(cross.parent1(), cross.parent2()), cross.child());
        }
    }

    @Nullable
    public DragonBreed getCrossBreed(DragonBreed parent, DragonBreed mate, RegistryAccess ra) {
        ResourceKey mateKey;
        Registry<DragonBreed> reg = BreedRegistry.registry(ra);
        ResourceKey parentKey = (ResourceKey)reg.m_7854_((Object)parent).orElseThrow();
        ResourceKey<DragonBreed> result = this.crosses.get(new Couple((ResourceKey<DragonBreed>)parentKey, (ResourceKey<DragonBreed>)(mateKey = (ResourceKey)reg.m_7854_((Object)mate).orElseThrow())));
        return result == null ? null : (DragonBreed)reg.m_6246_(result);
    }

    public record CrossBreedResult(ResourceKey<DragonBreed> parent1, ResourceKey<DragonBreed> parent2, ResourceKey<DragonBreed> child) {
        public static final Codec<CrossBreedResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_(BreedRegistry.REGISTRY_KEY).fieldOf("parent1").forGetter(CrossBreedResult::parent1), (App)ResourceKey.m_195966_(BreedRegistry.REGISTRY_KEY).fieldOf("parent2").forGetter(CrossBreedResult::parent2), (App)ResourceKey.m_195966_(BreedRegistry.REGISTRY_KEY).fieldOf("child").forGetter(CrossBreedResult::child)).apply((Applicative)instance, CrossBreedResult::new));
    }

    private record Couple(ResourceKey<DragonBreed> parent1, ResourceKey<DragonBreed> parent2) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Couple couple = (Couple)o;
            return this.parent1 == couple.parent1 && this.parent2 == couple.parent2 || this.parent1 == couple.parent2 && this.parent2 == couple.parent1;
        }

        @Override
        public int hashCode() {
            return this.parent1.hashCode() + this.parent2.hashCode();
        }
    }
}

