/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.client;

import com.github.kay9.dragonmounts.accessors.ModelPartAccess;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.util.CircularBuffer;
import com.github.kay9.dragonmounts.util.LerpedFloat;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class DragonAnimator {
    private static final int JAW_OPENING_TIME_FOR_ATTACK = 5;
    private final TameableDragon dragon;
    private float partialTicks;
    private float moveTime;
    private float moveSpeed;
    private float lookYaw;
    private float lookPitch;
    private double prevRenderYawOffset;
    private double yawAbs;
    private float animBase;
    private float cycleOfs;
    private float anim;
    private float ground;
    private float flutter;
    private float walk;
    private float sit;
    private float jaw;
    private float speed;
    private final LerpedFloat animTimer = new LerpedFloat();
    private final LerpedFloat groundTimer = new LerpedFloat.Clamped(1.0f, 0.0f, 1.0f);
    private final LerpedFloat flutterTimer = LerpedFloat.unit();
    private final LerpedFloat walkTimer = LerpedFloat.unit();
    private final LerpedFloat sitTimer = LerpedFloat.unit();
    private final LerpedFloat jawTimer = LerpedFloat.unit();
    private final LerpedFloat speedTimer = new LerpedFloat.Clamped(1.0f, 0.0f, 1.0f);
    private boolean initTrails = false;
    private final CircularBuffer yTrail = new CircularBuffer(8);
    private final CircularBuffer yawTrail = new CircularBuffer(16);
    private final CircularBuffer pitchTrail = new CircularBuffer(16);
    private boolean onGround;
    private boolean openJaw;
    private boolean wingsDown;
    private final float[] wingArm = new float[3];
    private final float[] wingForearm = new float[3];
    private final float[] wingArmFlutter = new float[3];
    private final float[] wingForearmFlutter = new float[3];
    private final float[] wingArmGlide = new float[3];
    private final float[] wingForearmGlide = new float[3];
    private final float[] wingArmGround = new float[3];
    private final float[] wingForearmGround = new float[3];
    private final float[] xGround = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[][] xGroundStand = new float[][]{{0.8f, -1.5f, 1.3f, 0.0f}, {-0.3f, 1.5f, -0.2f, 0.0f}};
    private final float[][] xGroundSit = new float[][]{{0.3f, -1.8f, 1.8f, 0.0f}, {-0.8f, 1.8f, -0.9f, 0.0f}};
    private final float[][][] xGroundWalk = new float[][][]{new float[][]{{0.4f, -1.4f, 1.3f, 0.0f}, {0.1f, 1.2f, -0.5f, 0.0f}}, new float[][]{{1.2f, -1.6f, 1.3f, 0.0f}, {-0.3f, 2.1f, -0.9f, 0.6f}}, new float[][]{{0.9f, -2.1f, 1.8f, 0.6f}, {-0.7f, 1.4f, -0.2f, 0.0f}}};
    private final float[] xGroundWalk2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] yGroundStand = new float[]{-0.25f, 0.25f};
    private final float[] yGroundSit = new float[]{0.1f, 0.35f};
    private final float[] yGroundWalk = new float[]{-0.1f, 0.1f};
    private final float[][] xAirAll = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}};
    private final float[] yAirAll = new float[]{-0.1f, 0.1f};
    private static final float[][] CR = new float[][]{{-0.5f, 1.5f, -1.5f, 0.5f}, {1.0f, -2.5f, 2.0f, -0.5f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}};

    public DragonAnimator(TameableDragon dragon) {
        this.dragon = dragon;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public void setMovement(float moveTime, float moveSpeed) {
        this.moveTime = moveTime;
        this.moveSpeed = moveSpeed;
    }

    public void setLook(float lookYaw, float lookPitch) {
        this.lookYaw = Mth.m_14036_((float)lookYaw, (float)-120.0f, (float)120.0f);
        this.lookPitch = Mth.m_14036_((float)lookPitch, (float)-90.0f, (float)90.0f);
    }

    public void animate(DragonModel model) {
        boolean newWingsDown;
        this.anim = this.animTimer.get(this.partialTicks);
        this.ground = this.groundTimer.get(this.partialTicks);
        this.flutter = this.flutterTimer.get(this.partialTicks);
        this.walk = this.walkTimer.get(this.partialTicks);
        this.sit = this.sitTimer.get(this.partialTicks);
        this.jaw = this.jawTimer.get(this.partialTicks);
        this.speed = this.speedTimer.get(this.partialTicks);
        this.animBase = this.anim * (float)Math.PI * 2.0f;
        this.cycleOfs = Mth.m_14031_((float)(this.animBase - 1.0f)) + 1.0f;
        boolean bl = newWingsDown = this.cycleOfs > 1.0f;
        if (newWingsDown && !this.wingsDown && this.flutter != 0.0f) {
            this.dragon.onWingsDown(this.speed);
        }
        this.wingsDown = newWingsDown;
        model.back.f_104207_ = !this.dragon.m_6254_();
        this.cycleOfs = (this.cycleOfs * this.cycleOfs + this.cycleOfs * 2.0f) * 0.05f;
        this.cycleOfs *= Mth.m_144920_((float)0.5f, (float)1.0f, (float)this.flutter);
        this.cycleOfs *= Mth.m_144920_((float)1.0f, (float)0.5f, (float)this.ground);
        this.animHeadAndNeck(model);
        this.animTail(model);
        this.animWings(model);
        this.animLegs(model);
    }

    public void tick() {
        this.setOnGround(!this.dragon.m_29443_());
        if (!this.initTrails) {
            this.yTrail.fill((float)this.dragon.m_20186_());
            this.yawTrail.fill(this.dragon.f_20883_);
            this.pitchTrail.fill(this.getModelPitch());
            this.initTrails = true;
        }
        if (this.dragon.m_21223_() <= 0.0f) {
            this.animTimer.sync();
            this.groundTimer.sync();
            this.flutterTimer.sync();
            this.walkTimer.sync();
            this.sitTimer.sync();
            this.jawTimer.sync();
            return;
        }
        float speedMax = 0.05f;
        float xD = (float)this.dragon.m_20185_() - (float)this.dragon.f_19854_;
        float yD = (float)this.dragon.m_20186_() - (float)this.dragon.f_19855_;
        float zD = (float)this.dragon.m_20189_() - (float)this.dragon.f_19856_;
        float speedEnt = xD * xD + zD * zD;
        float speedMulti = Mth.m_14036_((float)(speedEnt / speedMax), (float)0.0f, (float)1.0f);
        float animAdd = 0.035f;
        if (!this.onGround) {
            animAdd += (1.0f - speedMulti) * animAdd;
        }
        this.animTimer.add(animAdd);
        float groundVal = this.groundTimer.get();
        if (this.onGround) {
            groundVal *= 0.95f;
            groundVal += 0.08f;
        } else {
            groundVal -= 0.1f;
        }
        this.groundTimer.set(groundVal);
        boolean flutterFlag = !this.onGround && (this.dragon.f_19862_ || (double)yD > -0.1 || speedEnt < speedMax);
        this.flutterTimer.add(flutterFlag ? 0.1f : -0.1f);
        boolean walkFlag = (double)this.moveSpeed > 0.1 && !this.dragon.m_21825_();
        float walkVal = 0.1f;
        this.walkTimer.add(walkFlag ? walkVal : -walkVal);
        float sitVal = this.sitTimer.get();
        sitVal += this.dragon.m_21825_() ? 0.1f : -0.1f;
        this.sitTimer.set(sitVal *= 0.95f);
        boolean speedFlag = speedEnt > speedMax || this.dragon.isNearGround();
        float speedValue = 0.05f;
        this.speedTimer.add(speedFlag ? speedValue : -speedValue);
        double yawDiff = (double)this.dragon.f_20883_ - this.prevRenderYawOffset;
        this.prevRenderYawOffset = this.dragon.f_20883_;
        if (yawDiff < 180.0 && yawDiff > -180.0) {
            this.yawAbs += yawDiff;
        }
        this.yTrail.update((float)this.dragon.m_20186_());
        this.yawTrail.update((float)(-this.yawAbs));
        this.pitchTrail.update(this.getModelPitch());
    }

    protected void animHeadAndNeck(DragonModel model) {
        model.neck.m_104227_(0.0f, 14.0f, -8.0f);
        model.neck.m_171327_(0.0f, 0.0f, 0.0f);
        float health = this.dragon.getHealthFraction();
        for (int i = 0; i < model.neckProxy.length; ++i) {
            float vertMulti = (float)(i + 1) / (float)model.neckProxy.length;
            float baseRotX = Mth.m_14089_((float)((float)i * 0.45f + this.animBase)) * 0.15f;
            baseRotX *= Mth.m_144920_((float)0.2f, (float)1.0f, (float)this.flutter);
            float ofsRotX = Mth.m_14031_((float)(vertMulti * (float)Math.PI * 0.9f)) * 0.75f;
            model.neck.f_104203_ = baseRotX *= Mth.m_144920_((float)1.0f, (float)0.2f, (float)this.sit);
            model.neck.f_104203_ *= DragonAnimator.terpSmoothStep(1.0f, 0.5f, this.walk);
            model.neck.f_104203_ += (1.0f - this.speed) * vertMulti;
            model.neck.f_104203_ -= Mth.m_144920_((float)0.0f, (float)ofsRotX, (float)(this.ground * health));
            model.neck.f_104204_ = (float)Math.toRadians(this.lookYaw) * vertMulti * this.speed;
            float v = Mth.m_144920_((float)1.6f, (float)1.0f, (float)vertMulti);
            ((ModelPartAccess)model.neck).setRenderScale(v, v, 0.6f);
            model.neckScale.f_104207_ = i % 2 != 0 || i == 0;
            model.neckProxy[i].update();
            float neckSize = 10.0f * ((ModelPartAccess)model.neck).getZScale() - 1.4f;
            model.neck.f_104200_ -= Mth.m_14031_((float)model.neck.f_104204_) * Mth.m_14089_((float)model.neck.f_104203_) * neckSize;
            model.neck.f_104201_ += Mth.m_14031_((float)model.neck.f_104203_) * neckSize;
            model.neck.f_104202_ -= Mth.m_14089_((float)model.neck.f_104204_) * Mth.m_14089_((float)model.neck.f_104203_) * neckSize;
        }
        model.head.f_104203_ = (float)Math.toRadians(this.lookPitch) + (1.0f - this.speed);
        model.head.f_104204_ = model.neck.f_104204_;
        model.head.f_104205_ = model.neck.f_104205_ * 0.2f;
        model.head.f_104200_ = model.neck.f_104200_;
        model.head.f_104201_ = model.neck.f_104201_;
        model.head.f_104202_ = model.neck.f_104202_;
        model.jaw.f_104203_ = this.jaw * 0.75f;
        model.jaw.f_104203_ += (1.0f - Mth.m_14031_((float)this.animBase)) * 0.1f * this.flutter;
    }

    protected void animWings(DragonModel model) {
        float aSpeed = this.sit > 0.0f ? 0.6f : 1.0f;
        float a1 = this.animBase * aSpeed * 0.35f;
        float a2 = this.animBase * aSpeed * 0.5f;
        float a3 = this.animBase * aSpeed * 0.75f;
        if (this.ground < 1.0f) {
            this.wingArmFlutter[0] = 0.125f - Mth.m_14089_((float)this.animBase) * 0.2f;
            this.wingArmFlutter[1] = 0.25f;
            this.wingArmFlutter[2] = (Mth.m_14031_((float)this.animBase) + 0.125f) * 0.8f;
            this.wingForearmFlutter[0] = 0.0f;
            this.wingForearmFlutter[1] = -this.wingArmFlutter[1] * 2.0f;
            this.wingForearmFlutter[2] = -(Mth.m_14031_((float)(this.animBase + 2.0f)) + 0.5f) * 0.75f;
            this.wingArmGlide[0] = -0.25f - Mth.m_14089_((float)(this.animBase * 2.0f)) * Mth.m_14089_((float)(this.animBase * 1.5f)) * 0.04f;
            this.wingArmGlide[1] = 0.25f;
            this.wingArmGlide[2] = 0.35f + Mth.m_14031_((float)this.animBase) * 0.05f;
            this.wingForearmGlide[0] = 0.0f;
            this.wingForearmGlide[1] = -this.wingArmGlide[1] * 2.0f;
            this.wingForearmGlide[2] = -0.25f + (Mth.m_14031_((float)(this.animBase + 2.0f)) + 0.5f) * 0.05f;
        }
        if (this.ground > 0.0f) {
            this.wingArmGround[0] = 0.0f;
            this.wingArmGround[1] = 1.4f - Mth.m_14031_((float)a1) * Mth.m_14031_((float)a2) * 0.02f;
            this.wingArmGround[2] = 0.8f + Mth.m_14031_((float)a2) * Mth.m_14031_((float)a3) * 0.05f;
            this.wingArmGround[1] = this.wingArmGround[1] + Mth.m_14031_((float)(this.moveTime * 0.5f)) * 0.02f * this.walk;
            this.wingArmGround[2] = this.wingArmGround[2] + Mth.m_14089_((float)(this.moveTime * 0.5f)) * 0.05f * this.walk;
            this.wingForearmGround[0] = 0.0f;
            this.wingForearmGround[1] = -this.wingArmGround[1] * 2.0f;
            this.wingForearmGround[2] = 0.0f;
        }
        DragonAnimator.slerpArrays(this.wingArmGlide, this.wingArmFlutter, this.wingArm, this.flutter);
        DragonAnimator.slerpArrays(this.wingForearmGlide, this.wingForearmFlutter, this.wingForearm, this.flutter);
        DragonAnimator.slerpArrays(this.wingArm, this.wingArmGround, this.wingArm, this.ground);
        DragonAnimator.slerpArrays(this.wingForearm, this.wingForearmGround, this.wingForearm, this.ground);
        DragonAnimator.mirrorRotate(model.wingArms[0], model.wingArms[1], this.wingArm[0], this.wingArm[1], this.wingArm[2]);
        DragonAnimator.mirrorRotate(model.wingForearms[0], model.wingForearms[1], this.wingForearm[0], this.wingForearm[1], this.wingForearm[2]);
        float[] yFold = new float[]{2.7f, 2.8f, 2.9f, 3.0f};
        float[] yUnfold = new float[]{0.1f, 0.9f, 1.7f, 2.5f};
        float rotX = 0.0f;
        float rotYOfs = Mth.m_14031_((float)a1) * Mth.m_14031_((float)a2) * 0.03f;
        float rotYMulti = 1.0f;
        for (int i = 0; i < model.wingFingers[0].length; ++i) {
            DragonAnimator.mirrorRotate(model.wingFingers[0][i], model.wingFingers[1][i], rotX += 0.005f, DragonAnimator.terpSmoothStep(yUnfold[i], yFold[i] + rotYOfs * rotYMulti, this.ground), 0.0f);
            rotYMulti -= 0.2f;
        }
    }

    protected void animTail(DragonModel model) {
        model.tail.f_104200_ = 0.0f;
        model.tail.f_104201_ = 16.0f;
        model.tail.f_104202_ = 62.0f;
        model.tail.f_104203_ = 0.0f;
        model.tail.f_104204_ = 0.0f;
        model.tail.f_104205_ = 0.0f;
        float rotXStand = 0.0f;
        float rotYStand = 0.0f;
        float rotXSit = 0.0f;
        float rotYSit = 0.0f;
        float rotXAir = 0.0f;
        float rotYAir = 0.0f;
        for (int i = 0; i < model.tailProxy.length; ++i) {
            float vertMulti = (float)(i + 1) / (float)model.tailProxy.length;
            float amp = 0.1f + (float)i / ((float)model.tailProxy.length * 2.0f);
            rotXStand = ((float)i - (float)model.tailProxy.length * 0.6f) * -amp * 0.4f;
            rotXSit = (rotXStand += (Mth.m_14031_((float)(this.animBase * 0.2f)) * Mth.m_14031_((float)(this.animBase * 0.37f)) * 0.4f * amp - 0.1f) * (1.0f - this.sit)) * 0.8f;
            rotYStand = (rotYStand + Mth.m_14031_((float)((float)i * 0.45f + this.animBase * 0.5f))) * amp * 0.4f;
            rotYSit = Mth.m_14031_((float)(vertMulti * (float)Math.PI)) * (float)Math.PI * 1.2f - 0.5f;
            model.tail.f_104203_ = Mth.m_144920_((float)rotXStand, (float)rotXSit, (float)this.sit);
            model.tail.f_104204_ = Mth.m_144920_((float)rotYStand, (float)rotYSit, (float)this.sit);
            model.tail.f_104203_ = Mth.m_144920_((float)(rotXAir -= Mth.m_14031_((float)((float)i * 0.45f + this.animBase)) * 0.04f * Mth.m_144920_((float)0.3f, (float)1.0f, (float)this.flutter)), (float)model.tail.f_104203_, (float)this.ground);
            model.tail.f_104204_ = Mth.m_144920_((float)rotYAir, (float)model.tail.f_104204_, (float)this.ground);
            float angleLimit = 160.0f * vertMulti;
            float yawOfs = Mth.m_14036_((float)(this.yawTrail.get(this.partialTicks, 0, i + 1) * 2.0f), (float)(-angleLimit), (float)angleLimit);
            float pitchOfs = Mth.m_14036_((float)(this.pitchTrail.get(this.partialTicks, 0, i + 1) * 2.0f), (float)(-angleLimit), (float)angleLimit);
            model.tail.f_104203_ = (float)((double)model.tail.f_104203_ + Math.toRadians(pitchOfs));
            model.tail.f_104203_ -= (1.0f - this.speed) * vertMulti * 2.0f;
            model.tail.f_104204_ = (float)((double)model.tail.f_104204_ + Math.toRadians(180.0f - yawOfs));
            if (model.tailHornRight != null) {
                boolean atIndex;
                model.tailHornLeft.f_104207_ = model.tailHornRight.f_104207_ = (atIndex = i > model.tailProxy.length - 7 && i < model.tailProxy.length - 3);
            }
            float neckScale = Mth.m_144920_((float)1.5f, (float)0.3f, (float)vertMulti);
            ((ModelPartAccess)model.tail).setRenderScale(neckScale, neckScale, neckScale);
            model.tailProxy[i].update();
            float tailSize = 10.0f * ((ModelPartAccess)model.tail).getZScale() - 0.7f;
            model.tail.f_104201_ += Mth.m_14031_((float)model.tail.f_104203_) * tailSize;
            model.tail.f_104202_ -= Mth.m_14089_((float)model.tail.f_104204_) * Mth.m_14089_((float)model.tail.f_104203_) * tailSize;
            model.tail.f_104200_ -= Mth.m_14031_((float)model.tail.f_104204_) * Mth.m_14089_((float)model.tail.f_104203_) * tailSize;
        }
    }

    protected void animLegs(DragonModel model) {
        if (this.ground < 1.0f) {
            float footAirOfs = this.cycleOfs * 0.1f;
            float footAirX = 0.75f + this.cycleOfs * 0.1f;
            this.xAirAll[0][0] = 1.3f + footAirOfs;
            this.xAirAll[0][1] = -(0.7f * this.speed + 0.1f + footAirOfs);
            this.xAirAll[0][2] = footAirX;
            this.xAirAll[0][3] = footAirX * 0.5f;
            this.xAirAll[1][0] = footAirOfs + 0.6f;
            this.xAirAll[1][1] = footAirOfs + 0.8f;
            this.xAirAll[1][2] = footAirX;
            this.xAirAll[1][3] = footAirX * 0.5f;
        }
        for (int i = 0; i < model.legs.length; ++i) {
            ModelPart thigh = model.legs[i][0];
            ModelPart crus = model.legs[i][1];
            ModelPart foot = model.legs[i][2];
            ModelPart toe = model.legs[i][3];
            thigh.f_104202_ = i % 2 == 0 ? 4.0f : 46.0f;
            float[] xAir = this.xAirAll[i % 2];
            DragonAnimator.slerpArrays(this.xGroundStand[i % 2], this.xGroundSit[i % 2], this.xGround, this.sit);
            this.xGround[3] = -(this.xGround[0] + this.xGround[1] + this.xGround[2]);
            if (this.walk > 0.0f) {
                DragonAnimator.splineArrays(this.moveTime * 0.2f, i > 1, this.xGroundWalk2, this.xGroundWalk[0][i % 2], this.xGroundWalk[1][i % 2], this.xGroundWalk[2][i % 2]);
                this.xGroundWalk2[3] = this.xGroundWalk2[3] - (this.xGroundWalk2[0] + this.xGroundWalk2[1] + this.xGroundWalk2[2]);
                DragonAnimator.slerpArrays(this.xGround, this.xGroundWalk2, this.xGround, this.walk);
            }
            float yAir = this.yAirAll[i % 2];
            float yGround = DragonAnimator.terpSmoothStep(this.yGroundStand[i % 2], this.yGroundSit[i % 2], this.sit);
            yGround = DragonAnimator.terpSmoothStep(yGround, this.yGroundWalk[i % 2], this.walk);
            thigh.f_104204_ = DragonAnimator.terpSmoothStep(yAir, yGround, this.ground);
            thigh.f_104203_ = DragonAnimator.terpSmoothStep(xAir[0], this.xGround[0], this.ground);
            crus.f_104203_ = DragonAnimator.terpSmoothStep(xAir[1], this.xGround[1], this.ground);
            foot.f_104203_ = DragonAnimator.terpSmoothStep(xAir[2], this.xGround[2], this.ground);
            toe.f_104203_ = DragonAnimator.terpSmoothStep(xAir[3], this.xGround[3], this.ground);
            if (i <= 1) continue;
            thigh.f_104204_ *= -1.0f;
        }
    }

    public float getModelPitch() {
        return this.getModelPitch(this.partialTicks);
    }

    public float getModelPitch(float pt) {
        float pitchMovingMax = 90.0f;
        float pitchMoving = Mth.m_14036_((float)(this.yTrail.get(pt, 5, 0) * 10.0f), (float)(-pitchMovingMax), (float)pitchMovingMax);
        float pitchHover = 60.0f;
        return DragonAnimator.terpSmoothStep(pitchHover, pitchMoving, this.speed);
    }

    public float getModelOffsetX() {
        return 0.0f;
    }

    public float getModelOffsetY() {
        return 1.5f + -this.sit * 0.6f;
    }

    public float getModelOffsetZ() {
        return -1.5f;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public void setOpenJaw(boolean openJaw) {
        this.openJaw = openJaw;
    }

    private static void mirrorRotate(ModelPart rightLimb, ModelPart leftLimb, float xRot, float yRot, float zRot) {
        rightLimb.f_104203_ = xRot;
        rightLimb.f_104204_ = yRot;
        rightLimb.f_104205_ = zRot;
        leftLimb.f_104203_ = xRot;
        leftLimb.f_104204_ = -yRot;
        leftLimb.f_104205_ = -zRot;
    }

    private static void slerpArrays(float[] a, float[] b, float[] c, float x) {
        if (a.length != b.length || b.length != c.length) {
            throw new IllegalArgumentException();
        }
        if (x <= 0.0f) {
            System.arraycopy(a, 0, c, 0, a.length);
            return;
        }
        if (x >= 1.0f) {
            System.arraycopy(b, 0, c, 0, a.length);
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = DragonAnimator.terpSmoothStep(a[i], b[i], x);
        }
    }

    private static float terpSmoothStep(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        x = x * x * (3.0f - 2.0f * x);
        return a * (1.0f - x) + b * x;
    }

    private static void splineArrays(float x, boolean shift, float[] result, float[] ... nodes) {
        int i1 = (int)x % nodes.length;
        int i2 = (i1 + 1) % nodes.length;
        int i3 = (i1 + 2) % nodes.length;
        float[] a1 = nodes[i1];
        float[] a2 = nodes[i2];
        float[] a3 = nodes[i3];
        float xn = x % (float)nodes.length - (float)i1;
        if (shift) {
            DragonAnimator.terpCatmullRomSpline(xn, result, a2, a3, a1, a2);
        } else {
            DragonAnimator.terpCatmullRomSpline(xn, result, a1, a2, a3, a1);
        }
    }

    private static void terpCatmullRomSpline(float x, float[] result, float[] ... knots) {
        int nknots = knots.length;
        int nspans = nknots - 3;
        int knot = 0;
        if (nspans < 1) {
            throw new IllegalArgumentException("Spline has too few knots");
        }
        int span = (int)(x = Mth.m_14036_((float)x, (float)0.0f, (float)0.9999f) * (float)nspans);
        if (span >= nknots - 3) {
            span = nknots - 3;
        }
        x -= (float)span;
        knot += span;
        int dimension = result.length;
        for (int i = 0; i < dimension; ++i) {
            float knot0 = knots[knot][i];
            float knot1 = knots[knot + 1][i];
            float knot2 = knots[knot + 2][i];
            float knot3 = knots[knot + 3][i];
            float c3 = CR[0][0] * knot0 + CR[0][1] * knot1 + CR[0][2] * knot2 + CR[0][3] * knot3;
            float c2 = CR[1][0] * knot0 + CR[1][1] * knot1 + CR[1][2] * knot2 + CR[1][3] * knot3;
            float c1 = CR[2][0] * knot0 + CR[2][1] * knot1 + CR[2][2] * knot2 + CR[2][3] * knot3;
            float c0 = CR[3][0] * knot0 + CR[3][1] * knot1 + CR[3][2] * knot2 + CR[3][3] * knot3;
            result[i] = ((c3 * x + c2) * x + c1) * x + c0;
        }
    }
}

