/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.abilities;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.abilities.FootprintAbility;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ReaperStepAbility
extends FootprintAbility
implements Ability.Factory<ReaperStepAbility> {
    public static final ReaperStepAbility INSTANCE = new ReaperStepAbility();
    public static final Codec<ReaperStepAbility> CODEC = Codec.unit((Object)INSTANCE);
    public static final TagKey<Block> PLANT_DEATH_TAG = BlockTags.create((ResourceLocation)DragonMountsLegacy.id("reaper_plant_death"));
    public static final TagKey<Block> PLANT_DESTRUCTION_TAG = BlockTags.create((ResourceLocation)DragonMountsLegacy.id("reaper_plant_destruction"));
    public static final TagKey<Block> REAPER_TRANSFORM = BlockTags.create((ResourceLocation)DragonMountsLegacy.id("reaper_transform"));

    @Override
    protected void placeFootprint(TameableDragon dragon, BlockPos pos) {
        Level level = dragon.m_9236_();
        BlockState steppingOn = level.m_8055_(pos);
        if (steppingOn.m_204336_(PLANT_DEATH_TAG)) {
            level.m_7471_(pos, false);
            level.m_5594_(null, pos, SoundEvents.f_11937_, dragon.m_5720_(), 0.1f, 2.0f);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0, 0.0, 1.0, 0.0, 0.05);
            BlockState bs = (dragon.m_217043_().m_188500_() < 0.05 ? Blocks.f_50070_ : Blocks.f_50036_).m_49966_();
            level.m_7731_(pos, bs, 3);
        } else if (steppingOn.m_204336_(PLANT_DESTRUCTION_TAG)) {
            level.m_46961_(pos, false);
            level.m_5594_(null, pos, SoundEvents.f_11937_, dragon.m_5720_(), 0.1f, 2.0f);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0, 0.0, 1.0, 0.0, 0.05);
            ItemEntity sticks = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42398_));
            sticks.m_32010_(40);
            level.m_7967_((Entity)sticks);
        } else {
            steppingOn = level.m_8055_(pos = pos.m_7495_());
            if (steppingOn.m_204336_(REAPER_TRANSFORM)) {
                if (steppingOn.m_60713_(Blocks.f_50440_)) {
                    ReaperStepAbility.destroyAndReplace(level, Blocks.f_50493_.m_49966_(), pos);
                } else if (steppingOn.m_204336_(BlockTags.f_13029_)) {
                    ReaperStepAbility.destroyAndReplace(level, Blocks.f_50135_.m_49966_(), pos);
                } else if (steppingOn.m_204336_(BlockTags.f_144274_)) {
                    ReaperStepAbility.destroyAndReplace(level, Blocks.f_50136_.m_49966_(), pos);
                }
            }
        }
    }

    @Override
    protected float getFootprintChance(TameableDragon dragon) {
        return 0.025f;
    }

    private static void destroyAndReplace(Level level, BlockState state, BlockPos pos) {
        level.m_46961_(pos, false);
        level.m_7731_(pos, state, 3);
    }

    @Override
    public ReaperStepAbility create() {
        return this;
    }

    @Override
    public ResourceLocation type() {
        return REAPER_STEP;
    }
}

