/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.client.MountCameraManager;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="dragonmounts")
public class ForgeModImpl {
    public static final SimpleChannel NETWORK;

    public ForgeModImpl() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DMLRegistry.init(bus);
        BreedRegistry.DEFERRED_REGISTRY.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DMLConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DMLConfig.CLIENT_SPEC);
        ForgeModImpl.setupEvents();
    }

    private static void setupEvents() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(e -> e.setCanceled(DragonMountsLegacy.overrideVanillaDragonEgg(e.getLevel(), e.getPos(), e.getEntity())));
        bus.addListener(e -> DragonMountsLegacy.registerReloadListeners(arg_0 -> ((AddReloadListenerEvent)e).addListener(arg_0)));
        modBus.addListener(e -> DragonMountsLegacy.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)e).put(arg_0, arg_1)));
        if (FMLLoader.getDist() == Dist.CLIENT) {
            bus.addListener(e -> DragonMountsLegacy.clientTick(e.phase == TickEvent.Phase.START));
            bus.addListener(e -> MountCameraManager.setMountCameraAngles(e.getCamera()));
            bus.addListener(e -> DragonMountsLegacy.onKeyPress(e.getKey(), e.getAction(), e.getModifiers()));
            modBus.addListener(e -> DragonMountsLegacy.registerRenderers());
            modBus.addListener(e -> DragonMountsLegacy.defineBlockModels(arg_0 -> ((ModelEvent.RegisterAdditional)e).register(arg_0)));
            modBus.addListener(e -> DragonMountsLegacy.registerItemColors(e.getItemColors()));
            modBus.addListener(e -> e.enqueueWork(DragonMountsLegacy::registerReloadListenersEarly));
            modBus.addListener(e -> DragonMountsLegacy.registerKeyBindings(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0)));
        }
    }

    static {
        String PROTOCOL_VERSION = "1.O";
        NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)DragonMountsLegacy.id("network")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

