/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.client.DragonEggRenderer;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.client.DragonRenderer;
import com.github.kay9.dragonmounts.client.EggEntityRenderer;
import com.github.kay9.dragonmounts.client.KeyMappings;
import com.github.kay9.dragonmounts.client.MountControlsMessenger;
import com.github.kay9.dragonmounts.data.CrossBreedingManager;
import com.github.kay9.dragonmounts.data.model.DragonModelPropertiesListener;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final Logger LOG = LogManager.getLogger((String)"dragonmounts");

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static void registerRenderers() {
        EntityRenderers.m_174036_((EntityType)((EntityType)DMLRegistry.DRAGON.get()), DragonRenderer::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)DragonRenderer.MODEL_LOCATION, () -> DragonModel.createBodyLayer(DragonModel.Properties.STANDARD));
        EntityRenderers.m_174036_((EntityType)((EntityType)DMLRegistry.DRAGON_EGG.get()), EggEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DMLRegistry.EGG_BLOCK_ENTITY.get()), DragonEggRenderer::instance);
    }

    static void defineBlockModels(Consumer<ResourceLocation> registrar) {
        String dir = "models/block/dragon_eggs";
        int length = "models/".length();
        int suffixLength = ".json".length();
        for (ResourceLocation rl : Minecraft.m_91087_().m_91098_().m_214159_(dir, f -> f.m_135815_().endsWith(".json")).keySet()) {
            String path = rl.m_135815_();
            path = path.substring(length, path.length() - suffixLength);
            ResourceLocation model = new ResourceLocation(rl.m_135827_(), path);
            String id = path.substring("block/dragon_eggs/".length(), path.length() - "_dragon_egg".length());
            registrar.accept(model);
            DragonEggRenderer.MODEL_CACHE.put(new ResourceLocation(rl.m_135827_(), id), model);
        }
    }

    static void registerItemColors(ItemColors colors) {
        colors.m_92689_(DragonSpawnEgg::getColor, new ItemLike[]{(ItemLike)DMLRegistry.SPAWN_EGG.get()});
    }

    static void registerReloadListenersEarly() {
        if (Minecraft.m_91087_() != null) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)DragonModelPropertiesListener.INSTANCE);
        }
    }

    static void registerKeyBindings(Consumer<KeyMapping> registrar) {
        KeyMappings.registerKeybinds(registrar);
    }

    static void registerReloadListeners(Consumer<PreparableReloadListener> registrar) {
        registrar.accept((PreparableReloadListener)CrossBreedingManager.INSTANCE);
    }

    static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> registrar) {
        registrar.accept((EntityType<? extends LivingEntity>)((EntityType)DMLRegistry.DRAGON.get()), TameableDragon.createAttributes().m_22265_());
    }

    static boolean overrideVanillaDragonEgg(Level level, BlockPos pos, Player player) {
        Optional end;
        if (DMLConfig.allowEggOverride() && level.m_8055_(pos).m_60713_(Blocks.f_50260_) && (end = BreedRegistry.registry(level.m_5962_()).m_123009_(DragonBreed.BuiltIn.END)).isPresent()) {
            if (level.f_46443_) {
                player.m_6674_(InteractionHand.MAIN_HAND);
            } else {
                DMLEggBlock.startHatching((DragonBreed)end.get(), level, pos);
            }
            return true;
        }
        return false;
    }

    static void clientTick(boolean head) {
        if (!head) {
            MountControlsMessenger.tick();
        }
    }

    static void onKeyPress(int key, int action, int modifiers) {
        KeyMappings.handleKeyPress(key, action);
    }
}

