/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.dynamicresources.UVController;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;

public class ModelBakeryHelpers {
    public static final int MAX_BAKED_MODEL_COUNT = 10000;
    public static final int MAX_UNBAKED_MODEL_COUNT = 10000;
    public static final int MAX_MODEL_LIFETIME_SECS = 300;
    private static final int ERROR_THRESHOLD = 200;
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static String[] getExtraTextureFolders() {
        return new String[]{"attachment", "bettergrass", "block", "blocks", "cape", "entity/bed", "entity/chest", "item", "items", "model", "models", "part", "pipe", "ropebridge", "runes", "solid_block", "spell_effect", "spell_projectile"};
    }

    private static JsonElement parseStream(InputStream stream) {
        JsonParser parser = new JsonParser();
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        jsonReader.setLenient(true);
        return parser.parse(jsonReader);
    }

    private static void gatherAdditionalViaManualScan(List<PackResources> untrustedPacks, Set<ResourceLocation> knownLocations, Collection<ResourceLocation> uncertainLocations, String filePrefix) {
        if (untrustedPacks.size() > 0) {
            FallbackResourceManager frm = new FallbackResourceManager(PackType.CLIENT_RESOURCES, "dummy");
            for (int i = untrustedPacks.size() - 1; i >= 0; --i) {
                frm.m_215377_(untrustedPacks.get(i));
            }
            for (ResourceLocation blockstate : uncertainLocations) {
                ResourceLocation fileLocation;
                Optional resource;
                if (knownLocations.contains(blockstate) || !(resource = frm.m_213713_(fileLocation = new ResourceLocation(blockstate.m_135827_(), filePrefix + blockstate.m_135815_() + ".json"))).isPresent()) continue;
                knownLocations.add(blockstate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logOrSuppressError(Object2IntOpenHashMap<String> suppressionMap, String type, ResourceLocation location, Throwable e) {
        int numErrors;
        Object2IntOpenHashMap<String> object2IntOpenHashMap = suppressionMap;
        synchronized (object2IntOpenHashMap) {
            numErrors = suppressionMap.computeInt((Object)location.m_135827_(), (k, oldVal) -> oldVal == null ? 1 : oldVal + 1);
        }
        if (numErrors <= 200) {
            ModernFix.LOGGER.error("Error reading {} {}: {}", (Object)type, (Object)location, (Object)e);
        }
    }

    private static void checkFallbacks(MultiPackResourceManager manager, List<PackResources> resourcePackList) {
        ReferenceOpenHashSet knownPacks = new ReferenceOpenHashSet(resourcePackList);
        Map namespacedMap = manager.f_203794_;
        namespacedMap.values().stream().flatMap(FallbackResourceManager::m_7536_).forEach(arg_0 -> ModelBakeryHelpers.lambda$checkFallbacks$1((ReferenceSet)knownPacks, resourcePackList, arg_0));
    }

    public static void gatherModelMaterials(ResourceManager manager, Predicate<PackResources> isTrustedPack, Set<Material> materialSet, Set<ResourceLocation> blockStateFiles, Set<ResourceLocation> modelFiles, UnbakedModel missingModel, Function<JsonElement, BlockModel> modelDeserializer, Function<ResourceLocation, UnbakedModel> bakeryModelGetter) {
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object2IntOpenHashMap blockstateErrors = new Object2IntOpenHashMap();
        ArrayList<PackResources> allPackResources = new ArrayList<PackResources>(manager.m_7536_().collect(Collectors.toList()));
        if (manager instanceof MultiPackResourceManager) {
            ModelBakeryHelpers.checkFallbacks((MultiPackResourceManager)manager, allPackResources);
        }
        Collections.reverse(allPackResources);
        ObjectOpenHashSet allAvailableModels = new ObjectOpenHashSet();
        ObjectOpenHashSet allAvailableStates = new ObjectOpenHashSet();
        for (PackResources pack2 : allPackResources) {
            try {
                InputStream stream = pack2.m_8031_(PackType.CLIENT_RESOURCES, new ResourceLocation("modernfix", "dummy.json"));
                if (stream == null) continue;
                stream.close();
            }
            catch (Exception stream) {}
        }
        allPackResources.removeIf(pack -> {
            for (String namespace : pack.m_5698_(PackType.CLIENT_RESOURCES)) {
                Collection allBlockstates = pack.m_214146_(PackType.CLIENT_RESOURCES, namespace, "blockstates", p -> p.m_135815_().endsWith(".json"));
                for (ResourceLocation blockstate : allBlockstates) {
                    allAvailableStates.add((Object)new ResourceLocation(blockstate.m_135827_(), blockstate.m_135815_().replaceFirst("blockstates/", "").replace(".json", "")));
                }
                Collection allModels = pack.m_214146_(PackType.CLIENT_RESOURCES, namespace, "models", p -> p.m_135815_().endsWith(".json"));
                for (ResourceLocation blockstate : allModels) {
                    allAvailableModels.add((Object)new ResourceLocation(blockstate.m_135827_(), blockstate.m_135815_().replaceFirst("models/", "").replace(".json", "")));
                }
            }
            if (!isTrustedPack.test((PackResources)pack)) {
                ModernFix.LOGGER.debug("Pack with class {} needs manual scan", (Object)pack.getClass().getName());
                return false;
            }
            return true;
        });
        ModelBakeryHelpers.gatherAdditionalViaManualScan(allPackResources, (Set<ResourceLocation>)allAvailableStates, blockStateFiles, "blockstates/");
        blockStateFiles.retainAll((Collection<?>)allAvailableStates);
        allAvailableStates.clear();
        allAvailableStates.trim();
        ConcurrentLinkedQueue blockStateLoadedFiles = new ConcurrentLinkedQueue();
        ArrayList<CompletableFuture<Void>> blockStateData = new ArrayList<CompletableFuture<Void>>();
        for (ResourceLocation blockstate : blockStateFiles) {
            ResourceLocation fileLocation = new ResourceLocation(blockstate.m_135827_(), "blockstates/" + blockstate.m_135815_() + ".json");
            List resources = manager.m_213829_(fileLocation);
            if (resources.isEmpty()) continue;
            blockStateData.add(CompletableFuture.runAsync(() -> {
                try {
                    for (Resource resource : resources) {
                        JsonParser parser = new JsonParser();
                        try {
                            InputStream stream = resource.m_215507_();
                            try {
                                blockStateLoadedFiles.add(Pair.of((Object)blockstate, (Object)ModelBakeryHelpers.parseStream(stream)));
                            }
                            finally {
                                if (stream == null) continue;
                                stream.close();
                            }
                        }
                        catch (JsonParseException e) {
                            ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, e);
                        }
                    }
                }
                catch (IOException e) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, e);
                }
            }, ModernFix.resourceReloadExecutor()));
        }
        blockStateFiles = null;
        CompletableFuture.allOf(blockStateData.toArray(new CompletableFuture[0])).join();
        for (Pair pair : blockStateLoadedFiles) {
            if (pair.getSecond() == null) continue;
            try {
                JsonObject obj = ((JsonElement)pair.getSecond()).getAsJsonObject();
                if (obj.has("variants")) {
                    JsonObject eachVariant = obj.getAsJsonObject("variants");
                    for (Map.Entry entry2 : eachVariant.entrySet()) {
                        List<Object> variantModels;
                        JsonElement variantData = (JsonElement)entry2.getValue();
                        if (variantData.isJsonArray()) {
                            variantModels = new ArrayList();
                            for (JsonElement jsonElement : variantData.getAsJsonArray()) {
                                variantModels.add(jsonElement.getAsJsonObject());
                            }
                        } else {
                            variantModels = Collections.singletonList(variantData.getAsJsonObject());
                        }
                        for (JsonObject jsonObject : variantModels) {
                            modelFiles.add(new ResourceLocation(jsonObject.get("model").getAsString()));
                        }
                    }
                    continue;
                }
                JsonArray multipartData = obj.get("multipart").getAsJsonArray();
                for (JsonElement element : multipartData) {
                    List<Object> applyObjects;
                    JsonObject self = element.getAsJsonObject();
                    JsonElement apply = self.get("apply");
                    if (apply.isJsonArray()) {
                        applyObjects = new ArrayList();
                        for (JsonElement jsonElement : apply.getAsJsonArray()) {
                            applyObjects.add(jsonElement.getAsJsonObject());
                        }
                    } else {
                        applyObjects = Collections.singletonList(apply.getAsJsonObject());
                    }
                    for (JsonObject jsonObject : applyObjects) {
                        modelFiles.add(new ResourceLocation(jsonObject.get("model").getAsString()));
                    }
                }
            }
            catch (RuntimeException e) {
                ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", (ResourceLocation)pair.getFirst(), e);
            }
        }
        blockstateErrors.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 200) {
                ModernFix.LOGGER.error("Suppressed additional {} blockstate errors for domain {}", (Object)entry.getIntValue(), entry.getKey());
            }
        });
        blockstateErrors.clear();
        blockStateData = null;
        blockStateLoadedFiles.clear();
        modelFiles.addAll((Collection<ResourceLocation>)allAvailableModels);
        ModelBakeryHelpers.gatherAdditionalViaManualScan(allPackResources, (Set<ResourceLocation>)allAvailableModels, modelFiles, "models/");
        modelFiles.retainAll((Collection<?>)allAvailableModels);
        allAvailableModels.clear();
        allAvailableModels.trim();
        HashMap<Object, BlockModel> basicModels = new HashMap<Object, BlockModel>();
        basicModels.put(ModelBakery.f_119230_, (BlockModel)missingModel);
        basicModels.put(new ResourceLocation("builtin/generated"), ModelBakery.f_119232_);
        basicModels.put(new ResourceLocation("builtin/entity"), ModelBakery.f_119233_);
        LinkedHashSet errorSet = Sets.newLinkedHashSet();
        while (modelFiles.size() > 0) {
            ArrayList<CompletableFuture<Pair>> modelBytes = new ArrayList<CompletableFuture<Pair>>();
            for (ResourceLocation resourceLocation : modelFiles) {
                if (basicModels.containsKey(resourceLocation)) continue;
                ResourceLocation fileLocation = new ResourceLocation(resourceLocation.m_135827_(), "models/" + resourceLocation.m_135815_() + ".json");
                modelBytes.add(CompletableFuture.supplyAsync(() -> {
                    Pair pair;
                    block8: {
                        Optional resource = manager.m_213713_(fileLocation);
                        InputStream stream = ((Resource)resource.orElseThrow()).m_215507_();
                        try {
                            pair = Pair.of((Object)model, (Object)ModelBakeryHelpers.parseStream(stream));
                            if (stream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (JsonParseException | IOException | NoSuchElementException e) {
                                ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "model", fileLocation, e);
                                return Pair.of((Object)fileLocation, null);
                            }
                        }
                        stream.close();
                    }
                    return pair;
                }, ModernFix.resourceReloadExecutor()));
            }
            modelFiles.clear();
            CompletableFuture.allOf(modelBytes.toArray(new CompletableFuture[0])).join();
            UVController.useDummyUv.set(Boolean.TRUE);
            for (CompletableFuture completableFuture : modelBytes) {
                Pair pair = (Pair)completableFuture.join();
                try {
                    if (pair.getSecond() != null) {
                        BlockModel model = modelDeserializer.apply((JsonElement)pair.getSecond());
                        model.f_111416_ = ((ResourceLocation)pair.getFirst()).toString();
                        modelFiles.addAll(model.m_7970_());
                        basicModels.put((ResourceLocation)pair.getFirst(), model);
                        continue;
                    }
                }
                catch (Throwable e) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "model", (ResourceLocation)pair.getFirst(), e);
                }
                basicModels.put((ResourceLocation)pair.getFirst(), (BlockModel)missingModel);
            }
            UVController.useDummyUv.set(Boolean.FALSE);
        }
        blockstateErrors.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 200) {
                ModernFix.LOGGER.error("Suppressed additional {} model errors for domain {}", (Object)entry.getIntValue(), entry.getKey());
            }
        });
        blockstateErrors.clear();
        modelFiles = null;
        Function<ResourceLocation, UnbakedModel> modelGetter = loc -> {
            UnbakedModel m = (UnbakedModel)basicModels.get(loc);
            return m != null ? m : (UnbakedModel)bakeryModelGetter.apply((ResourceLocation)loc);
        };
        for (BlockModel blockModel : basicModels.values()) {
            try {
                materialSet.addAll(blockModel.m_5500_(modelGetter, (Set)errorSet));
            }
            catch (Throwable e) {
                ModernFix.LOGGER.error("Model {} threw error while getting materials", (Object)blockModel.f_111416_, (Object)e);
            }
        }
        stopwatch.stop();
        ModernFix.LOGGER.info("Resolving model textures took " + stopwatch);
    }

    private static <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.m_61124_(prop, (Comparable)o);
    }

    private static <T extends Comparable<T>> T getValueHelper(Property<T> property, String value) {
        return (T)((Comparable)property.m_6215_(value).orElse(null));
    }

    public static ImmutableList<BlockState> getBlockStatesForMRL(StateDefinition<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        if (Objects.equals(location.m_119448_(), "inventory")) {
            return ImmutableList.of();
        }
        HashSet<Property> fixedProperties = new HashSet<Property>();
        BlockState fixedState = (BlockState)stateDefinition.m_61090_();
        for (String s : COMMA_SPLITTER.split((CharSequence)location.m_119448_())) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property property = stateDefinition.m_61081_(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object value = ModelBakeryHelpers.getValueHelper(property, s2);
                if (value == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + property.m_6908_());
                }
                fixedState = ModelBakeryHelpers.setPropertyGeneric(fixedState, property, value);
                fixedProperties.add(property);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        if (fixedProperties.size() == stateDefinition.m_61092_().size()) {
            return ImmutableList.of((Object)fixedState);
        }
        ArrayList anyProperties = new ArrayList(stateDefinition.m_61092_());
        anyProperties.removeAll(fixedProperties);
        ArrayList<BlockState> finalList = new ArrayList<BlockState>();
        finalList.add(fixedState);
        for (Property property : anyProperties) {
            ArrayList<BlockState> newPermutations = new ArrayList<BlockState>();
            for (BlockState state : finalList) {
                for (Comparable value : property.m_6908_()) {
                    newPermutations.add(ModelBakeryHelpers.setPropertyGeneric(state, property, value));
                }
            }
            finalList = newPermutations;
        }
        return ImmutableList.copyOf(finalList);
    }

    public static ModernFixClientIntegration bakedModelWrapper(final BiFunction<ResourceLocation, Pair<UnbakedModel, BakedModel>, BakedModel> consumer) {
        return new ModernFixClientIntegration(){

            @Override
            public BakedModel onBakedModelLoad(ResourceLocation location, UnbakedModel baseModel, BakedModel originalModel, ModelState state, ModelBakery bakery) {
                return (BakedModel)consumer.apply(location, Pair.of((Object)baseModel, (Object)originalModel));
            }
        };
    }

    private static /* synthetic */ void lambda$checkFallbacks$1(ReferenceSet knownPacks, List resourcePackList, PackResources pack) {
        if (knownPacks.add((Object)pack)) {
            ModernFix.LOGGER.debug("Injecting unlisted pack '{}': {}", (Object)pack.m_8017_(), (Object)pack.getClass().getName());
            resourcePackList.add(pack);
        }
    }
}

