/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.forge;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import immersive_armors.Items;
import immersive_armors.config.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class LootProvider {
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"immersive_armors");
    private static final RegistryObject<Codec<ImmersiveArmorsLootModifier>> ARMOR_MODIFIER_SERIALIZER = GLM.register("armor_modifier_serializer", ImmersiveArmorsLootModifier.CODEC);

    public static void initialize() {
        if (Config.getInstance().lootChance > 0.0f) {
            GLM.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }

    private static class ImmersiveArmorsLootModifier
    extends LootModifier {
        public static final Supplier<Codec<ImmersiveArmorsLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ImmersiveArmorsLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ImmersiveArmorsLootModifier::new)));

        public ImmersiveArmorsLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ResourceLocation id = context.getQueriedLootTableId();
            if (Items.lootLookup.containsKey(id.toString())) {
                for (Map.Entry<Supplier<Item>, Float> entry : Items.lootLookup.get(id.toString()).entrySet()) {
                    if (!(context.m_78952_().m_213780_().m_188501_() < entry.getValue().floatValue() * Config.getInstance().lootChance)) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)entry.getKey().get()));
                }
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class DataProvider
    extends GlobalLootModifierProvider {
        public DataProvider(DataGenerator gen, String modId) {
            super(gen, modId);
        }

        protected void start() {
            for (String s : Items.lootLookup.keySet()) {
                this.add("armor_modifier_serializer_" + s, (IGlobalLootModifier)new ImmersiveArmorsLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(s)).m_6409_()}));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immersive_armors", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlers {
        @SubscribeEvent
        public static void runData(GatherDataEvent event) {
            if (Config.getInstance().lootChance > 0.0f) {
                event.getGenerator().m_236039_(event.includeServer(), (net.minecraft.data.DataProvider)new DataProvider(event.getGenerator(), "immersive_armors"));
            }
        }
    }
}

