/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages.crt;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.zencode.util.PositionUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.darkhax.itemstages.Restriction;
import net.darkhax.itemstages.crt.actions.ActionCreateRestriction;
import net.minecraft.core.Registry;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.itemstages.ItemStages")
public class ZenItemStages {
    @ZenCodeType.Method
    public static Restriction restrict(Enchantment enchantment, String ... requiredStages) {
        return ZenItemStages.restrict(enchantment, true, true, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Enchantment enchantment, boolean checkBook, boolean checkItem, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> ZenItemStages.hasEnchantment(stack, enchantment, checkBook, checkItem), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String modid, String ... requiredStages) {
        return ZenItemStages.createModRestriction(modid, null, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String[] modids, String ... requiredStages) {
        return ZenItemStages.createModRestriction(modids, null, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String modid, @Nullable Predicate<IItemStack> filter, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> modid.equalsIgnoreCase(Registry.f_122827_.m_7981_((Object)stack.m_41720_()).m_135827_()) && (filter == null || !filter.test((IItemStack)new MCItemStack(stack))), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String[] modids, @Nullable Predicate<IItemStack> filter, String ... requiredStages) {
        Set restrictedModIds = Arrays.stream(modids).collect(Collectors.toSet());
        return ZenItemStages.restrictInternal(stack -> restrictedModIds.contains(Registry.f_122827_.m_7981_((Object)stack.m_41720_()).m_135827_()) && (filter == null || !filter.test((IItemStack)new MCItemStack(stack))), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Rarity rarity, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> stack.m_41791_() == rarity, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(IIngredient ingredient, String ... requiredStages) {
        return ZenItemStages.restrictInternal((Predicate<ItemStack>)ingredient.asVanillaIngredient(), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Predicate<IItemStack> predicate, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> predicate.test((IItemStack)new MCItemStack(stack)), requiredStages);
    }

    private static Restriction restrictInternal(Predicate<ItemStack> condition, String[] requiredStages) {
        return ZenItemStages.create(requiredStages).restrict(condition);
    }

    @ZenCodeType.Method
    public static Restriction create(String ... requiredStages) {
        if (requiredStages.length == 0) {
            throw new IllegalStateException("[ItemStages] A restriction was created with no stages specified. This is not supported! " + PositionUtil.getZCScriptPositionFromStackTrace());
        }
        Restriction restriction = new Restriction(requiredStages);
        ActionCreateRestriction.apply(restriction);
        return restriction;
    }

    private static boolean hasEnchantment(ItemStack stack, Enchantment enchantment, boolean checkBook, boolean checkItem) {
        if (stack.m_41782_()) {
            if (checkBook && stack.m_41720_() instanceof EnchantedBookItem && EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(enchantment, 0) > 0) {
                return true;
            }
            return checkItem && EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack) > 0;
        }
        return false;
    }
}

